/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths.wavelet.daubechies5;

import JSci.maths.ArrayMath;
import JSci.maths.NumericalConstants;
import JSci.maths.WaveletMath;
import JSci.maths.wavelet.Cascades;
import JSci.maths.wavelet.Filter;
import JSci.maths.wavelet.IllegalScalingException;
import JSci.maths.wavelet.Multiresolution;
import JSci.maths.wavelet.MultiscaleFunction;
import JSci.maths.wavelet.daubechies5.Scaling5;
import JSci.maths.wavelet.daubechies5.Wavelet5;

public final class Daubechies5
extends Multiresolution
implements Filter,
NumericalConstants {
    protected static final int filtretype = 8;
    protected static final int minlength = 16;
    static final double[] vg = new double[]{0.0386547959548, 0.0417468644215, -0.0553441861166, 0.281990696854, 1.02305296689, 0.89658164838, 0.0234789231361, -0.247951362613, -0.0298424998687, 0.0276321529578};
    static final double[] v0temp = new double[]{0.5149588736, 0.8572148847};
    static final double[] v1temp = new double[]{-0.07062608421, 0.04242755162, -0.9680855135, 0.2366902992};
    static final double[] v2temp = new double[]{0.1166375834, -0.07006826369, 0.02569251462, 0.1524482921, -0.89883778, 0.3868800469};
    static final double[] v3temp = new double[]{0.4678469852, -0.2810519985, 0.08265463674, 0.5280457443, 0.08615307089, -0.2053530811, -0.4422572318, 0.4138613016};
    static final double[] v4temp = new double[]{-0.1341363044, 0.08058035557, -0.03810281736, -0.2103133707, 0.03026059798, 0.2107415482, -0.855385173, -0.3335028061, -0.1496490635, 0.1385649939};
    static final double[] v5temp = new double[]{-0.2809362553, 0.1687682052, -0.04001455131, -0.2777441959, 0.009006724682, 0.2482896416, -0.09917949547, 0.8098971461, -0.258232389, -0.1241046836, -0.04791583558, 0.04436684941};
    static final double[] v6temp = new double[]{-0.08360649632, 0.05022533782, -0.01533783538, -0.09668361515, -0.004952912706, 0.06191148032, -0.05197035907, 0.2312568194, 0.6976664051, 0.6350643725, 0.01189068293, -0.172726034, -0.02133407205, 0.01975391957};
    static final double[] v7temp = new double[]{-0.001591308791, 9.559546817E-4, 3.515007474E-4, 7.914817671E-4, -0.001039035431, -0.002096326217, 0.02722494187, 0.02963704669, -0.03930998378, 0.1995579157, 0.7233513164, 0.6339755574, 0.0165942076, -0.1753213559, -0.02110191042, 0.01953895348};
    static final double[] vd0temp = new double[]{0.9116496405, 0.410968287};
    static final double[] vd1temp = new double[]{-0.1759262671, 0.3902566773, 0.6301011968, 0.6478596732};
    static final double[] vd2temp = new double[]{2.82537961E-4, -6.267530579E-4, 0.4175827162, -0.405682094, 0.6289312762, 0.5152588582};
    static final double[] vd3temp = new double[]{-0.05113299639, 0.1134281628, 0.4836999717, -0.5526531145, -0.2269223725, -0.549980074, 0.2214856571, 0.2051843068};
    static final double[] vd4temp = new double[]{0.002756002147, -0.006113630773, -0.146081957, 0.146508817, 0.165494054, 0.03172833766, 0.9500926016, -0.0144497126, 0.1180200176, 0.1092786192};
    static final double[] vd5temp = new double[]{0.01425700173, -0.03162626148, -0.07075177701, 0.09173486581, -0.06745433251, 0.2118550693, -0.01051600438, 0.9395202801, 0.1694709068, -0.1464208651, 0.04001747247, 0.03705349502};
    static final double[] vd6temp = new double[]{-0.001315787444, 0.00291880709, 0.01730939444, -0.01895045515, -0.00153786985, -0.02706707215, -0.1556669346, -6.193750436E-6, 0.6330645158, 0.7286274296, 0.1987062136, -0.03988654553, 0.02953429005, 0.02734677134};
    static final double[] vd7temp = new double[]{-8.561071719E-5, 1.899099809E-4, -9.013424188E-7, -1.367686226E-4, -3.59993373E-4, 3.327378221E-4, 0.01961899121, -0.0211764969, -0.1753299891, 0.01662647625, 0.6339762696, 0.7234044479, 0.1993976399, -0.03913415866, 0.02951949191, 0.02733306926};
    static final double[] v0 = ArrayMath.scalarMultiply((double)1.4142135623730951, (double[])v0temp);
    static final double[] v1 = ArrayMath.scalarMultiply((double)1.4142135623730951, (double[])v1temp);
    static final double[] v2 = ArrayMath.scalarMultiply((double)1.4142135623730951, (double[])v2temp);
    static final double[] v3 = ArrayMath.scalarMultiply((double)1.4142135623730951, (double[])v3temp);
    static final double[] v4 = ArrayMath.scalarMultiply((double)1.4142135623730951, (double[])v4temp);
    static final double[] v5 = ArrayMath.scalarMultiply((double)1.4142135623730951, (double[])v5temp);
    static final double[] v6 = ArrayMath.scalarMultiply((double)1.4142135623730951, (double[])v6temp);
    static final double[] v7 = ArrayMath.scalarMultiply((double)1.4142135623730951, (double[])v7temp);
    static final double[] vd0 = ArrayMath.invert((double[])ArrayMath.scalarMultiply((double)1.4142135623730951, (double[])vd0temp));
    static final double[] vd1 = ArrayMath.invert((double[])ArrayMath.scalarMultiply((double)1.4142135623730951, (double[])vd1temp));
    static final double[] vd2 = ArrayMath.invert((double[])ArrayMath.scalarMultiply((double)1.4142135623730951, (double[])vd2temp));
    static final double[] vd3 = ArrayMath.invert((double[])ArrayMath.scalarMultiply((double)1.4142135623730951, (double[])vd3temp));
    static final double[] vd4 = ArrayMath.invert((double[])ArrayMath.scalarMultiply((double)1.4142135623730951, (double[])vd4temp));
    static final double[] vd5 = ArrayMath.invert((double[])ArrayMath.scalarMultiply((double)1.4142135623730951, (double[])vd5temp));
    static final double[] vd6 = ArrayMath.invert((double[])ArrayMath.scalarMultiply((double)1.4142135623730951, (double[])vd6temp));
    static final double[] vd7 = ArrayMath.invert((double[])ArrayMath.scalarMultiply((double)1.4142135623730951, (double[])vd7temp));
    static final double[] vgtemp = ArrayMath.scalarMultiply((double)0.7071067811865475, (double[])vg);
    static final double[] phvg = WaveletMath.lowToHigh((double[])vgtemp);
    static final double[] phv0 = new double[]{0.6182708675, -0.3714168701, -0.1886088129, -0.5203639573, 0.1728721711, 0.3655404713, 0.09964278013, 0.002321755628, 8.29775206E-5, -7.683163866E-5};
    static final double[] phv1 = new double[]{-0.09199155757, 0.05526253651, 0.1276201402, 0.4846229512, 0.3921178348, 0.7493106089, 0.1219411317, -0.0818183047, 0.02258502019, 0.004446446219, 0.003345391169, -0.003097607805};
    static final double[] phv2 = new double[]{-0.05206990422, 0.03128020722, -0.01303591078, -0.07446233534, 0.002030318262, 0.05628764191, -0.1851188211, 0.007400777444, 0.6246714288, -0.7215672985, 0.1975651316, 0.03986516515, 0.02939208418, -0.02721509824};
    static final double[] phv3 = new double[]{-0.001137543931, 6.83362307E-4, 2.512696118E-4, 5.657891708E-4, -7.427524153E-4, -0.001498554635, 0.01946169563, 0.02118598397, -0.175454139, -0.01648697186, 0.6339417098, -0.7234098228, 0.1993922999, 0.03913868175, 0.02951943631, -0.02733301778};
    static final double[] phvd0temp = new double[]{0.3667623662, -0.8135877873, 0.3605867008, 0.2389793582, 0.01721476353, -0.1262774479, 0.0135453029, 7.338813977E-4, -1.058396455E-4, -9.800040389E-5};
    static final double[] phvd1temp = new double[]{0.02440133283, -0.0541293988, 0.1933279241, -0.148796052, -0.7215807244, 0.6068591878, 0.149949436, -0.1537729673, 0.004017810927, 0.04249831221, -0.005115722859, -0.00473681619};
    static final double[] phvd2temp = new double[]{-0.002747616845, 0.006095029686, 0.02424194881, -0.02799508244, -0.005956481976, -0.03440854634, -0.01090515083, -0.2236505386, 0.7232999959, -0.6265589773, 0.01577095589, 0.1743929125, -0.0210799891, -0.0195186558};
    static final double[] phvd3temp = new double[]{-1.197613924E-4, 2.656663148E-4, -1.260893172E-6, -1.913265215E-4, -5.035970875E-4, 4.654691185E-4, 0.02744513531, -0.02962394021, -0.03913691676, -0.1993634542, 0.7234039987, -0.633983507, 0.01660226434, 0.1753282263, -0.02110183265, -0.01953888146};
    static final double[] phvd0 = ArrayMath.invert((double[])phvd0temp);
    static final double[] phvd1 = ArrayMath.invert((double[])phvd1temp);
    static final double[] phvd2 = ArrayMath.invert((double[])phvd2temp);
    static final double[] phvd3 = ArrayMath.invert((double[])phvd3temp);

    public int getFilterType() {
        return 8;
    }

    public MultiscaleFunction primaryScaling(int n, int n2) {
        return new Scaling5(n, n2);
    }

    public MultiscaleFunction dualScaling(int n, int n2) {
        return new Scaling5(n, n2);
    }

    public MultiscaleFunction primaryWavelet(int n, int n2) {
        return new Wavelet5(n, n2);
    }

    public MultiscaleFunction dualWavelet(int n, int n2) {
        return new Wavelet5(n, n2);
    }

    public int previousDimension(int n) {
        return Cascades.previousDimension(8, n);
    }

    public double[] lowpass(double[] dArray, double[] dArray2) {
        return this.lowpass(dArray);
    }

    public double[] highpass(double[] dArray, double[] dArray2) {
        return this.highpass(dArray);
    }

    public double[] lowpass(double[] dArray) {
        int n;
        int n2;
        if (dArray.length < 16) {
            throw new IllegalScalingException("The array is not long enough : " + dArray.length + " < " + 16);
        }
        double[] dArray2 = new double[2 * dArray.length - 8];
        int n3 = dArray.length - 1;
        for (n2 = 8; n2 <= n3 - 8; ++n2) {
            for (n = -5; n < 5; ++n) {
                int n4 = 2 * n2 + n - 3;
                dArray2[n4] = dArray2[n4] + vg[n + 5] * dArray[n2];
            }
        }
        dArray2 = ArrayMath.add((double[])dArray2, (double)dArray[0], (double[])v0, (int)0);
        dArray2 = ArrayMath.add((double[])dArray2, (double)dArray[1], (double[])v1, (int)0);
        dArray2 = ArrayMath.add((double[])dArray2, (double)dArray[2], (double[])v2, (int)0);
        dArray2 = ArrayMath.add((double[])dArray2, (double)dArray[3], (double[])v3, (int)0);
        dArray2 = ArrayMath.add((double[])dArray2, (double)dArray[4], (double[])v4, (int)0);
        dArray2 = ArrayMath.add((double[])dArray2, (double)dArray[5], (double[])v5, (int)0);
        dArray2 = ArrayMath.add((double[])dArray2, (double)dArray[6], (double[])v6, (int)0);
        dArray2 = ArrayMath.add((double[])dArray2, (double)dArray[7], (double[])v7, (int)0);
        n2 = dArray2.length - vd0.length;
        n = dArray2.length - vd1.length;
        int n5 = dArray2.length - vd2.length;
        int n6 = dArray2.length - vd3.length;
        int n7 = dArray2.length - vd4.length;
        int n8 = dArray2.length - vd5.length;
        int n9 = dArray2.length - vd6.length;
        int n10 = dArray2.length - vd7.length;
        dArray2 = ArrayMath.add((double[])dArray2, (double)dArray[n3], (double[])vd0, (int)n2);
        dArray2 = ArrayMath.add((double[])dArray2, (double)dArray[n3 - 1], (double[])vd1, (int)n);
        dArray2 = ArrayMath.add((double[])dArray2, (double)dArray[n3 - 2], (double[])vd2, (int)n5);
        dArray2 = ArrayMath.add((double[])dArray2, (double)dArray[n3 - 3], (double[])vd3, (int)n6);
        dArray2 = ArrayMath.add((double[])dArray2, (double)dArray[n3 - 4], (double[])vd4, (int)n7);
        dArray2 = ArrayMath.add((double[])dArray2, (double)dArray[n3 - 5], (double[])vd5, (int)n8);
        dArray2 = ArrayMath.add((double[])dArray2, (double)dArray[n3 - 6], (double[])vd6, (int)n9);
        dArray2 = ArrayMath.add((double[])dArray2, (double)dArray[n3 - 7], (double[])vd7, (int)n10);
        return dArray2;
    }

    public double[] highpass(double[] dArray) {
        int n;
        int n2;
        if (dArray.length < 8) {
            throw new IllegalScalingException("The array is not long enough : " + dArray.length + " < 8");
        }
        double[] dArray2 = new double[2 * dArray.length + 8];
        int n3 = dArray.length - 1;
        for (n2 = 4; n2 <= n3 - 4; ++n2) {
            for (n = -5; n < 5; ++n) {
                int n4 = 2 * n2 + n + 5;
                dArray2[n4] = dArray2[n4] + phvg[n + 5] * dArray[n2];
            }
        }
        dArray2 = ArrayMath.add((double[])dArray2, (double)dArray[0], (double[])phv0, (int)0);
        n2 = dArray2.length - phvd0.length;
        dArray2 = ArrayMath.add((double[])dArray2, (double)dArray[n3], (double[])phvd0, (int)n2);
        dArray2 = ArrayMath.add((double[])dArray2, (double)dArray[1], (double[])phv1, (int)0);
        n = dArray2.length - phvd1.length;
        dArray2 = ArrayMath.add((double[])dArray2, (double)dArray[n3 - 1], (double[])phvd1, (int)n);
        dArray2 = ArrayMath.add((double[])dArray2, (double)dArray[2], (double[])phv2, (int)0);
        int n5 = dArray2.length - phvd2.length;
        dArray2 = ArrayMath.add((double[])dArray2, (double)dArray[n3 - 2], (double[])phvd2, (int)n5);
        dArray2 = ArrayMath.add((double[])dArray2, (double)dArray[3], (double[])phv3, (int)0);
        int n6 = dArray2.length - phvd3.length;
        dArray2 = ArrayMath.add((double[])dArray2, (double)dArray[n3 - 3], (double[])phvd3, (int)n6);
        return dArray2;
    }

    public double[] evalScaling(int n, int n2, int n3) {
        return Cascades.evalScaling(this, n, n3, n2);
    }

    public double[] evalWavelet(int n, int n2, int n3) {
        return Cascades.evalWavelet(this, 8, n, n3, n2);
    }
}

