/*
 * Decompiled with CFR 0.152.
 */
package quickhull3d;

import java.util.Random;
import quickhull3d.Point3d;
import quickhull3d.QuickHull3D;
import quickhull3d.Vector3d;

public class QuickHull3DTest {
    private static final double DOUBLE_PREC = 2.220446049250313E-16;
    static boolean triangulate = false;
    static boolean doTesting = true;
    static boolean doTiming = false;
    static boolean debugEnable = false;
    static final int NO_DEGENERACY = 0;
    static final int EDGE_DEGENERACY = 1;
    static final int VERTEX_DEGENERACY = 2;
    Random rand = new Random();
    static boolean testRotation = true;
    static int degeneracyTest = 2;
    static double epsScale = 2.0;
    int cnt = 0;

    public QuickHull3DTest() {
        this.rand.setSeed(4660L);
    }

    public boolean faceIndicesEqual(int[] indices1, int[] indices2) {
        if (indices1.length != indices2.length) {
            return false;
        }
        int len = indices1.length;
        int j = 0;
        while (j < len) {
            if (indices1[0] == indices2[j]) break;
            ++j;
        }
        if (j == len) {
            return false;
        }
        int i = 1;
        while (i < len) {
            if (indices1[i] != indices2[(j + i) % len]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public double[] randomPoints(int num, double range) {
        double[] coords = new double[num * 3];
        int i = 0;
        while (i < num) {
            int k = 0;
            while (k < 3) {
                coords[i * 3 + k] = 2.0 * range * (this.rand.nextDouble() - 0.5);
                ++k;
            }
            ++i;
        }
        return coords;
    }

    private void randomlyPerturb(Point3d pnt, double tol) {
        pnt.x += tol * (this.rand.nextDouble() - 0.5);
        pnt.y += tol * (this.rand.nextDouble() - 0.5);
        pnt.z += tol * (this.rand.nextDouble() - 0.5);
    }

    public double[] randomDegeneratePoints(int num, int dimen) {
        double[] coords = new double[num * 3];
        Point3d pnt = new Point3d();
        Point3d base = new Point3d();
        base.setRandom(-1.0, 1.0, this.rand);
        double tol = 2.220446049250313E-16;
        if (dimen == 0) {
            int i = 0;
            while (i < num) {
                pnt.set(base);
                this.randomlyPerturb(pnt, tol);
                coords[i * 3 + 0] = pnt.x;
                coords[i * 3 + 1] = pnt.y;
                coords[i * 3 + 2] = pnt.z;
                ++i;
            }
        } else if (dimen == 1) {
            Vector3d u = new Vector3d();
            u.setRandom(-1.0, 1.0, this.rand);
            u.normalize();
            int i = 0;
            while (i < num) {
                double a = 2.0 * (this.rand.nextDouble() - 0.5);
                pnt.scale(a, u);
                pnt.add(base);
                this.randomlyPerturb(pnt, tol);
                coords[i * 3 + 0] = pnt.x;
                coords[i * 3 + 1] = pnt.y;
                coords[i * 3 + 2] = pnt.z;
                ++i;
            }
        } else {
            Vector3d nrm = new Vector3d();
            nrm.setRandom(-1.0, 1.0, this.rand);
            nrm.normalize();
            int i = 0;
            while (i < num) {
                Vector3d perp = new Vector3d();
                pnt.setRandom(-1.0, 1.0, this.rand);
                perp.scale(pnt.dot(nrm), nrm);
                pnt.sub(perp);
                pnt.add(base);
                this.randomlyPerturb(pnt, tol);
                coords[i * 3 + 0] = pnt.x;
                coords[i * 3 + 1] = pnt.y;
                coords[i * 3 + 2] = pnt.z;
                ++i;
            }
        }
        return coords;
    }

    public double[] randomSphericalPoints(int num, double radius) {
        double[] coords = new double[num * 3];
        Point3d pnt = new Point3d();
        int i = 0;
        while (i < num) {
            pnt.setRandom(-radius, radius, this.rand);
            if (!(pnt.norm() <= radius)) continue;
            coords[i * 3 + 0] = pnt.x;
            coords[i * 3 + 1] = pnt.y;
            coords[i * 3 + 2] = pnt.z;
            ++i;
        }
        return coords;
    }

    public double[] randomCubedPoints(int num, double range, double max) {
        double[] coords = new double[num * 3];
        int i = 0;
        while (i < num) {
            int k = 0;
            while (k < 3) {
                double x = 2.0 * range * (this.rand.nextDouble() - 0.5);
                if (x > max) {
                    x = max;
                } else if (x < -max) {
                    x = -max;
                }
                coords[i * 3 + k] = x;
                ++k;
            }
            ++i;
        }
        return coords;
    }

    private double[] shuffleCoords(double[] coords) {
        int num = coords.length / 3;
        int i = 0;
        while (i < num) {
            int i1 = this.rand.nextInt(num);
            int i2 = this.rand.nextInt(num);
            int k = 0;
            while (k < 3) {
                double tmp = coords[i1 * 3 + k];
                coords[i1 * 3 + k] = coords[i2 * 3 + k];
                coords[i2 * 3 + k] = tmp;
                ++k;
            }
            ++i;
        }
        return coords;
    }

    public double[] randomGridPoints(int gridSize, double width) {
        int num = gridSize * gridSize * gridSize;
        double[] coords = new double[num * 3];
        int idx = 0;
        int i = 0;
        while (i < gridSize) {
            int j = 0;
            while (j < gridSize) {
                int k = 0;
                while (k < gridSize) {
                    coords[idx * 3 + 0] = ((double)i / (double)(gridSize - 1) - 0.5) * width;
                    coords[idx * 3 + 1] = ((double)j / (double)(gridSize - 1) - 0.5) * width;
                    coords[idx * 3 + 2] = ((double)k / (double)(gridSize - 1) - 0.5) * width;
                    ++idx;
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        this.shuffleCoords(coords);
        return coords;
    }

    void explicitFaceCheck(QuickHull3D hull, int[][] checkFaces) throws Exception {
        int[][] faceIndices = hull.getFaces();
        if (faceIndices.length != checkFaces.length) {
            throw new Exception("Error: " + faceIndices.length + " faces vs. " + checkFaces.length);
        }
        Point3d[] pnts = hull.getVertices();
        int[] vtxIndices = hull.getVertexPointIndices();
        int j = 0;
        while (j < faceIndices.length) {
            int[] idxs = faceIndices[j];
            int k = 0;
            while (k < idxs.length) {
                idxs[k] = vtxIndices[idxs[k]];
                ++k;
            }
            ++j;
        }
        int i = 0;
        while (i < checkFaces.length) {
            int[] cf = checkFaces[i];
            int j2 = 0;
            while (j2 < faceIndices.length) {
                if (faceIndices[j2] != null && this.faceIndicesEqual(cf, faceIndices[j2])) {
                    faceIndices[j2] = null;
                    break;
                }
                ++j2;
            }
            if (j2 == faceIndices.length) {
                String s = "";
                int k = 0;
                while (k < cf.length) {
                    s = String.valueOf(s) + cf[k] + " ";
                    ++k;
                }
                throw new Exception("Error: face " + s + " not found");
            }
            ++i;
        }
    }

    void singleTest(double[] coords, int[][] checkFaces) throws Exception {
        QuickHull3D hull = new QuickHull3D();
        hull.setDebug(debugEnable);
        hull.build(coords, coords.length / 3);
        if (triangulate) {
            hull.triangulate();
        }
        if (!hull.check(System.out)) {
            new Throwable().printStackTrace();
            System.exit(1);
        }
        if (checkFaces != null) {
            this.explicitFaceCheck(hull, checkFaces);
        }
        if (degeneracyTest != 0) {
            this.degenerateTest(hull, coords);
        }
    }

    double[] addDegeneracy(int type, double[] coords, QuickHull3D hull) {
        int numv = coords.length / 3;
        int[][] faces = hull.getFaces();
        double[] coordsx = new double[coords.length + faces.length * 3];
        int i = 0;
        while (i < coords.length) {
            coordsx[i] = coords[i];
            ++i;
        }
        double[] lam = new double[3];
        double eps = hull.getDistanceTolerance();
        int i2 = 0;
        while (i2 < faces.length) {
            lam[0] = this.rand.nextDouble();
            lam[1] = 1.0 - lam[0];
            lam[2] = 0.0;
            if (type == 2 && i2 % 2 == 0) {
                lam[0] = 1.0;
                lam[2] = 0.0;
                lam[1] = 0.0;
            }
            int j = 0;
            while (j < 3) {
                int vtxi = faces[i2][j];
                int k = 0;
                while (k < 3) {
                    int n = numv * 3 + k;
                    coordsx[n] = coordsx[n] + (lam[j] * coords[vtxi * 3 + k] + epsScale * eps * (this.rand.nextDouble() - 0.5));
                    ++k;
                }
                ++j;
            }
            ++numv;
            ++i2;
        }
        this.shuffleCoords(coordsx);
        return coordsx;
    }

    /*
     * Unable to fully structure code
     */
    void degenerateTest(QuickHull3D hull, double[] coords) throws Exception {
        block4: {
            coordsx = this.addDegeneracy(QuickHull3DTest.degeneracyTest, coords, hull);
            xhull = new QuickHull3D();
            xhull.setDebug(QuickHull3DTest.debugEnable);
            try {
                xhull.build(coordsx, coordsx.length / 3);
                if (!QuickHull3DTest.triangulate) break block4;
                xhull.triangulate();
                break block4;
            }
            catch (Exception e) {
                i = 0;
                ** while (i < coordsx.length / 3)
            }
lbl-1000:
            // 1 sources

            {
                System.out.println(String.valueOf(coordsx[i * 3 + 0]) + ", " + coordsx[i * 3 + 1] + ", " + coordsx[i * 3 + 2] + ", ");
                ++i;
                continue;
            }
        }
        if (!xhull.check(System.out)) {
            new Throwable().printStackTrace();
            System.exit(1);
        }
    }

    void rotateCoords(double[] res, double[] xyz, double roll, double pitch, double yaw) {
        double sroll = Math.sin(roll);
        double croll = Math.cos(roll);
        double spitch = Math.sin(pitch);
        double cpitch = Math.cos(pitch);
        double syaw = Math.sin(yaw);
        double cyaw = Math.cos(yaw);
        double m00 = croll * cpitch;
        double m10 = sroll * cpitch;
        double m20 = -spitch;
        double m01 = croll * spitch * syaw - sroll * cyaw;
        double m11 = sroll * spitch * syaw + croll * cyaw;
        double m21 = cpitch * syaw;
        double m02 = croll * spitch * cyaw + sroll * syaw;
        double m12 = sroll * spitch * cyaw - croll * syaw;
        double m22 = cpitch * cyaw;
        int i = 0;
        while (i < xyz.length - 2) {
            res[i + 0] = m00 * xyz[i + 0] + m01 * xyz[i + 1] + m02 * xyz[i + 2];
            res[i + 1] = m10 * xyz[i + 0] + m11 * xyz[i + 1] + m12 * xyz[i + 2];
            res[i + 2] = m20 * xyz[i + 0] + m21 * xyz[i + 1] + m22 * xyz[i + 2];
            i += 3;
        }
    }

    void printCoords(double[] coords) {
        int nump = coords.length / 3;
        int i = 0;
        while (i < nump) {
            System.out.println(String.valueOf(coords[i * 3 + 0]) + ", " + coords[i * 3 + 1] + ", " + coords[i * 3 + 2] + ", ");
            ++i;
        }
    }

    void testException(double[] coords, String msg) {
        QuickHull3D hull = new QuickHull3D();
        Exception ex = null;
        try {
            hull.build(coords);
        }
        catch (Exception e) {
            ex = e;
        }
        if (ex == null) {
            System.out.println("Expected exception " + msg);
            System.out.println("Got no exception");
            System.out.println("Input pnts:");
            this.printCoords(coords);
            System.exit(1);
        } else if (ex.getMessage() == null || !ex.getMessage().equals(msg)) {
            System.out.println("Expected exception " + msg);
            System.out.println("Got exception " + ex.getMessage());
            System.out.println("Input pnts:");
            this.printCoords(coords);
            System.exit(1);
        }
    }

    void test(double[] coords, int[][] checkFaces) throws Exception {
        double[][] rpyList = new double[][]{{0.0, 0.0, 0.0}, {10.0, 20.0, 30.0}, {-45.0, 60.0, 91.0}, {125.0, 67.0, 81.0}};
        double[] xcoords = new double[coords.length];
        this.singleTest(coords, checkFaces);
        if (testRotation) {
            int i = 0;
            while (i < rpyList.length) {
                double[] rpy = rpyList[i];
                this.rotateCoords(xcoords, coords, Math.toRadians(rpy[0]), Math.toRadians(rpy[1]), Math.toRadians(rpy[2]));
                this.singleTest(xcoords, checkFaces);
                ++i;
            }
        }
    }

    public void explicitAndRandomTests() {
        try {
            int i;
            double[] coords = null;
            System.out.println("Testing degenerate input ...");
            int dimen = 0;
            while (dimen < 3) {
                i = 0;
                while (i < 10) {
                    coords = this.randomDegeneratePoints(10, dimen);
                    if (dimen == 0) {
                        this.testException(coords, "Input points appear to be coincident");
                    } else if (dimen == 1) {
                        this.testException(coords, "Input points appear to be colinear");
                    } else if (dimen == 2) {
                        this.testException(coords, "Input points appear to be coplanar");
                    }
                    ++i;
                }
                ++dimen;
            }
            System.out.println("Explicit tests ...");
            coords = new double[]{21.0, 0.0, 0.0, 0.0, 21.0, 0.0, 0.0, 0.0, 0.0, 18.0, 2.0, 6.0, 1.0, 18.0, 5.0, 2.0, 1.0, 3.0, 14.0, 3.0, 10.0, 4.0, 14.0, 14.0, 3.0, 4.0, 10.0, 10.0, 6.0, 12.0, 5.0, 10.0, 15.0};
            this.test(coords, null);
            coords = new double[]{0.0, 0.0, 0.0, 21.0, 0.0, 0.0, 0.0, 21.0, 0.0, 2.0, 1.0, 2.0, 17.0, 2.0, 3.0, 1.0, 19.0, 6.0, 4.0, 3.0, 5.0, 13.0, 4.0, 5.0, 3.0, 15.0, 8.0, 6.0, 5.0, 6.0, 9.0, 6.0, 11.0};
            this.test(coords, null);
            System.out.println("Testing 20 to 200 random points ...");
            int n = 20;
            while (n < 200) {
                i = 0;
                while (i < 10) {
                    coords = this.randomPoints(n, 1.0);
                    this.test(coords, null);
                    ++i;
                }
                n += 10;
            }
            System.out.println("Testing 20 to 200 random points in a sphere ...");
            n = 20;
            while (n < 200) {
                i = 0;
                while (i < 10) {
                    coords = this.randomSphericalPoints(n, 1.0);
                    this.test(coords, null);
                    ++i;
                }
                n += 10;
            }
            System.out.println("Testing 20 to 200 random points clipped to a cube ...");
            n = 20;
            while (n < 200) {
                i = 0;
                while (i < 10) {
                    coords = this.randomCubedPoints(n, 1.0, 0.5);
                    this.test(coords, null);
                    ++i;
                }
                n += 10;
            }
            System.out.println("Testing 8 to 1000 randomly shuffled points on a grid ...");
            n = 2;
            while (n <= 10) {
                i = 0;
                while (i < 10) {
                    coords = this.randomGridPoints(n, 4.0);
                    this.test(coords, null);
                    ++i;
                }
                ++n;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
        System.out.println("\nPassed\n");
    }

    public void timingTests() {
        int n = 10;
        QuickHull3D hull = new QuickHull3D();
        System.out.println("warming up ... ");
        int i = 0;
        while (i < 2) {
            double[] coords = this.randomSphericalPoints(10000, 1.0);
            hull.build(coords);
            ++i;
        }
        int cnt = 10;
        int i2 = 0;
        while (i2 < 4) {
            double[] coords = this.randomSphericalPoints(n *= 10, 1.0);
            long t0 = System.currentTimeMillis();
            int k = 0;
            while (k < cnt) {
                hull.build(coords);
                ++k;
            }
            long t1 = System.currentTimeMillis();
            System.out.println(String.valueOf(n) + " points: " + (double)(t1 - t0) / (double)cnt + " msec");
            ++i2;
        }
    }

    public static void main(String[] args) {
        QuickHull3DTest tester = new QuickHull3DTest();
        int i = 0;
        while (i < args.length) {
            if (args[i].equals("-timing")) {
                doTiming = true;
                doTesting = false;
            } else {
                System.out.println("Usage: java quickhull3d.QuickHull3DTest [-timing]");
                System.exit(1);
            }
            ++i;
        }
        if (doTesting) {
            tester.explicitAndRandomTests();
        }
        if (doTiming) {
            tester.timingTests();
        }
    }
}

