/*
 * Decompiled with CFR 0.152.
 */
package opale.tools;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StreamTokenizer;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Stack;
import opale.tools.Debug;
import opale.tools.InvalidFormatException;
import opale.tools.InvalidIdException;
import opale.tools.OpaleObject;
import opale.tools.Stdio;
import opale.tools.StreamReader;

public class OpaleSet {
    private HashMap obj;
    private HashMap prior;
    private HashMap objectName;
    private HashMap userName;

    public OpaleSet() {
        Stdio.printerrln("New OpaleSet");
        this.obj = new HashMap();
        this.objectName = new HashMap();
        this.userName = new HashMap();
        this.prior = new HashMap();
        String string = "";
        String string2 = "";
        try {
            InputStream inputStream = this.getClass().getResourceAsStream("/opale/tools/name_object.rsc");
            StreamTokenizer streamTokenizer = null;
            if (inputStream != null) {
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
                streamTokenizer = new StreamTokenizer(bufferedReader);
            } else {
                System.err.println("File name_object.rsc not found.");
                System.err.println("Stop.");
                System.exit(-1);
            }
            streamTokenizer.wordChars(33, 255);
            int n = streamTokenizer.nextToken();
            while (n != -1) {
                if (n == -2) {
                    string = Double.toString(streamTokenizer.nval);
                } else if (n == -3) {
                    string = streamTokenizer.sval;
                }
                n = streamTokenizer.nextToken();
                if (n == -2) {
                    string2 = Double.toString(streamTokenizer.nval);
                } else if (n == -3) {
                    string2 = streamTokenizer.sval;
                } else if (n == -1) {
                    System.err.println("Error reading file of configuration.\n Stop.");
                    System.exit(-1);
                }
                n = streamTokenizer.nextToken();
                if (n != -2) {
                    System.err.println("Error reading file of configuration.\n Stop.");
                    System.exit(-1);
                } else {
                    this.prior.put(string, new Double(streamTokenizer.nval));
                }
                this.objectName.put(string2, string);
                this.userName.put(string, string2);
                n = streamTokenizer.nextToken();
            }
        }
        catch (IOException iOException) {
            System.err.println("Error reading file of configuration.\n Stop.");
            System.err.println(iOException);
            System.exit(-1);
        }
        System.err.println(this.objectName);
        System.err.println(this.userName);
        System.err.println(this.prior);
    }

    public void add(OpaleObject opaleObject) {
        if (opaleObject.getId() == null) {
            throw new InvalidIdException("An Opale object must have an identificator before to be added in an Opale set !!!");
        }
        this.obj.put(opaleObject.getId(), opaleObject);
    }

    public void add(OpaleObject opaleObject, String string) {
        if (string == null) {
            throw new InvalidIdException("An Opale object must have a non null identificator !!!");
        }
        opaleObject.setId(string);
        this.obj.put(opaleObject.getId(), opaleObject);
    }

    public void clear() {
        this.obj.clear();
    }

    public int size() {
        return this.obj.size();
    }

    public void remove(String string) {
        this.obj.remove(string);
    }

    public Collection objects() {
        return this.obj.values();
    }

    public OpaleObject getObject(String string) {
        return (OpaleObject)this.obj.get(string);
    }

    public boolean contains(OpaleObject opaleObject) {
        return this.obj.containsValue(opaleObject);
    }

    public boolean contains(String string) {
        return this.obj.containsKey(string);
    }

    public boolean isEmpty() {
        return this.obj.isEmpty();
    }

    public String[] getUserNameObject() {
        Object[] objectArray = this.objectName.keySet().toArray();
        String[] stringArray = new String[this.objectName.size()];
        int n = 0;
        while (n < this.objectName.size()) {
            stringArray[n] = (String)objectArray[n];
            ++n;
        }
        return stringArray;
    }

    public String getNameObject(String string) {
        return (String)this.objectName.get(string);
    }

    public String getUserName(String string) {
        return (String)this.userName.get(string);
    }

    public void read(StreamReader streamReader) throws InvalidFormatException {
        String string = "";
        Stdio.println("Reading the stream : " + streamReader);
        try {
            while (streamReader.hasMoreTokens()) {
                string = streamReader.next();
                Stdio.println("->> Read an object of type " + string + ".");
                if (this.getNameObject(string) == null) {
                    throw new InvalidFormatException("Unknown type " + string + " !!!");
                }
                OpaleObject opaleObject = (OpaleObject)Class.forName(this.getNameObject(string)).newInstance();
                String string2 = streamReader.next();
                Debug.print("id = ", string2);
                opaleObject.setId(string2);
                opaleObject.read(streamReader, this);
                this.add(opaleObject);
                Stdio.println("->> End of reading an object.");
            }
        }
        catch (IOException iOException) {
            System.err.println("Error reading the file " + streamReader);
            System.err.println(iOException);
            System.exit(-1);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new InvalidFormatException("Error reading an object of type " + string + " : the class does not exist.");
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new InvalidFormatException("Error reading an object of type " + string + " : access to the class not possible.");
        }
        catch (InstantiationException instantiationException) {
            throw new InvalidFormatException("Error reading an object of type " + string + " : class not instantiable.");
        }
    }

    public void write(PrintWriter printWriter) throws InvalidFormatException {
        if (this.isEmpty()) {
            throw new IllegalArgumentException("No objects to write !!!");
        }
        Comparator comparator = new Comparator(){

            public int compare(Object object, Object object2) {
                double d;
                OpaleObject opaleObject = (OpaleObject)object;
                OpaleObject opaleObject2 = (OpaleObject)object2;
                double d2 = (Double)OpaleSet.this.prior.get(opaleObject.getClass().getName());
                if (d2 < (d = ((Double)OpaleSet.this.prior.get(opaleObject2.getClass().getName())).doubleValue())) {
                    return -1;
                }
                if (d2 == d) {
                    return 0;
                }
                return 1;
            }
        };
        OpaleObject[] opaleObjectArray = this.objects().toArray(new OpaleObject[0]);
        int n = 0;
        while (n < opaleObjectArray.length) {
            if (this.getUserName(opaleObjectArray[n].getClass().getName()) == null) {
                throw new InvalidFormatException("Unknown type " + opaleObjectArray[n].getClass().getName() + " !!!");
            }
            ++n;
        }
        Arrays.sort(opaleObjectArray, comparator);
        int n2 = 0;
        while (n2 < opaleObjectArray.length) {
            if (this.getUserName(opaleObjectArray[n2].getClass().getName()) == null) {
                throw new InvalidFormatException("Unknown type " + opaleObjectArray[n2].getClass().getName() + " !!!");
            }
            printWriter.print(this.getUserName(opaleObjectArray[n2].getClass().getName()) + " ");
            printWriter.println(opaleObjectArray[n2].getId());
            Stdio.println("Writing an Opale object : " + opaleObjectArray[n2].getClass().getName());
            opaleObjectArray[n2].write(printWriter, this);
            printWriter.println("");
            ++n2;
        }
    }

    public void writeInFile(String string) throws InvalidFormatException, FileNotFoundException, IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(string);
        PrintWriter printWriter = new PrintWriter(fileOutputStream);
        this.write(printWriter);
        printWriter.close();
        fileOutputStream.close();
    }

    private int jump(StreamTokenizer streamTokenizer) throws InvalidFormatException {
        try {
            Stack<String> stack = new Stack<String>();
            int n = streamTokenizer.nextToken();
            Debug.print(streamTokenizer.sval);
            if (n != -3 || !streamTokenizer.sval.equals("{")) {
                throw new InvalidFormatException("Syntax error : '{' expected !!");
            }
            stack.push("{");
            n = streamTokenizer.nextToken();
            while (!stack.empty() && n != -1) {
                if (n == -3 && streamTokenizer.sval.equals("{")) {
                    Debug.print(" > We push {");
                    stack.push("{");
                } else if (n == -3 && streamTokenizer.sval.equals("}")) {
                    Debug.print(" > Pop }");
                    if (stack.empty()) {
                        throw new InvalidFormatException(" Syntax error : '{' expected !!!");
                    }
                    String string = (String)stack.pop();
                    if (!string.equals("{")) {
                        throw new InvalidFormatException(" Syntax error : '{' expected !!!");
                    }
                }
                n = streamTokenizer.nextToken();
            }
            Debug.print("Stack at the end : " + stack);
            return n;
        }
        catch (IOException iOException) {
            System.err.println("Error reading the file " + streamTokenizer);
            System.err.println(iOException);
            System.exit(-1);
            return 0;
        }
    }

    public void check() {
        System.err.println("Check OpaleSet : ");
        System.err.println(" " + this.obj);
    }
}

