/*
 * Decompiled with CFR 0.152.
 */
package JSci.instruments.pi;

import JSci.instruments.DummyPositionControl;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.RandomAccessFile;

public class PiezoServo
extends DummyPositionControl {
    private DataInput rfi;
    private DataOutput rfo;
    private String name;
    private int ttyNumber;
    private String type;
    private boolean inverted;
    public static final String E665 = "E-665";
    public static final String E662 = "E-662";

    public PiezoServo(int n, String string, boolean bl) throws IOException {
        this(n, new RandomAccessFile("/dev/ttyS" + n, "rw"), string, bl);
    }

    public PiezoServo(int n, RandomAccessFile randomAccessFile, String string, boolean bl) throws IOException {
        this(n, randomAccessFile, randomAccessFile, string, bl);
    }

    public PiezoServo(int n, DataInput dataInput, DataOutput dataOutput, String string, boolean bl) throws IOException {
        this.type = string;
        this.inverted = bl;
        this.rfi = dataInput;
        this.rfo = dataOutput;
        this.ttyNumber = n;
        if (string.equals(E665)) {
            this.write("SVO A1");
        }
        this.write("*IDN?");
        this.name = this.read();
        if (!this.name.substring(0, 2).equals("PI")) {
            throw new IOException("Serial device is unknown: " + this.name);
        }
    }

    private void write(String string) throws IOException {
        this.rfo.writeBytes(string);
        this.rfo.writeByte(10);
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private String read() throws IOException {
        byte by;
        String string = "";
        while ((by = this.rfi.readByte()) != 10) {
            string = string + (char)by;
        }
        return string;
    }

    public String toString() {
        return this.getClass().getName() + "[Port=/dev/ttyS" + this.ttyNumber + ",Controller=" + this.name + "]";
    }

    protected final void doSetPosition(double d) {
        if (this.inverted) {
            d = 100.0 - d;
        }
        try {
            if (this.type.equals(E665)) {
                this.write("MOV A" + d);
            }
            if (this.type.equals(E662)) {
                this.write("POS " + d);
            }
        }
        catch (IOException iOException) {
            System.err.println("Error writing to the " + this.name + ": " + iOException);
        }
    }

    public double getActualPosition() {
        String string = "";
        try {
            if (this.type.equals(E665)) {
                this.write("POS?A");
            }
            if (this.type.equals(E662)) {
                this.write("POS?");
            }
            string = this.read();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        double d = Double.valueOf(string);
        if (this.inverted) {
            d = 100.0 - d;
        }
        return d;
    }

    public void sleep() {
        try {
            Thread.sleep(300L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static void main(String[] stringArray) {
        PiezoServo piezoServo = null;
        try {
            piezoServo = new PiezoServo(Integer.parseInt(stringArray[0]), E665, false);
            System.out.println(piezoServo);
            System.out.println("Position: " + piezoServo.getActualPosition());
            piezoServo.setPosition(3.0);
            piezoServo.sleep();
            System.out.println("Position: " + piezoServo.getActualPosition());
            piezoServo.setPosition(6.0);
            piezoServo.sleep();
            System.out.println("Position: " + piezoServo.getActualPosition());
            piezoServo.setPosition(9.0);
            piezoServo.sleep();
            System.out.println("Position: " + piezoServo.getActualPosition());
        }
        catch (IOException iOException) {
            System.out.println(piezoServo.name + " error: " + iOException);
        }
    }
}

