/*
 * Decompiled with CFR 0.152.
 */
package JSci.astro.telescope;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import javax.comm.CommPortIdentifier;
import javax.comm.NoSuchPortException;
import javax.comm.PortInUseException;
import javax.comm.SerialPort;
import javax.comm.UnsupportedCommOperationException;

public final class NexStar {
    private SerialPort serial;
    private InputStreamReader in;
    private OutputStreamWriter out;

    public static int raToInt(String string) {
        int n = Integer.valueOf(string.substring(0, 2));
        int n2 = Integer.valueOf(string.substring(3, 5));
        int n3 = Integer.valueOf(string.substring(6, 8));
        return n * 600 + n2 * 10 + n3;
    }

    public static int decToInt(String string) {
        int n = Integer.valueOf(string.substring(0, 3));
        int n2 = Integer.valueOf(string.substring(4, 6));
        int n3 = Integer.valueOf(string.substring(7, 9));
        if (n >= 0) {
            return n * 600 + n2 * 10 + n3;
        }
        return n * 600 - n2 * 10 - n3;
    }

    public static int altToInt(String string) {
        int n = Integer.valueOf(string.substring(0, 3));
        int n2 = Integer.valueOf(string.substring(4, 6));
        int n3 = Integer.valueOf(string.substring(7, 9));
        if (n >= 0) {
            return n * 600 + n2 * 10 + n3;
        }
        return n * 600 - n2 * 10 - n3;
    }

    public static int azToInt(String string) {
        int n = Integer.valueOf(string.substring(0, 3));
        int n2 = Integer.valueOf(string.substring(4, 6));
        int n3 = Integer.valueOf(string.substring(7, 9));
        return n * 600 + n2 * 10 + n3;
    }

    public NexStar(String string) {
        try {
            CommPortIdentifier commPortIdentifier = CommPortIdentifier.getPortIdentifier((String)string);
            this.serial = (SerialPort)commPortIdentifier.open("NexStar", 10);
            this.serial.setSerialPortParams(9600, 8, 1, 0);
            this.in = new InputStreamReader(this.serial.getInputStream());
            this.out = new OutputStreamWriter(this.serial.getOutputStream());
        }
        catch (NoSuchPortException noSuchPortException) {
            System.err.println("Port does not exist: " + noSuchPortException.getMessage());
            noSuchPortException.printStackTrace();
        }
        catch (PortInUseException portInUseException) {
            System.err.println("Port is in use by another process: " + portInUseException.getMessage());
            portInUseException.printStackTrace();
        }
        catch (UnsupportedCommOperationException unsupportedCommOperationException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public synchronized String getRADec() throws IOException {
        this.sendCmd("E");
        return this.readString();
    }

    public synchronized String getAzAlt() throws IOException {
        this.sendCmd("Z");
        return this.readString();
    }

    public synchronized void gotoRADec(String string, String string2) throws IOException {
        int n = NexStar.raToInt(string);
        int n2 = NexStar.decToInt(string2);
        this.out.write(82);
        this.out.write((byte)(n >> 8));
        this.out.write((byte)n);
        this.out.write(44);
        this.out.write((byte)(n2 >> 8));
        this.out.write((byte)n2);
        this.out.flush();
    }

    public synchronized void gotoAzAlt(String string, String string2) throws IOException {
        int n = NexStar.azToInt(string);
        int n2 = NexStar.altToInt(string2);
        this.out.write(65);
        this.out.write((byte)(n >> 8));
        this.out.write((byte)n);
        this.out.write(44);
        this.out.write((byte)(n2 >> 8));
        this.out.write((byte)n2);
        this.out.flush();
    }

    public synchronized boolean isMoving() throws IOException {
        this.sendCmd("L");
        return this.readString().equals("1");
    }

    private void sendCmd(String string) throws IOException {
        this.out.write(string);
        this.out.flush();
    }

    private String readString() throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        int n = this.in.read();
        while (n != 35) {
            stringBuffer.append(n);
            n = this.in.read();
        }
        return stringBuffer.toString();
    }

    public synchronized void close() throws IOException {
        this.in.close();
        this.out.close();
        this.serial.close();
    }
}

