/*
 * Decompiled with CFR 0.152.
 */
package no.uib.cipr.matrix;

import no.uib.cipr.matrix.Diag;
import no.uib.cipr.matrix.LowerTriangDenseMatrix;
import no.uib.cipr.matrix.Matrix;
import no.uib.cipr.matrix.MatrixEntry;

public class UnitLowerTriangDenseMatrix
extends LowerTriangDenseMatrix {
    public UnitLowerTriangDenseMatrix(int n) {
        super(n, Diag.Unit);
    }

    public UnitLowerTriangDenseMatrix(Matrix A) {
        this(A, true);
    }

    public UnitLowerTriangDenseMatrix(Matrix A, boolean deep) {
        super(A, deep, Diag.Unit);
    }

    public void add(int row, int column, double value) {
        if (column == row) {
            throw new IllegalArgumentException("column == row");
        }
        super.add(row, column, value);
    }

    public double get(int row, int column) {
        if (column == row) {
            return 1.0;
        }
        return super.get(row, column);
    }

    public void set(int row, int column, double value) {
        if (column == row) {
            throw new IllegalArgumentException("column == row");
        }
        super.set(row, column, value);
    }

    void copy(Matrix A) {
        for (MatrixEntry e : A) {
            if (e.row() <= e.column()) continue;
            this.set(e.row(), e.column(), e.get());
        }
    }

    public UnitLowerTriangDenseMatrix copy() {
        return new UnitLowerTriangDenseMatrix(this);
    }

    public Matrix zero() {
        throw new UnsupportedOperationException();
    }
}

