/*
 * Decompiled with CFR 0.152.
 */
package JSci.physics.relativity;

import JSci.GlobalSettings;
import JSci.maths.DimensionException;
import JSci.physics.relativity.Rank1Tensor;
import JSci.physics.relativity.Rank4Tensor;
import JSci.physics.relativity.Tensor;

public class Rank3Tensor
extends Tensor {
    protected double[][][] rank3 = new double[4][4][4];

    public boolean equals(Object object) {
        if (object instanceof Rank3Tensor) {
            Rank3Tensor rank3Tensor = (Rank3Tensor)object;
            for (int i = 0; i < 4; ++i) {
                for (int j = 0; j < 4; ++j) {
                    if (!(Math.abs(this.rank3[i][j][0] - rank3Tensor.rank3[i][j][0]) > GlobalSettings.ZERO_TOL || Math.abs(this.rank3[i][j][1] - rank3Tensor.rank3[i][j][1]) > GlobalSettings.ZERO_TOL || Math.abs(this.rank3[i][j][2] - rank3Tensor.rank3[i][j][2]) > GlobalSettings.ZERO_TOL) && !(Math.abs(this.rank3[i][j][3] - rank3Tensor.rank3[i][j][3]) > GlobalSettings.ZERO_TOL)) continue;
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    public double getComponent(int n, int n2, int n3) {
        if (n >= 0 && n < 4 && n2 >= 0 && n2 < 4 && n3 >= 0 && n3 < 4) {
            return this.rank3[n][n2][n3];
        }
        throw new DimensionException("Invalid component.");
    }

    public void setComponent(int n, int n2, int n3, double d) {
        if (n < 0 || n >= 4 || n2 < 0 || n2 >= 4 || n3 < 0 || n3 >= 4) {
            throw new DimensionException("Invalid component.");
        }
        this.rank3[n][n2][n3] = d;
    }

    public Rank3Tensor add(Rank3Tensor rank3Tensor) {
        Rank3Tensor rank3Tensor2 = new Rank3Tensor();
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                rank3Tensor2.setComponent(i, j, 0, this.rank3[i][j][0] + rank3Tensor.rank3[i][j][0]);
                rank3Tensor2.setComponent(i, j, 1, this.rank3[i][j][1] + rank3Tensor.rank3[i][j][1]);
                rank3Tensor2.setComponent(i, j, 2, this.rank3[i][j][2] + rank3Tensor.rank3[i][j][2]);
                rank3Tensor2.setComponent(i, j, 3, this.rank3[i][j][3] + rank3Tensor.rank3[i][j][3]);
            }
        }
        return rank3Tensor2;
    }

    public Rank3Tensor subtract(Rank3Tensor rank3Tensor) {
        Rank3Tensor rank3Tensor2 = new Rank3Tensor();
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                rank3Tensor2.setComponent(i, j, 0, this.rank3[i][j][0] - rank3Tensor.rank3[i][j][0]);
                rank3Tensor2.setComponent(i, j, 1, this.rank3[i][j][1] - rank3Tensor.rank3[i][j][1]);
                rank3Tensor2.setComponent(i, j, 2, this.rank3[i][j][2] - rank3Tensor.rank3[i][j][2]);
                rank3Tensor2.setComponent(i, j, 3, this.rank3[i][j][3] - rank3Tensor.rank3[i][j][3]);
            }
        }
        return rank3Tensor2;
    }

    public Rank4Tensor tensorProduct(Rank1Tensor rank1Tensor) {
        Rank4Tensor rank4Tensor = new Rank4Tensor();
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                for (int k = 0; k < 4; ++k) {
                    rank4Tensor.setComponent(i, j, k, 0, this.rank3[i][j][k] * rank1Tensor.getComponent(0));
                    rank4Tensor.setComponent(i, j, k, 1, this.rank3[i][j][k] * rank1Tensor.getComponent(1));
                    rank4Tensor.setComponent(i, j, k, 2, this.rank3[i][j][k] * rank1Tensor.getComponent(2));
                    rank4Tensor.setComponent(i, j, k, 3, this.rank3[i][j][k] * rank1Tensor.getComponent(3));
                }
            }
        }
        return rank4Tensor;
    }
}

