/*
 * Decompiled with CFR 0.152.
 */
package JSci.awt;

import JSci.awt.AbstractGraphModel;
import JSci.awt.Graph3DModel;
import java.util.ArrayList;
import java.util.List;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;

public final class DefaultGraph3DModel
extends AbstractGraphModel
implements Graph3DModel,
TableModelListener {
    private static final int X_AXIS_COLUMN = 0;
    private static final int Y_AXIS_COLUMN = 1;
    private static final int SERIES_COLUMN = 2;
    private float[] xAxis = new float[0];
    private float[] yAxis = new float[0];
    private final List series = new ArrayList();
    private int pos = 0;
    private DataSeries curSeries = null;
    static /* synthetic */ Class class$java$lang$Float;

    public void setXAxis(float[] fArray) {
        if (this.xAxis.length != fArray.length) {
            this.xAxis = new float[fArray.length];
        }
        System.arraycopy(fArray, 0, this.xAxis, 0, fArray.length);
        this.fireGraphDataChanged();
    }

    public void setYAxis(float[] fArray) {
        if (this.yAxis.length != fArray.length) {
            this.yAxis = new float[fArray.length];
        }
        System.arraycopy(fArray, 0, this.yAxis, 0, fArray.length);
        this.fireGraphDataChanged();
    }

    public void addSeries(DataSeries dataSeries) {
        this.series.add(dataSeries);
        this.fireGraphDataChanged();
        dataSeries.addTableModelListener(this);
    }

    public void addSeries(float[] fArray) {
        this.addSeries(new DataSeries(this.xAxis, this.yAxis, fArray));
    }

    public void changeSeries(int n, DataSeries dataSeries) {
        this.getSeries(n).removeTableModelListener(this);
        this.series.set(n, dataSeries);
        this.fireGraphDataChanged();
        dataSeries.addTableModelListener(this);
    }

    public void changeSeries(int n, float[] fArray) {
        this.getSeries(n).setValues(fArray);
    }

    public void removeSeries(int n) {
        this.getSeries(n).removeTableModelListener(this);
        this.series.remove(n);
        this.fireGraphDataChanged();
    }

    public DataSeries getSeries(int n) {
        return (DataSeries)this.series.get(n);
    }

    public void setSeriesVisible(int n, boolean bl) {
        this.getSeries(n).setVisible(bl);
    }

    public void tableChanged(TableModelEvent tableModelEvent) {
        if (tableModelEvent.getColumn() == 2) {
            this.fireGraphSeriesUpdated(this.series.indexOf(tableModelEvent.getSource()));
        }
    }

    public float getXCoord(int n) {
        return this.xAxis[n];
    }

    public float getYCoord(int n) {
        return this.yAxis[n];
    }

    public float getZCoord(int n) {
        return this.curSeries.getValue(n);
    }

    public int seriesLength() {
        return this.curSeries.length();
    }

    public void firstSeries() {
        this.curSeries = this.getSeries(0);
        this.pos = 0;
        while (!this.curSeries.isVisible() && this.pos < this.series.size() - 1) {
            this.curSeries = this.getSeries(++this.pos);
        }
    }

    public boolean nextSeries() {
        if (this.pos == this.series.size() - 1) {
            return false;
        }
        do {
            this.curSeries = this.getSeries(++this.pos);
        } while (!this.curSeries.isVisible() && this.pos < this.series.size() - 1);
        return this.curSeries.isVisible();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class DataSeries
    extends AbstractTableModel {
        protected float[] xAxis = new float[0];
        protected float[] yAxis = new float[0];
        protected float[] series = new float[0];
        private boolean isVis = true;

        protected DataSeries() {
        }

        public DataSeries(float[] fArray, float[] fArray2, float[] fArray3) {
            this.setXAxis(fArray);
            this.setYAxis(fArray2);
            this.setValues(fArray3);
        }

        public DataSeries(float[] fArray, float[] fArray2, double[] dArray) {
            this.setXAxis(fArray);
            this.setYAxis(fArray2);
            this.setValues(dArray);
        }

        public DataSeries(double[] dArray, double[] dArray2, double[] dArray3) {
            this.setXAxis(dArray);
            this.setYAxis(dArray2);
            this.setValues(dArray3);
        }

        public void setXAxis(float[] fArray) {
            if (this.xAxis.length != fArray.length) {
                this.xAxis = new float[fArray.length];
            }
            System.arraycopy(fArray, 0, this.xAxis, 0, fArray.length);
            this.fireTableColumnUpdated(0);
        }

        public void setXAxis(double[] dArray) {
            if (this.xAxis.length != dArray.length) {
                this.xAxis = new float[dArray.length];
            }
            for (int i = 0; i < dArray.length; ++i) {
                this.xAxis[i] = (float)dArray[i];
            }
            this.fireTableColumnUpdated(0);
        }

        public void setYAxis(float[] fArray) {
            if (this.yAxis.length != fArray.length) {
                this.yAxis = new float[fArray.length];
            }
            System.arraycopy(fArray, 0, this.yAxis, 0, fArray.length);
            this.fireTableColumnUpdated(1);
        }

        public void setYAxis(double[] dArray) {
            if (this.yAxis.length != dArray.length) {
                this.yAxis = new float[dArray.length];
            }
            for (int i = 0; i < dArray.length; ++i) {
                this.yAxis[i] = (float)dArray[i];
            }
            this.fireTableColumnUpdated(1);
        }

        public void setValues(float[] fArray) {
            if (this.series.length != fArray.length) {
                this.series = new float[fArray.length];
            }
            System.arraycopy(fArray, 0, this.series, 0, fArray.length);
            this.fireTableColumnUpdated(2);
        }

        public void setValues(double[] dArray) {
            if (this.series.length != dArray.length) {
                this.series = new float[dArray.length];
            }
            for (int i = 0; i < dArray.length; ++i) {
                this.series[i] = (float)dArray[i];
            }
            this.fireTableColumnUpdated(2);
        }

        public float getXCoord(int n) {
            return this.xAxis[n];
        }

        public void setXCoord(int n, float f) {
            this.xAxis[n] = f;
            this.fireTableCellUpdated(n, 0);
        }

        public float getYCoord(int n) {
            return this.yAxis[n];
        }

        public void setYCoord(int n, float f) {
            this.yAxis[n] = f;
            this.fireTableCellUpdated(n, 1);
        }

        public float getValue(int n) {
            return this.series[n];
        }

        public void setValue(int n, float f) {
            this.series[n] = f;
            this.fireTableCellUpdated(n, 2);
        }

        public int length() {
            return Math.min(Math.min(this.xAxis.length, this.yAxis.length), this.series.length);
        }

        public final void setVisible(boolean bl) {
            if (bl != this.isVis) {
                this.isVis = bl;
                this.fireTableDataChanged();
            }
        }

        public final boolean isVisible() {
            return this.isVis;
        }

        private void fireTableColumnUpdated(int n) {
            if (n == 0) {
                this.fireTableChanged(new TableModelEvent(this, 0, this.xAxis.length - 1, n));
            } else if (n == 1) {
                this.fireTableChanged(new TableModelEvent(this, 0, this.yAxis.length - 1, n));
            } else if (n == 2) {
                this.fireTableChanged(new TableModelEvent(this, 0, this.series.length - 1, n));
            }
        }

        public String getColumnName(int n) {
            if (n == 0) {
                return "X";
            }
            if (n == 1) {
                return "Y";
            }
            if (n == 2) {
                return "Z";
            }
            return null;
        }

        public Class getColumnClass(int n) {
            return class$java$lang$Float == null ? (class$java$lang$Float = DefaultGraph3DModel.class$("java.lang.Float")) : class$java$lang$Float;
        }

        public final int getRowCount() {
            return this.length();
        }

        public final int getColumnCount() {
            return 3;
        }

        public Object getValueAt(int n, int n2) {
            if (n2 == 0) {
                return new Float(this.getXCoord(n));
            }
            if (n2 == 1) {
                return new Float(this.getYCoord(n));
            }
            if (n2 == 2) {
                return new Float(this.getValue(n));
            }
            return null;
        }

        public void setValueAt(Object object, int n, int n2) {
            if (n2 == 0) {
                this.setXCoord(n, ((Float)object).floatValue());
            } else if (n2 == 1) {
                this.setYCoord(n, ((Float)object).floatValue());
            } else if (n2 == 2) {
                this.setValue(n, ((Float)object).floatValue());
            }
        }

        public boolean isCellEditable(int n, int n2) {
            return true;
        }
    }
}

