/*
 * Decompiled with CFR 0.152.
 */
package JSci.awt;

import JSci.awt.Matrix3D;
import java.awt.Color;
import java.awt.Graphics;
import java.util.Arrays;

class Model3D {
    private static Color[] greys = new Color[16];
    float[] vert;
    int[] tvert;
    int nvert;
    int maxvert;
    int[] con;
    int ncon;
    int maxcon;
    boolean transformed;
    Matrix3D mat;
    float xmin;
    float xmax;
    float ymin;
    float ymax;
    float zmin;
    float zmax;
    private float[] axes = new float[18];
    private int[] taxes = new int[18];

    Model3D() {
        this.mat = new Matrix3D();
        this.mat.xRotate(20.0);
        this.mat.yRotate(30.0);
    }

    int addVertex(float f, float f2, float f3) {
        int n = this.nvert;
        if (n >= this.maxvert) {
            if (this.vert == null) {
                this.maxvert = 100;
                this.vert = new float[this.maxvert * 3];
            } else {
                this.maxvert *= 2;
                float[] fArray = new float[this.maxvert * 3];
                System.arraycopy(this.vert, 0, fArray, 0, this.vert.length);
                this.vert = fArray;
            }
        }
        this.vert[n *= 3] = f;
        this.vert[n + 1] = f2;
        this.vert[n + 2] = f3;
        return this.nvert++;
    }

    void addLine(int n, int n2) {
        int n3 = this.ncon;
        if (n >= this.nvert || n2 >= this.nvert) {
            return;
        }
        if (n3 >= this.maxcon) {
            if (this.con == null) {
                this.maxcon = 100;
                this.con = new int[this.maxcon];
            } else {
                this.maxcon *= 2;
                int[] nArray = new int[this.maxcon];
                System.arraycopy(this.con, 0, nArray, 0, this.con.length);
                this.con = nArray;
            }
        }
        if (n > n2) {
            int n4 = n;
            n = n2;
            n2 = n4;
        }
        this.con[n3] = n << 16 | n2;
        this.ncon = n3 + 1;
    }

    void transform() {
        if (this.transformed || this.nvert <= 0) {
            return;
        }
        this.mat.transform(this.axes, this.taxes, 6);
        if (this.tvert == null || this.tvert.length < this.nvert * 3) {
            this.tvert = new int[this.nvert * 3];
        }
        this.mat.transform(this.vert, this.tvert, this.nvert);
        this.transformed = true;
    }

    void compress() {
        int n = this.ncon;
        int[] nArray = this.con;
        Arrays.sort(this.con, 0, this.ncon);
        int n2 = 0;
        int n3 = -1;
        for (int i = 0; i < n; ++i) {
            int n4 = nArray[i];
            if (n3 != n4) {
                nArray[n2] = n4;
                ++n2;
            }
            n3 = n4;
        }
        this.ncon = n2;
    }

    void paint(Graphics graphics) {
        if (this.vert == null || this.nvert <= 0) {
            return;
        }
        this.transform();
        Color color = null;
        int n = this.ncon;
        int[] nArray = this.con;
        int[] nArray2 = this.tvert;
        if (n <= 0 || this.nvert <= 0) {
            return;
        }
        int[] nArray3 = this.taxes;
        graphics.setColor(this.depthColor(nArray3[2], nArray3[5]));
        graphics.drawLine(nArray3[0], nArray3[1], nArray3[3], nArray3[4]);
        graphics.setColor(this.depthColor(nArray3[8], nArray3[11]));
        graphics.drawLine(nArray3[6], nArray3[7], nArray3[9], nArray3[10]);
        graphics.setColor(this.depthColor(nArray3[14], nArray3[17]));
        graphics.drawLine(nArray3[12], nArray3[13], nArray3[15], nArray3[16]);
        for (int i = 0; i < n; ++i) {
            int n2 = nArray[i];
            int n3 = (n2 >> 16 & 0xFFFF) * 3;
            int n4 = (n2 & 0xFFFF) * 3;
            Color color2 = this.depthColor(nArray2[n3 + 2], nArray2[n4 + 2]);
            if (color2 != color) {
                color = color2;
                graphics.setColor(color2);
            }
            graphics.drawLine(nArray2[n3], nArray2[n3 + 1], nArray2[n4], nArray2[n4 + 1]);
        }
    }

    private Color depthColor(int n, int n2) {
        int n3 = n + n2;
        if (n3 < 0) {
            n3 = 0;
        } else if (n3 > 15) {
            n3 = 15;
        }
        return greys[n3];
    }

    void findBoundingBox() {
        float f;
        float f2;
        float f3;
        if (this.nvert <= 0) {
            return;
        }
        float[] fArray = this.vert;
        float f4 = f3 = fArray[0];
        float f5 = f2 = fArray[1];
        float f6 = f = fArray[2];
        int n = this.nvert * 3;
        while ((n -= 3) > 0) {
            float f7;
            float f8;
            float f9 = fArray[n];
            if (f9 < f3) {
                f3 = f9;
            }
            if (f9 > f4) {
                f4 = f9;
            }
            if ((f8 = fArray[n + 1]) < f2) {
                f2 = f8;
            }
            if (f8 > f5) {
                f5 = f8;
            }
            if ((f7 = fArray[n + 2]) < f) {
                f = f7;
            }
            if (!(f7 > f6)) continue;
            f6 = f7;
        }
        this.xmax = f4;
        this.xmin = f3;
        this.ymax = f5;
        this.ymin = f2;
        this.zmax = f6;
        this.zmin = f;
        this.axes[0] = f4;
        this.axes[3] = f3;
        this.axes[7] = f5;
        this.axes[10] = f2;
        this.axes[14] = f6;
        this.axes[17] = f;
    }

    static {
        for (int i = 0; i < greys.length; ++i) {
            int n = (int)(170.0 * (1.0 - Math.pow((double)i / 15.0, 2.3)));
            Model3D.greys[i] = new Color(n, n, n);
        }
    }
}

