/*
 * Decompiled with CFR 0.152.
 */
package JSci.swing;

import JSci.swing.JPointer;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.text.NumberFormat;
import java.util.ArrayList;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class JRoundDial
extends JPanel {
    private double oneTurn = 360.0;
    private double zero = 0.0;
    private double minorTic = 10.0;
    private double majorTic = 30.0;
    private boolean setPaintMinorTicks = true;
    private boolean setPaintMajorTicks = true;
    private boolean setPaintLabels = true;
    private JPointer setPaintTurns = null;
    private double radius = 70.0;
    private ArrayList pointers = new ArrayList();
    private ChangeListener changeListener = new ChangeListener(){

        public void stateChanged(ChangeEvent changeEvent) {
            JRoundDial.this.repaint();
        }
    };
    private Line2D[] minorTics = null;
    private Line2D[] majorTics = null;
    private Point2D[] ticLabelPos = null;
    private String[] ticLabelText = null;
    private static NumberFormat formatter = NumberFormat.getNumberInstance();
    private JPointer dragged = null;
    private double dragDelta;

    public JRoundDial(double d) {
        this.oneTurn = d;
        this.setSize((int)(2.0 * this.radius), (int)(2.0 * this.radius));
        this.addMouseListener(new TheMouseListener());
        this.addMouseMotionListener(new TheMouseMotionListener());
    }

    public void setZero(double d) {
        this.zero = d;
    }

    public void setSize(int n, int n2) {
        super.setSize(n, n2);
        this.radius = n < n2 ? (double)(n / 2) : (double)(n2 / 2);
        this.updateMinorTics();
        this.updateMajorTics();
        this.repaint();
    }

    public void setSize(Dimension dimension) {
        super.setSize(dimension);
        this.setSize((int)dimension.getWidth(), (int)dimension.getHeight());
    }

    public Dimension getPreferredSize() {
        return new Dimension((int)(2.0 * this.radius), (int)(2.0 * this.radius));
    }

    public void setMinorTickSpacing(double d) {
        this.minorTic = d;
        this.updateMinorTics();
        this.repaint();
    }

    public void setMajorTickSpacing(double d) {
        this.majorTic = d;
        this.updateMajorTics();
        this.repaint();
    }

    public void setPaintMinorTicks(boolean bl) {
        this.setPaintMinorTicks = bl;
        this.repaint();
    }

    public void setPaintMajorTicks(boolean bl) {
        this.setPaintMajorTicks = bl;
        this.repaint();
    }

    public void setPaintLabels(boolean bl) {
        this.setPaintLabels = bl;
        this.repaint();
    }

    public void setPaintTurns(JPointer jPointer) {
        this.setPaintTurns = jPointer;
        this.repaint();
    }

    private void updateMinorTics() {
        int n = (int)Math.abs(this.oneTurn / this.minorTic);
        this.minorTics = new Line2D[n];
        for (int i = 0; i < n; ++i) {
            this.minorTics[i] = new Line2D.Double(this.radius + this.radius * 0.65 * Math.sin(this.zero + Math.PI * 2 * (double)i * this.minorTic / this.oneTurn), this.radius - this.radius * 0.65 * Math.cos(this.zero + Math.PI * 2 * (double)i * this.minorTic / this.oneTurn), this.radius + this.radius * 0.75 * Math.sin(this.zero + Math.PI * 2 * (double)i * this.minorTic / this.oneTurn), this.radius - this.radius * 0.75 * Math.cos(this.zero + Math.PI * 2 * (double)i * this.minorTic / this.oneTurn));
        }
    }

    private void updateMajorTics() {
        int n = (int)Math.abs(this.oneTurn / this.majorTic);
        this.majorTics = new Line2D[n];
        this.ticLabelPos = new Point2D[n];
        this.ticLabelText = new String[n];
        for (int i = 0; i < n; ++i) {
            this.majorTics[i] = new Line2D.Double(this.radius + this.radius * 0.65 * Math.sin(this.zero + Math.PI * 2 * (double)i * this.majorTic / this.oneTurn), this.radius - this.radius * 0.65 * Math.cos(this.zero + Math.PI * 2 * (double)i * this.majorTic / this.oneTurn), this.radius + this.radius * 0.8 * Math.sin(this.zero + Math.PI * 2 * (double)i * this.majorTic / this.oneTurn), this.radius - this.radius * 0.8 * Math.cos(this.zero + Math.PI * 2 * (double)i * this.majorTic / this.oneTurn));
            this.ticLabelText[i] = formatter.format((double)i * this.majorTic);
            this.ticLabelPos[i] = new Point2D.Double(this.radius + this.radius * 0.9 * Math.sin(this.zero + Math.PI * 2 * (double)i * this.majorTic / this.oneTurn) - (double)(this.ticLabelText[i].length() * 3), this.radius - this.radius * 0.9 * Math.cos(this.zero + Math.PI * 2 * (double)i * this.majorTic / this.oneTurn) + 6.0);
        }
    }

    public void paintComponent(Graphics graphics) {
        int n;
        super.paintComponent(graphics);
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (this.setPaintMinorTicks) {
            for (n = 0; n < this.minorTics.length; ++n) {
                graphics2D.draw(this.minorTics[n]);
            }
        }
        if (this.setPaintMajorTicks) {
            for (n = 0; n < this.majorTics.length; ++n) {
                graphics2D.draw(this.majorTics[n]);
            }
        }
        if (this.setPaintLabels) {
            for (n = 0; n < this.majorTics.length; ++n) {
                graphics2D.drawString(this.ticLabelText[n], (int)this.ticLabelPos[n].getX(), (int)this.ticLabelPos[n].getY());
            }
        }
        if (this.setPaintTurns != null) {
            String string = formatter.format(Math.floor(this.setPaintTurns.getValue() / Math.abs(this.oneTurn)));
            graphics2D.drawString(string, (int)(this.radius - (double)(string.length() * 3)), (int)(this.radius / 2.0));
        }
        Color color = graphics2D.getColor();
        for (int i = 0; i < this.pointers.size(); ++i) {
            ((JPointer)this.pointers.get(i)).paintOnDial(graphics2D, this.radius, this.oneTurn, this.zero, this.radius, this.radius);
        }
        graphics2D.setColor(color);
        graphics2D.fill(new Ellipse2D.Double(this.radius - 3.0, this.radius - 3.0, 6.0, 6.0));
    }

    public void addJPointer(JPointer jPointer) {
        for (int i = 0; i < this.pointers.size(); ++i) {
            if (!this.pointers.get(i).equals(jPointer)) continue;
            return;
        }
        this.pointers.add(jPointer);
        jPointer.addChangeListener(this.changeListener);
        this.repaint();
    }

    public void removeJPointer(JPointer jPointer) {
        int n = 0;
        while (n < this.pointers.size()) {
            if (this.pointers.get(n).equals(jPointer)) {
                this.pointers.remove(n);
                continue;
            }
            ++n;
        }
        jPointer.removeChangeListener(this.changeListener);
        this.repaint();
    }

    private double theta(MouseEvent mouseEvent) {
        return Math.atan2((double)mouseEvent.getX() - this.radius, -((double)mouseEvent.getY() - this.radius));
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame();
        jFrame.setDefaultCloseOperation(3);
        JRoundDial jRoundDial = new JRoundDial(360.0);
        jRoundDial.setZero(0.5235987755982988);
        jFrame.getContentPane().add(jRoundDial);
        jRoundDial.setSize(260, 260);
        jFrame.pack();
        jFrame.show();
        try {
            Thread.sleep(3000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        JPointer jPointer = new JPointer(1);
        jPointer.setColor(Color.MAGENTA);
        jPointer.setValue(20.0);
        jRoundDial.addJPointer(jPointer);
        try {
            Thread.sleep(3000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        JPointer jPointer2 = new JPointer(2);
        jPointer2.setColor(Color.CYAN);
        jPointer2.setValue(130.0);
        jRoundDial.addJPointer(jPointer2);
        jRoundDial.setPaintTurns(jPointer2);
        jRoundDial.repaint();
        jPointer2.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                double d = ((JPointer)changeEvent.getSource()).getValue();
                System.out.println("State changed: " + d);
            }
        });
    }

    static {
        formatter.setMaximumFractionDigits(2);
        formatter.setMaximumIntegerDigits(3);
    }

    private class TheMouseMotionListener
    extends MouseMotionAdapter {
        private TheMouseMotionListener() {
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            boolean bl = false;
            for (int i = 0; i < JRoundDial.this.pointers.size(); ++i) {
                if (!((JPointer)JRoundDial.this.pointers.get(i)).contains(mouseEvent.getPoint())) continue;
                bl = true;
                break;
            }
            if (bl) {
                JRoundDial.this.setCursor(Cursor.getPredefinedCursor(1));
            } else {
                JRoundDial.this.setCursor(Cursor.getPredefinedCursor(0));
            }
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            if (JRoundDial.this.dragged != null) {
                double d = JRoundDial.this.dragged.getValue();
                double d2 = (JRoundDial.this.theta(mouseEvent) + JRoundDial.this.dragDelta) * JRoundDial.this.oneTurn / 2.0 / Math.PI;
                d2 += d - d2 - (d - d2) % JRoundDial.this.oneTurn;
                while (d2 < d - Math.abs(JRoundDial.this.oneTurn / 2.0)) {
                    d2 += Math.abs(JRoundDial.this.oneTurn);
                }
                while (d2 > d + Math.abs(JRoundDial.this.oneTurn / 2.0)) {
                    d2 -= Math.abs(JRoundDial.this.oneTurn);
                }
                JRoundDial.this.dragged.setValue(d2);
                JRoundDial.this.repaint();
            }
        }
    }

    private class TheMouseListener
    extends MouseAdapter {
        private TheMouseListener() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            for (int i = JRoundDial.this.pointers.size() - 1; i >= 0; --i) {
                if (!((JPointer)JRoundDial.this.pointers.get(i)).contains(mouseEvent.getPoint())) continue;
                JRoundDial.this.dragged = (JPointer)JRoundDial.this.pointers.get(i);
                JRoundDial.this.dragDelta = Math.PI * 2 * JRoundDial.this.dragged.getValue() / JRoundDial.this.oneTurn - JRoundDial.this.theta(mouseEvent);
                JRoundDial.this.dragged.setAdjusting(true);
                break;
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (JRoundDial.this.dragged != null) {
                JRoundDial.this.dragged.setAdjusting(false);
            }
            JRoundDial.this.dragged = null;
            boolean bl = false;
            for (int i = 0; i < JRoundDial.this.pointers.size(); ++i) {
                if (!((JPointer)JRoundDial.this.pointers.get(i)).contains(mouseEvent.getPoint())) continue;
                bl = true;
                break;
            }
            if (bl) {
                JRoundDial.this.setCursor(Cursor.getPredefinedCursor(1));
            } else {
                JRoundDial.this.setCursor(Cursor.getPredefinedCursor(0));
            }
        }
    }
}

