/*
 * Decompiled with CFR 0.152.
 */
package processing.opengl2;

import java.nio.Buffer;
import java.nio.IntBuffer;
import javax.media.opengl.GL;
import javax.media.opengl.GL2GL3;
import processing.core.PApplet;
import processing.core.PConstants;
import processing.opengl2.PGraphicsOpenGL2;
import processing.opengl2.PTexture;

public class PFramebuffer
implements PConstants {
    protected PApplet parent;
    protected PGraphicsOpenGL2 pgl;
    protected GL gl;
    protected GL2GL3 gl2;
    protected int glFboID;
    protected int glDepthBufferID;
    protected int glStencilBufferID;
    protected int glDepthStencilBufferID;
    protected int glColorBufferMultisampleID;
    protected int width;
    protected int height;
    protected int numColorBuffers;
    protected int[] colorBufferAttchPoints;
    protected int[] glColorBufferTargets;
    protected int[] glColorBufferIDs;
    protected boolean screenFb;
    protected boolean noDepth;
    protected boolean fboMode;
    protected boolean multisample;
    protected int nsamples;
    protected PTexture backupTexture;
    protected IntBuffer pixelBuffer;

    PFramebuffer(PApplet parent) {
        this(parent, 0, 0, false);
    }

    PFramebuffer(PApplet parent, int w, int h) {
        this(parent, w, h, false);
    }

    PFramebuffer(PApplet parent, int w, int h, boolean screen) {
        this.parent = parent;
        this.pgl = (PGraphicsOpenGL2)parent.g;
        this.glFboID = 0;
        this.glDepthBufferID = 0;
        this.glStencilBufferID = 0;
        this.glDepthStencilBufferID = 0;
        this.glColorBufferMultisampleID = 0;
        this.screenFb = screen;
        this.noDepth = false;
        this.fboMode = PGraphicsOpenGL2.fboSupported;
        this.numColorBuffers = 0;
        this.multisample = false;
        this.nsamples = 0;
        this.gl = this.pgl.gl;
        this.gl2 = this.pgl.gl2x;
        this.createFramebuffer(w, h);
        this.pixelBuffer = null;
        if (!this.screenFb && !this.fboMode) {
            this.backupTexture = new PTexture(parent, this.width, this.height, new PTexture.Parameters(2, 2));
        }
    }

    public void delete() {
        this.deleteFramebuffer();
    }

    public void clear() {
        this.pgl.pushFramebuffer();
        this.pgl.setFramebuffer(this);
        this.gl.glClearColor(0.0f, 0.0f, 0.0f, 0.0f);
        this.gl.glClear(17664);
        this.pgl.popFramebuffer();
    }

    public void copy(PFramebuffer dest) {
        this.gl.glBindFramebuffer(36008, this.glFboID);
        this.gl.glBindFramebuffer(36009, dest.glFboID);
        this.gl2.glBlitFramebuffer(0, 0, this.width, this.height, 0, 0, dest.width, dest.height, 16384, 9728);
    }

    public void setColorBuffer(PTexture tex) {
        this.setColorBuffers(new PTexture[]{tex}, 1);
    }

    public void setColorBuffers(PTexture[] textures) {
        this.setColorBuffers(textures, textures.length);
    }

    public void setColorBuffers(PTexture[] textures, int n) {
        if (this.screenFb) {
            return;
        }
        if (this.fboMode) {
            this.pgl.pushFramebuffer();
            this.pgl.setFramebuffer(this);
            int i = 0;
            while (i < this.numColorBuffers) {
                this.gl.glFramebufferTexture2D(36160, 36064 + i, 3553, 0, 0);
                ++i;
            }
            this.numColorBuffers = PApplet.min((int)n, (int)textures.length);
            this.colorBufferAttchPoints = new int[this.numColorBuffers];
            this.glColorBufferTargets = new int[this.numColorBuffers];
            this.glColorBufferIDs = new int[this.numColorBuffers];
            i = 0;
            while (i < this.numColorBuffers) {
                this.colorBufferAttchPoints[i] = 36064 + i;
                this.glColorBufferTargets[i] = textures[i].getGLTarget();
                this.glColorBufferIDs[i] = textures[i].getGLID();
                this.gl.glFramebufferTexture2D(36160, this.colorBufferAttchPoints[i], this.glColorBufferTargets[i], this.glColorBufferIDs[i], 0);
                ++i;
            }
            if (this.validFbo() && textures != null && textures.length > 0) {
                this.width = textures[0].getGLWidth();
                this.height = textures[0].getGLHeight();
            }
            this.pgl.popFramebuffer();
        } else {
            this.numColorBuffers = PApplet.min((int)n, (int)textures.length);
            this.glColorBufferTargets = new int[this.numColorBuffers];
            this.glColorBufferIDs = new int[this.numColorBuffers];
            int i = 0;
            while (i < this.numColorBuffers) {
                this.glColorBufferTargets[i] = textures[i].getGLTarget();
                this.glColorBufferIDs[i] = textures[i].getGLID();
                ++i;
            }
        }
    }

    public void addColorBufferMultisample(int samples) {
        if (this.screenFb) {
            return;
        }
        if (this.fboMode) {
            this.pgl.pushFramebuffer();
            this.pgl.setFramebuffer(this);
            this.multisample = true;
            this.nsamples = samples;
            this.numColorBuffers = 1;
            this.colorBufferAttchPoints = new int[this.numColorBuffers];
            this.colorBufferAttchPoints[0] = 36064;
            this.glColorBufferMultisampleID = this.pgl.createGLResource(3);
            this.gl.glBindRenderbuffer(36161, this.glColorBufferMultisampleID);
            this.gl2.glRenderbufferStorageMultisample(36161, this.nsamples, 32856, this.width, this.height);
            this.gl.glFramebufferRenderbuffer(36160, this.colorBufferAttchPoints[0], 36161, this.glColorBufferMultisampleID);
            this.pgl.popFramebuffer();
        }
    }

    public void addDepthStencilBuffer() {
        if (this.screenFb) {
            return;
        }
        if (this.width == 0 || this.height == 0) {
            throw new RuntimeException("PFramebuffer: size undefined.");
        }
        if (this.fboMode) {
            this.pgl.pushFramebuffer();
            this.pgl.setFramebuffer(this);
            this.glDepthStencilBufferID = this.pgl.createGLResource(3);
            this.gl.glBindRenderbuffer(36161, this.glDepthStencilBufferID);
            if (this.multisample) {
                this.gl2.glRenderbufferStorageMultisample(36161, this.nsamples, 35056, this.width, this.height);
            } else {
                this.gl.glRenderbufferStorage(36161, 35056, this.width, this.height);
            }
            this.gl.glFramebufferRenderbuffer(36160, 36096, 36161, this.glDepthStencilBufferID);
            this.gl.glFramebufferRenderbuffer(36160, 36128, 36161, this.glDepthStencilBufferID);
            this.pgl.popFramebuffer();
        }
    }

    public void addDepthBuffer(int bits) {
        if (this.screenFb) {
            return;
        }
        if (this.width == 0 || this.height == 0) {
            throw new RuntimeException("PFramebuffer: size undefined.");
        }
        if (this.fboMode) {
            this.pgl.pushFramebuffer();
            this.pgl.setFramebuffer(this);
            this.glDepthBufferID = this.pgl.createGLResource(3);
            this.gl.glBindRenderbuffer(36161, this.glDepthBufferID);
            int glConst = 33189;
            if (bits == 16) {
                glConst = 33189;
            } else if (bits == 24) {
                glConst = 33190;
            } else if (bits == 32) {
                glConst = 33191;
            }
            if (this.multisample) {
                this.gl2.glRenderbufferStorageMultisample(36161, this.nsamples, glConst, this.width, this.height);
            } else {
                this.gl.glRenderbufferStorage(36161, glConst, this.width, this.height);
            }
            this.gl.glFramebufferRenderbuffer(36160, 36096, 36161, this.glDepthBufferID);
            this.pgl.popFramebuffer();
        }
    }

    public void addStencilBuffer(int bits) {
        if (this.screenFb) {
            return;
        }
        if (this.width == 0 || this.height == 0) {
            throw new RuntimeException("PFramebuffer: size undefined.");
        }
        if (this.fboMode) {
            this.pgl.pushFramebuffer();
            this.pgl.setFramebuffer(this);
            this.glStencilBufferID = this.pgl.createGLResource(3);
            this.gl.glBindRenderbuffer(36161, this.glStencilBufferID);
            int glConst = 36166;
            if (bits == 1) {
                glConst = 36166;
            } else if (bits == 4) {
                glConst = 36167;
            } else if (bits == 8) {
                glConst = 36168;
            }
            if (this.multisample) {
                this.gl2.glRenderbufferStorageMultisample(36161, this.nsamples, glConst, this.width, this.height);
            } else {
                this.gl.glRenderbufferStorage(36161, glConst, this.width, this.height);
            }
            this.gl.glFramebufferRenderbuffer(36160, 36128, 36161, this.glStencilBufferID);
            this.pgl.popFramebuffer();
        }
    }

    public void bind() {
        if (this.screenFb) {
            if (PGraphicsOpenGL2.fboSupported) {
                this.gl.glBindFramebuffer(36160, 0);
            }
        } else if (this.fboMode) {
            this.gl.glBindFramebuffer(36160, this.glFboID);
        } else {
            this.backupScreen();
            if (this.noDepth) {
                this.gl.glDisable(2929);
            }
        }
    }

    public void disableDepthTest() {
        this.noDepth = true;
    }

    public void finish() {
        if (this.noDepth) {
            if (this.pgl.hintEnabled(4)) {
                this.gl.glDisable(2929);
            } else {
                this.gl.glEnable(2929);
            }
        }
        if (!this.screenFb && !this.fboMode) {
            this.copyToColorBuffers();
            this.restoreBackup();
            if (!this.noDepth) {
                this.gl.glClearColor(0.0f, 0.0f, 0.0f, 0.0f);
                this.gl.glClear(256);
            }
        }
    }

    public void backupScreen() {
        if (this.pixelBuffer == null) {
            this.allocatePixelBuffer();
        }
        this.gl.glReadPixels(0, 0, this.width, this.height, 6408, 5121, (Buffer)this.pixelBuffer);
        this.copyToTexture(this.pixelBuffer, this.backupTexture.getGLID(), this.backupTexture.getGLTarget());
    }

    public void restoreBackup() {
        this.pgl.drawTexture(this.backupTexture, 0, 0, this.width, this.height, 0, 0, this.width, this.height);
    }

    public void copyToColorBuffers() {
        if (this.pixelBuffer == null) {
            this.allocatePixelBuffer();
        }
        this.gl.glReadPixels(0, 0, this.width, this.height, 6408, 5121, (Buffer)this.pixelBuffer);
        int i = 0;
        while (i < this.numColorBuffers) {
            this.copyToTexture(this.pixelBuffer, this.glColorBufferIDs[i], this.glColorBufferTargets[i]);
            ++i;
        }
    }

    public void readPixels() {
        if (this.pixelBuffer == null) {
            this.allocatePixelBuffer();
        }
        this.gl.glReadPixels(0, 0, this.width, this.height, 6408, 5121, (Buffer)this.pixelBuffer);
    }

    public void getPixels(int[] pixels) {
        if (this.pixelBuffer != null) {
            this.pixelBuffer.get(pixels);
            this.pixelBuffer.rewind();
        }
    }

    public IntBuffer getPixelBuffer() {
        return this.pixelBuffer;
    }

    protected void copyToTexture(IntBuffer buffer, int glid, int gltarget) {
        this.gl.glEnable(gltarget);
        this.gl.glBindTexture(gltarget, glid);
        this.gl.glTexSubImage2D(gltarget, 0, 0, 0, this.width, this.height, 6408, 5121, (Buffer)buffer);
        this.gl.glBindTexture(gltarget, 0);
        this.gl.glDisable(gltarget);
    }

    protected void allocatePixelBuffer() {
        this.pixelBuffer = IntBuffer.allocate(this.width * this.height);
        this.pixelBuffer.rewind();
    }

    protected void createFramebuffer(int w, int h) {
        this.deleteFramebuffer();
        this.width = w;
        this.height = h;
        this.glFboID = this.screenFb ? 0 : (this.fboMode ? this.pgl.createGLResource(2) : 0);
    }

    protected void deleteFramebuffer() {
        if (this.glFboID != 0) {
            this.pgl.deleteGLResource(this.glFboID, 2);
            this.glFboID = 0;
        }
        if (this.glDepthBufferID != 0) {
            this.pgl.deleteGLResource(this.glDepthBufferID, 3);
            this.glDepthBufferID = 0;
        }
        if (this.glStencilBufferID != 0) {
            this.pgl.deleteGLResource(this.glStencilBufferID, 3);
            this.glStencilBufferID = 0;
        }
        if (this.glColorBufferMultisampleID != 0) {
            this.pgl.deleteGLResource(this.glColorBufferMultisampleID, 3);
            this.glColorBufferMultisampleID = 0;
        }
        if (this.glDepthStencilBufferID != 0) {
            this.pgl.deleteGLResource(this.glDepthStencilBufferID, 3);
            this.glDepthStencilBufferID = 0;
        }
        this.height = 0;
        this.width = 0;
    }

    public boolean validFbo() {
        int status = this.gl.glCheckFramebufferStatus(36160);
        if (status == 36053) {
            return true;
        }
        if (status == 36054) {
            throw new RuntimeException("PFramebuffer: GL_FRAMEBUFFER_INCOMPLETE_ATTACHMENT (" + Integer.toHexString(status) + ")");
        }
        if (status == 36055) {
            throw new RuntimeException("PFramebuffer: GL_FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT (" + Integer.toHexString(status) + ")");
        }
        if (status == 36057) {
            throw new RuntimeException("PFramebuffer: GL_FRAMEBUFFER_INCOMPLETE_DIMENSIONS (" + Integer.toHexString(status) + ")");
        }
        if (status == 36058) {
            throw new RuntimeException("PFramebuffer: GL_FRAMEBUFFER_INCOMPLETE_FORMATS (" + Integer.toHexString(status) + ")");
        }
        if (status == 36061) {
            throw new RuntimeException("PFramebuffer: GL_FRAMEBUFFER_UNSUPPORTED" + Integer.toHexString(status));
        }
        throw new RuntimeException("PFramebuffer: unknown framebuffer error (" + Integer.toHexString(status) + ")");
    }
}

