/*
 * Decompiled with CFR 0.152.
 */
package processing.opengl2;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EmptyStackException;
import java.util.HashSet;
import java.util.Set;
import java.util.Stack;
import javax.media.nativewindow.AbstractGraphicsConfiguration;
import javax.media.nativewindow.AbstractGraphicsScreen;
import javax.media.nativewindow.CapabilitiesImmutable;
import javax.media.nativewindow.GraphicsConfigurationFactory;
import javax.media.nativewindow.NativeSurface;
import javax.media.nativewindow.NativeWindow;
import javax.media.nativewindow.NativeWindowFactory;
import javax.media.nativewindow.awt.AWTGraphicsConfiguration;
import javax.media.nativewindow.awt.AWTGraphicsDevice;
import javax.media.nativewindow.awt.AWTGraphicsScreen;
import javax.media.opengl.GL;
import javax.media.opengl.GL2ES1;
import javax.media.opengl.GL2ES2;
import javax.media.opengl.GL2GL3;
import javax.media.opengl.GL3;
import javax.media.opengl.GL4;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLContext;
import javax.media.opengl.GLDrawable;
import javax.media.opengl.GLDrawableFactory;
import javax.media.opengl.GLException;
import javax.media.opengl.GLProfile;
import processing.core.PApplet;
import processing.core.PFont;
import processing.core.PGraphics;
import processing.core.PImage;
import processing.core.PMatrix;
import processing.core.PMatrix2D;
import processing.core.PMatrix3D;
import processing.core.PMetadata;
import processing.core.PParameters;
import processing.core.PShape;
import processing.core.PVector;
import processing.opengl2.PFontTexture;
import processing.opengl2.PFramebuffer;
import processing.opengl2.PShape3D;
import processing.opengl2.PTexture;

public class PGraphicsOpenGL2
extends PGraphics {
    public int pipeline;
    public GL gl;
    public GL2GL3 gl2x;
    public GL2ES1 gl2f;
    public GL2ES2 gl2p;
    public GL3 gl3p;
    public GL4 gl4p;
    protected GLProfile profile;
    protected GLCapabilities capabilities;
    protected GLDrawable drawable;
    protected GLContext context;
    protected PGraphicsOpenGL2 pgl;
    protected static boolean glparamsRead = false;
    protected static boolean npotTexSupported;
    protected static boolean mipmapGeneration;
    protected static boolean matrixGetSupported;
    protected static boolean vboSupported;
    protected static boolean fboSupported;
    protected static boolean blendEqSupported;
    protected static boolean texenvCrossbarSupported;
    protected static boolean fboMultisampleSupported;
    protected static int maxTextureSize;
    protected static float maxPointSize;
    protected static float maxLineWidth;
    protected static int maxTextureUnits;
    public static String OPENGL_VENDOR;
    public static String OPENGL_RENDERER;
    public static String OPENGL_VERSION;
    protected static final int GL_TEXTURE_OBJECT = 0;
    protected static final int GL_VERTEX_BUFFER = 1;
    protected static final int GL_FRAME_BUFFER = 2;
    protected static final int GL_RENDER_BUFFER = 3;
    protected static Set<Integer> glTextureObjects;
    protected static Set<Integer> glVertexBuffers;
    protected static Set<Integer> glFrameBuffers;
    protected static Set<Integer> glRenderBuffers;
    public float cameraFOV;
    public float cameraX;
    public float cameraY;
    public float cameraZ;
    public float cameraNear;
    public float cameraFar;
    public float cameraAspect;
    protected boolean manipulatingCamera;
    protected boolean scalingDuringCamManip;
    protected float[] glmodelview;
    protected float[] glmodelviewInv;
    protected float[] glprojection;
    protected float[] pcamera;
    protected float[] pcameraInv;
    protected float[] gltemp;
    public PMatrix3D modelview;
    public PMatrix3D modelviewInv;
    public PMatrix3D projection;
    public PMatrix3D camera;
    public PMatrix3D cameraInv;
    protected boolean modelviewUpdated;
    protected boolean projectionUpdated;
    protected boolean projectionMode = false;
    protected boolean matricesAllocated = false;
    protected static boolean usingGLMatrixStack;
    protected static GLMatrixStack modelviewStack;
    protected static GLMatrixStack projectionStack;
    public static final int MAX_LIGHTS = 8;
    public boolean lights;
    public int lightCount = 0;
    public int[] lightType;
    public float[][] lightPosition;
    public float[][] lightNormal;
    public float[] lightFalloffConstant;
    public float[] lightFalloffLinear;
    public float[] lightFalloffQuadratic;
    public float[] lightSpotAngle;
    public float[] lightSpotAngleCos;
    public float[] lightSpotConcentration;
    public float[][] lightDiffuse;
    public float[][] lightSpecular;
    public float[] currentLightSpecular;
    public float currentLightFalloffConstant;
    public float currentLightFalloffLinear;
    public float currentLightFalloffQuadratic;
    public float[] zeroLight = new float[]{0.0f, 0.0f, 0.0f, 1.0f};
    public float[] baseLight = new float[]{0.05f, 0.05f, 0.05f, 1.0f};
    protected boolean lightsAllocated = false;
    protected static final int VERTEX1 = 0;
    protected static final int VERTEX2 = 1;
    protected static final int VERTEX3 = 2;
    protected static final int POINT_FIELD_COUNT = 2;
    protected static final int LINE_FIELD_COUNT = 2;
    protected static final int TRIANGLE_FIELD_COUNT = 3;
    public static final int DEFAULT_POINTS = 512;
    protected int pointCount;
    protected int[][] points = new int[512][2];
    public static final int DEFAULT_LINES = 512;
    protected int lineCount;
    protected int[][] lines = new int[512][2];
    public static final int DEFAULT_TRIANGLES = 256;
    protected int triangleCount;
    protected int[][] triangles = new int[256][3];
    public static final int DEFAULT_BUFFER_SIZE = 512;
    protected FloatBuffer vertexBuffer;
    protected FloatBuffer colorBuffer;
    protected FloatBuffer normalBuffer;
    protected FloatBuffer[] texCoordBuffer;
    protected float[] vertexArray;
    protected float[] colorArray;
    protected float[] normalArray;
    protected float[][] texCoordArray;
    protected boolean geometryAllocated = false;
    protected int shapeFirst;
    protected int shapeLast;
    protected int[] vertexOrder = new int[512];
    public static final int DEFAULT_PATHS = 64;
    protected int pathCount;
    protected int[] pathOffset = new int[64];
    protected int[] pathLength = new int[64];
    public static final int DEFAULT_FACES = 64;
    protected int faceCount;
    protected int[] faceOffset = new int[64];
    protected int[] faceLength = new int[64];
    protected PImage[][] faceTextures = new PImage[64][2];
    public static final int MAX_TEXTURES = 2;
    protected int numMultitextures;
    protected int numTexBuffers;
    protected int multitexureBlendMode;
    protected PTexture[] renderTextures = new PTexture[2];
    protected PImage[] multitextureImages = new PImage[2];
    protected PImage[] multitextureImages0 = new PImage[2];
    protected float[] multitextureU = new float[2];
    protected float[] multitextureV = new float[2];
    protected float[][] vertexU = new float[512][1];
    protected float[][] vertexV = new float[512][1];
    protected PImage[][] vertexTex = new PImage[512][1];
    protected float[] renderUa = new float[2];
    protected float[] renderVa = new float[2];
    protected float[] renderUb = new float[2];
    protected float[] renderVb = new float[2];
    protected float[] renderUc = new float[2];
    protected float[] renderVc = new float[2];
    protected boolean blend;
    protected int blendMode;
    PFontTexture textTex;
    protected FloatBuffer textVertexBuffer = null;
    protected FloatBuffer textTexCoordBuffer = null;
    protected float[] textVertexArray = null;
    protected float[] textTexCoordArray = null;
    protected int textVertexCount = 0;
    protected boolean textBlockMode = false;
    protected int textBlockTex;
    protected static FloatBuffer quadVertexBuffer;
    protected static FloatBuffer quadTexCoordBuffer;
    protected static Stack<PFramebuffer> fbStack;
    protected static PFramebuffer screenFramebuffer;
    protected static PFramebuffer currentFramebuffer;
    protected PFramebuffer offscreenFramebuffer;
    protected PFramebuffer offscreenFramebufferMultisample;
    protected boolean offscreenMultisample;
    public int offscreenDepthBits = 24;
    public int offscreenStencilBits = 8;
    protected boolean recordingShape;
    protected int numRecordedTextures = 0;
    protected boolean mergeRecShapes = false;
    protected String recShapeName;
    protected PShape3D recordedShape = null;
    protected ArrayList<PVector> recordedVertices = null;
    protected ArrayList<float[]> recordedColors = null;
    protected ArrayList<PVector> recordedNormals = null;
    protected ArrayList<PVector>[] recordedTexCoords = null;
    protected ArrayList<PShape3D> recordedChildren = null;
    protected PTexture texture;
    protected int[] texCrop;
    protected IntBuffer pixelBuffer;
    protected IntBuffer getsetBuffer;
    protected PTexture getsetTexture;
    protected DrawingState drawState;
    protected float[] colorFloats;
    public static boolean BIG_ENDIAN;
    protected static final int SIZEOF_INT = 4;
    protected static final int SIZEOF_FLOAT = 4;

    static {
        glTextureObjects = new HashSet<Integer>();
        glVertexBuffers = new HashSet<Integer>();
        glFrameBuffers = new HashSet<Integer>();
        glRenderBuffers = new HashSet<Integer>();
        quadVertexBuffer = null;
        quadTexCoordBuffer = null;
        BIG_ENDIAN = ByteOrder.nativeOrder() == ByteOrder.BIG_ENDIAN;
    }

    public void setPrimary(boolean primary) {
        super.setPrimary(primary);
        this.format = 2;
    }

    public void setSize(int iwidth, int iheight) {
        this.width = iwidth;
        this.height = iheight;
        this.width1 = this.width - 1;
        this.height1 = this.height - 1;
        this.allocate();
        this.reapplySettings();
        this.vertexCheck();
        this.cameraFOV = 1.0471976f;
        this.cameraX = (float)this.width / 2.0f;
        this.cameraY = (float)this.height / 2.0f;
        this.cameraZ = this.cameraY / (float)Math.tan(this.cameraFOV / 2.0f);
        this.cameraNear = this.cameraZ / 10.0f;
        this.cameraFar = this.cameraZ * 10.0f;
        this.cameraAspect = (float)this.width / (float)this.height;
    }

    protected void allocate() {
        super.allocate();
        if (!this.matricesAllocated) {
            this.glprojection = new float[16];
            this.glmodelview = new float[16];
            this.glmodelviewInv = new float[16];
            this.pcamera = new float[16];
            this.pcameraInv = new float[16];
            this.gltemp = new float[16];
            this.projection = new PMatrix3D();
            this.modelview = new PMatrix3D();
            this.modelviewInv = new PMatrix3D();
            this.camera = new PMatrix3D();
            this.cameraInv = new PMatrix3D();
            this.matricesAllocated = true;
        }
        if (!this.lightsAllocated) {
            this.lightType = new int[8];
            this.lightPosition = new float[8][4];
            this.lightNormal = new float[8][4];
            this.lightDiffuse = new float[8][4];
            this.lightSpecular = new float[8][4];
            this.lightFalloffConstant = new float[8];
            this.lightFalloffLinear = new float[8];
            this.lightFalloffQuadratic = new float[8];
            this.lightSpotAngle = new float[8];
            this.lightSpotAngleCos = new float[8];
            this.lightSpotConcentration = new float[8];
            this.currentLightSpecular = new float[4];
            this.lightsAllocated = true;
        }
        if (!this.geometryAllocated) {
            ByteBuffer vbb = ByteBuffer.allocateDirect(6144);
            vbb.order(ByteOrder.nativeOrder());
            this.vertexBuffer = vbb.asFloatBuffer();
            ByteBuffer cbb = ByteBuffer.allocateDirect(8192);
            cbb.order(ByteOrder.nativeOrder());
            this.colorBuffer = cbb.asFloatBuffer();
            ByteBuffer nbb = ByteBuffer.allocateDirect(6144);
            nbb.order(ByteOrder.nativeOrder());
            this.normalBuffer = nbb.asFloatBuffer();
            this.texCoordBuffer = new FloatBuffer[2];
            ByteBuffer tbb = ByteBuffer.allocateDirect(4096);
            tbb.order(ByteOrder.nativeOrder());
            this.texCoordBuffer[0] = tbb.asFloatBuffer();
            this.vertexArray = new float[1536];
            this.colorArray = new float[2048];
            this.normalArray = new float[1536];
            this.texCoordArray = new float[1][1024];
            this.numTexBuffers = 1;
            this.geometryAllocated = true;
        }
        if (this.primarySurface) {
            if (this.context == null) {
                this.initPrimary();
            } else {
                this.context.destroy();
                this.context = this.drawable.createContext(null);
                this.reapplySettings();
            }
        } else if (this.context == null) {
            this.initOffscreen();
        } else {
            this.reapplySettings();
        }
    }

    public void delete() {
        if (this.primarySurface) {
            PGraphics.showWarning((String)"You cannot delete the primary rendering surface!");
        } else {
            super.delete();
            if (this.offscreenFramebuffer != null) {
                this.offscreenFramebuffer.delete();
            }
        }
    }

    public void dispose() {
        super.dispose();
        this.deleteAllGLResources();
        GLProfile.shutdown();
    }

    protected int createGLResource(int type) {
        int id = 0;
        if (type == 0) {
            int[] temp = new int[1];
            this.gl.glGenTextures(1, temp, 0);
            id = temp[0];
            glTextureObjects.add(id);
        } else if (type == 1) {
            int[] temp = new int[1];
            this.gl.glGenBuffers(1, temp, 0);
            id = temp[0];
            glVertexBuffers.add(id);
        } else if (type == 2) {
            int[] temp = new int[1];
            this.gl.glGenFramebuffers(1, temp, 0);
            id = temp[0];
            glFrameBuffers.add(id);
        } else if (type == 3) {
            int[] temp = new int[1];
            this.gl.glGenRenderbuffers(1, temp, 0);
            id = temp[0];
            glRenderBuffers.add(id);
        }
        return id;
    }

    protected void deleteGLResource(int id, int type) {
        if (type == 0) {
            if (glTextureObjects.contains(id)) {
                int[] temp = new int[]{id};
                this.gl.glDeleteTextures(1, temp, 0);
                glTextureObjects.remove(id);
            }
        } else if (type == 1) {
            if (glVertexBuffers.contains(id)) {
                int[] temp = new int[]{id};
                this.gl.glDeleteBuffers(1, temp, 0);
                glVertexBuffers.remove(id);
            }
        } else if (type == 2) {
            if (glFrameBuffers.contains(id)) {
                int[] temp = new int[]{id};
                this.gl.glDeleteFramebuffers(1, temp, 0);
                glFrameBuffers.remove(id);
            }
        } else if (type == 3 && glRenderBuffers.contains(id)) {
            int[] temp = new int[]{id};
            this.gl.glDeleteRenderbuffers(1, temp, 0);
            glRenderBuffers.remove(id);
        }
    }

    protected void deleteAllGLResources() {
        int[] temp;
        int id;
        int i;
        Object[] glids;
        super.delete();
        if (!glTextureObjects.isEmpty()) {
            glids = glTextureObjects.toArray();
            i = 0;
            while (i < glids.length) {
                id = (Integer)glids[i];
                temp = new int[]{id};
                this.gl.glDeleteTextures(1, temp, 0);
                ++i;
            }
            glTextureObjects.clear();
        }
        if (!glVertexBuffers.isEmpty()) {
            glids = glVertexBuffers.toArray();
            i = 0;
            while (i < glids.length) {
                id = (Integer)glids[i];
                temp = new int[]{id};
                this.gl.glDeleteBuffers(1, temp, 0);
                ++i;
            }
            glVertexBuffers.clear();
        }
        if (!glFrameBuffers.isEmpty()) {
            glids = glFrameBuffers.toArray();
            i = 0;
            while (i < glids.length) {
                id = (Integer)glids[i];
                temp = new int[]{id};
                this.gl.glDeleteFramebuffers(1, temp, 0);
                ++i;
            }
            glFrameBuffers.clear();
        }
        if (!glRenderBuffers.isEmpty()) {
            glids = glRenderBuffers.toArray();
            i = 0;
            while (i < glids.length) {
                id = (Integer)glids[i];
                temp = new int[]{id};
                this.gl.glDeleteRenderbuffers(1, temp, 0);
                ++i;
            }
            glRenderBuffers.clear();
        }
    }

    public void pushFramebuffer() {
        fbStack.push(currentFramebuffer);
    }

    public void setFramebuffer(PFramebuffer fbo) {
        currentFramebuffer = fbo;
        currentFramebuffer.bind();
    }

    public void popFramebuffer() {
        try {
            currentFramebuffer.finish();
            currentFramebuffer = fbStack.pop();
            currentFramebuffer.bind();
        }
        catch (EmptyStackException e) {
            PGraphics.showWarning((String)"OPENGL2: Empty framebuffer stack");
        }
    }

    public GLContext getContext() {
        return this.context;
    }

    public GLCapabilities getCapabilities() {
        return this.capabilities;
    }

    protected void detainContext() {
        try {
            while (this.context.makeCurrent() == 0) {
                Thread.sleep(10L);
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    protected void releaseContext() {
        this.context.release();
    }

    public boolean canDraw() {
        return this.parent.isDisplayable();
    }

    public void beginDraw() {
        if (this.primarySurface && this.drawable != null) {
            this.drawable.setRealized(this.parent.isDisplayable());
            if (!this.parent.isDisplayable()) {
                return;
            }
            this.drawable.setRealized(true);
            this.detainContext();
        }
        this.getGLObjects();
        if (!glparamsRead) {
            this.getGLParameters();
        }
        if (!this.settingsInited) {
            this.defaultSettings();
        }
        this.report("top beginDraw()");
        if (!this.primarySurface) {
            this.pgl.saveGLState();
            this.pgl.disableLights();
        }
        this.vertexBuffer.rewind();
        this.colorBuffer.rewind();
        this.normalBuffer.rewind();
        int t = 0;
        while (t < this.numTexBuffers) {
            this.texCoordBuffer[t].rewind();
            ++t;
        }
        this.noTexture();
        this.blend(1);
        this.textureBlend(1);
        if (this.hints[4]) {
            this.gl.glDisable(2929);
        } else {
            this.gl.glEnable(2929);
        }
        this.gl.glDepthFunc(515);
        if (this.hints[8]) {
            this.gl.glDepthMask(false);
        } else {
            this.gl.glDepthMask(true);
        }
        this.gl.glViewport(0, 0, this.width, this.height);
        this.camera();
        this.perspective();
        this.noLights();
        this.lightFalloff(1.0f, 0.0f, 0.0f);
        this.lightSpecular(0.0f, 0.0f, 0.0f);
        this.gl.glFrontFace(2304);
        this.setSurfaceParams();
        this.shapeFirst = 0;
        this.normalZ = 0.0f;
        this.normalY = 0.0f;
        this.normalX = 0.0f;
        if (!this.primarySurface) {
            this.pushFramebuffer();
            if (this.offscreenMultisample) {
                this.setFramebuffer(this.offscreenFramebufferMultisample);
                this.gl2x.glDrawBuffer(36064);
            } else {
                this.setFramebuffer(this.offscreenFramebuffer);
            }
        }
        this.gl.glClearColor(0.0f, 0.0f, 0.0f, 0.0f);
        this.gl.glClear(1280);
        this.report("bot beginDraw()");
    }

    public void endDraw() {
        this.report("top endDraw()");
        super.endDraw();
        if (this.hints[5]) {
            this.flush();
        }
        if (this.primarySurface) {
            this.gl.glFlush();
            if (this.drawable != null) {
                this.drawable.swapBuffers();
                this.releaseContext();
            }
        } else {
            if (this.offscreenMultisample) {
                this.offscreenFramebufferMultisample.copy(this.offscreenFramebuffer);
            }
            this.popFramebuffer();
            this.pgl.restoreGLState();
        }
        this.report("bot endDraw()");
    }

    public GL beginGL() {
        this.saveGLState();
        return this.gl;
    }

    public void endGL() {
        this.restoreGLState();
    }

    protected void saveGLState() {
        this.saveGLMatrices();
    }

    protected void restoreGLState() {
        this.gl.glViewport(0, 0, this.width, this.height);
        this.restoreGLMatrices();
        if (this.hints[4]) {
            this.gl.glDisable(2929);
            this.gl.glClear(256);
        } else {
            this.gl.glEnable(2929);
        }
        if (this.hints[8]) {
            this.gl.glDepthMask(false);
        } else {
            this.gl.glDepthMask(true);
        }
        if (this.blend) {
            this.blend(this.blendMode);
        } else {
            this.noBlend();
        }
        if (this.fill) {
            this.calcR = this.fillR;
            this.calcG = this.fillG;
            this.calcB = this.fillB;
            this.calcA = this.fillA;
            this.fillFromCalc();
        }
        this.calcR = this.ambientR;
        this.calcG = this.ambientG;
        this.calcB = this.ambientB;
        this.ambientFromCalc();
        this.calcR = this.specularR;
        this.calcG = this.specularG;
        this.calcB = this.specularB;
        this.specularFromCalc();
        this.shininess(this.shininess);
        this.calcR = this.emissiveR;
        this.calcG = this.emissiveG;
        this.calcB = this.emissiveB;
        this.emissiveFromCalc();
        if (this.lights) {
            this.lights();
            int i = 0;
            while (i < this.lightCount) {
                this.lightEnable(i);
                if (this.lightType[i] == 0) {
                    this.lightEnable(i);
                    this.lightAmbient(i);
                    this.lightPosition(i);
                    this.lightFalloff(i);
                    this.lightNoSpot(i);
                    this.lightNoDiffuse(i);
                    this.lightNoSpecular(i);
                } else if (this.lightType[i] == 1) {
                    this.lightEnable(i);
                    this.lightNoAmbient(i);
                    this.lightDirection(i);
                    this.lightDiffuse(i);
                    this.lightSpecular(i);
                    this.lightFalloff(i);
                    this.lightNoSpot(i);
                } else if (this.lightType[i] == 2) {
                    this.lightEnable(i);
                    this.lightNoAmbient(i);
                    this.lightPosition(i);
                    this.lightDiffuse(i);
                    this.lightSpecular(i);
                    this.lightFalloff(i);
                    this.lightNoSpot(i);
                } else if (this.lightType[i] == 3) {
                    this.lightEnable(i);
                    this.lightNoAmbient(i);
                    this.lightPosition(i);
                    this.lightDirection(i);
                    this.lightDiffuse(i);
                    this.lightSpecular(i);
                    this.lightFalloff(i);
                    this.lightSpotAngle(i);
                    this.lightSpotConcentration(i);
                }
                ++i;
            }
        } else {
            this.noLights();
        }
        this.gl.glFrontFace(2304);
        this.gl.glDepthFunc(515);
        this.setSurfaceParams();
    }

    protected void saveDrawingState() {
        if (this.drawState == null) {
            this.drawState = new DrawingState();
        }
        this.drawState.save();
    }

    protected void restoreDrawingState() {
        this.drawState.restore();
    }

    protected void defaultSettings() {
        super.defaultSettings();
        this.manipulatingCamera = false;
        this.scalingDuringCamManip = false;
        if (fbStack == null) {
            fbStack = new Stack();
            screenFramebuffer = new PFramebuffer(this.parent, this.width, this.height, true);
            this.setFramebuffer(screenFramebuffer);
        }
        if (usingGLMatrixStack) {
            if (modelviewStack == null) {
                modelviewStack = new GLMatrixStack();
            }
            if (projectionStack == null) {
                projectionStack = new GLMatrixStack();
            }
        }
        this.textureMode(2);
    }

    public void hint(int which) {
        boolean opengl2X = !this.hints[1];
        boolean opengl4X = this.hints[2];
        super.hint(which);
        if (which == 4) {
            this.gl.glDisable(2929);
            this.gl.glClear(256);
        } else if (which == -4) {
            this.gl.glEnable(2929);
        } else if (which == 8) {
            this.gl.glDepthMask(false);
        } else if (which == -8) {
            this.gl.glDepthMask(true);
        } else if (which == 1) {
            if (opengl2X) {
                if (this.primarySurface) {
                    this.releaseContext();
                    this.context.destroy();
                    this.context = null;
                    this.allocate();
                    throw new PApplet.RendererChangeException();
                }
                this.initOffscreen();
            }
        } else if (which != -1 && which == 2 && !opengl4X) {
            if (this.primarySurface) {
                this.releaseContext();
                this.context.destroy();
                this.context = null;
                this.allocate();
                throw new PApplet.RendererChangeException();
            }
            this.initOffscreen();
        }
    }

    public PShape beginRecord() {
        if (this.recordingShape) {
            System.err.println("OPENGL2: Already recording.");
            return this.recordedShape;
        }
        this.recordedShape = new PShape3D(this.parent);
        this.beginShapeRecorderImpl();
        return this.recordedShape;
    }

    public boolean isRecording() {
        return this.recordingShape;
    }

    protected void beginShapeRecorder() {
        this.beginShapeRecorder(20);
    }

    protected void beginShapeRecorder(int kind) {
        this.beginShapeRecorderImpl();
        this.beginShape(kind);
    }

    protected void beginShapesRecorder() {
        if (this.recordingShape) {
            System.err.println("Already recording shapes. Recording cannot be nested");
        } else {
            this.beginShapeRecorderImpl();
        }
    }

    protected void beginShapeRecorderImpl() {
        this.recordingShape = true;
        this.recShapeName = "";
        if (this.recordedVertices == null) {
            this.recordedVertices = new ArrayList(this.vertexBuffer.capacity() / 3);
        } else {
            this.recordedVertices.ensureCapacity(this.vertexBuffer.capacity() / 3);
        }
        if (this.recordedColors == null) {
            this.recordedColors = new ArrayList(this.colorBuffer.capacity() / 4);
        } else {
            this.recordedColors.ensureCapacity(this.colorBuffer.capacity() / 4);
        }
        if (this.recordedNormals == null) {
            this.recordedNormals = new ArrayList(this.normalBuffer.capacity() / 3);
        } else {
            this.recordedNormals.ensureCapacity(this.normalBuffer.capacity() / 3);
        }
        int size = this.texCoordBuffer[0].capacity() / 2;
        if (this.recordedTexCoords == null) {
            this.recordedTexCoords = new ArrayList[2];
            int t = 0;
            while (t < maxTextureUnits) {
                this.recordedTexCoords[t] = new ArrayList(size);
                ++t;
            }
        } else {
            int t = 0;
            while (t < maxTextureUnits) {
                this.recordedTexCoords[t].ensureCapacity(size);
                ++t;
            }
        }
        this.numRecordedTextures = 0;
        this.recordedChildren = new ArrayList(PApplet.max((int)64, (int)64));
    }

    public void beginShape(int kind) {
        this.shape = kind;
        if (this.hints[5]) {
            this.shapeFirst = this.vertexCount;
            this.shapeLast = 0;
        } else {
            this.vertexCount = 0;
            this.lineCount = 0;
            this.triangleCount = 0;
        }
        this.noTexture();
    }

    public void mergeRecord() {
        this.mergeRecShapes = true;
    }

    public void noMergeRecord() {
        this.mergeRecShapes = false;
    }

    public void shapeName(String name) {
        this.recShapeName = name;
    }

    public void texture(PImage image) {
        super.texture(image);
        this.multitextureImages[0] = image;
        Arrays.fill(this.multitextureImages, 1, maxTextureUnits, null);
        this.numMultitextures = 1;
    }

    public void texture(PImage image0, PImage image1) {
        if (1 < maxTextureUnits) {
            super.texture(image0);
            this.multitextureImages[0] = image0;
            this.multitextureImages[1] = image1;
            Arrays.fill(this.multitextureImages, 2, maxTextureUnits, null);
            this.numMultitextures = 2;
            if (this.numTexBuffers < 2) {
                this.addTexBuffers(2 - this.numTexBuffers);
            }
        } else {
            System.err.println("OPENGL2: insufficient texture units.");
        }
    }

    public void texture(PImage image0, PImage image1, PImage image2) {
        if (2 < maxTextureUnits) {
            super.texture(image0);
            this.multitextureImages[0] = image0;
            this.multitextureImages[1] = image1;
            this.multitextureImages[2] = image2;
            Arrays.fill(this.multitextureImages, 3, maxTextureUnits, null);
            this.numMultitextures = 3;
            if (this.numTexBuffers < 3) {
                this.addTexBuffers(3 - this.numTexBuffers);
            }
        } else {
            System.err.println("OPENGL2: insufficient texture units.");
        }
    }

    public void texture(PImage image0, PImage image1, PImage image2, PImage image3) {
        if (3 < maxTextureUnits) {
            super.texture(image0);
            this.multitextureImages[0] = image0;
            this.multitextureImages[1] = image1;
            this.multitextureImages[2] = image2;
            this.multitextureImages[3] = image3;
            Arrays.fill(this.multitextureImages, 4, maxTextureUnits, null);
            this.numMultitextures = 4;
            if (this.numTexBuffers < 4) {
                this.addTexBuffers(4 - this.numTexBuffers);
            }
        } else {
            System.err.println("OPENGL2: insufficient texture units.");
        }
    }

    public void texture(PImage[] images) {
        int len = images.length;
        if (len <= maxTextureUnits) {
            super.texture(images[0]);
            PApplet.arrayCopy((Object)images, (int)0, (Object)this.multitextureImages, (int)0, (int)len);
            Arrays.fill(this.multitextureImages, len, maxTextureUnits, null);
            this.numMultitextures = len;
            if (this.numTexBuffers < len) {
                this.addTexBuffers(len - this.numTexBuffers);
            }
        } else {
            System.err.println("OPENGL2: insufficient texture units.");
        }
    }

    public void noTexture() {
        super.noTexture();
        this.numMultitextures = 0;
        this.clearMultitextures();
        this.clearMultitextures0();
    }

    public void vertex(float x, float y, float u, float v) {
        this.vertexTexture(u, v, 0);
        this.vertex(x, y);
        int n = this.vertexCount - 1;
        int i = 0;
        while (i < this.numMultitextures) {
            this.vertexTex[n][i] = this.multitextureImages[i];
            this.vertexU[n][i] = this.multitextureU[0];
            this.vertexV[n][i] = this.multitextureV[0];
            ++i;
        }
    }

    public void vertex(float x, float y, float u0, float v0, float u1, float v1) {
        if (2 <= maxTextureUnits) {
            this.vertexTexture(u0, v0, 0);
            this.vertexTexture(u1, v1, 1);
            this.vertex(x, y);
            this.setMultitextureData(2);
        } else {
            System.err.println("OPENGL2: insufficient texture units.");
        }
    }

    public void vertex(float x, float y, float u0, float v0, float u1, float v1, float u2, float v2) {
        if (3 <= maxTextureUnits) {
            this.vertexTexture(u0, v0, 0);
            this.vertexTexture(u1, v1, 1);
            this.vertexTexture(u2, v2, 2);
            this.vertex(x, y);
            this.setMultitextureData(3);
        } else {
            System.err.println("OPENGL2: insufficient texture units.");
        }
    }

    public void vertex(float x, float y, float u0, float v0, float u1, float v1, float u2, float v2, float u3, float v3) {
        if (4 <= maxTextureUnits) {
            this.vertexTexture(u0, v0, 0);
            this.vertexTexture(u1, v1, 1);
            this.vertexTexture(u2, v2, 2);
            this.vertexTexture(u2, v2, 3);
            this.vertex(x, y);
            this.setMultitextureData(4);
        } else {
            System.err.println("OPENGL2: insufficient texture units.");
        }
    }

    public void vertex(float x, float y, float[] u, float[] v) {
        int len = PApplet.min((int)u.length, (int)v.length);
        if (len <= maxTextureUnits) {
            int t = 0;
            while (t < len) {
                this.vertexTexture(u[t], v[t], t);
                ++t;
            }
            this.vertex(x, y);
            this.setMultitextureData(len);
        } else {
            System.err.println("OPENGL2: insufficient texture units.");
        }
    }

    public void vertex(float x, float y, float z, float u, float v) {
        this.vertexTexture(u, v, 0);
        this.vertex(x, y, z);
        int n = this.vertexCount - 1;
        int i = 0;
        while (i < this.numMultitextures) {
            this.vertexTex[n][i] = this.multitextureImages[i];
            this.vertexU[n][i] = this.multitextureU[0];
            this.vertexV[n][i] = this.multitextureV[0];
            ++i;
        }
    }

    public void vertex(float x, float y, float z, float u0, float v0, float u1, float v1) {
        if (2 <= maxTextureUnits) {
            this.vertexTexture(u0, v0, 0);
            this.vertexTexture(u1, v1, 1);
            this.vertex(x, y, z);
            this.setMultitextureData(2);
        } else {
            System.err.println("OPENGL2: insufficient texture units.");
        }
    }

    public void vertex(float x, float y, float z, float u0, float v0, float u1, float v1, float u2, float v2) {
        if (3 <= maxTextureUnits) {
            this.vertexTexture(u0, v0, 0);
            this.vertexTexture(u1, v1, 1);
            this.vertexTexture(u2, v2, 2);
            this.vertex(x, y, z);
            this.setMultitextureData(3);
        } else {
            System.err.println("OPENGL2: insufficient texture units.");
        }
    }

    public void vertex(float x, float y, float z, float u0, float v0, float u1, float v1, float u2, float v2, float u3, float v3) {
        if (4 <= maxTextureUnits) {
            this.vertexTexture(u0, v0, 0);
            this.vertexTexture(u1, v1, 1);
            this.vertexTexture(u2, v2, 2);
            this.vertexTexture(u2, v2, 3);
            this.vertex(x, y, z);
            this.setMultitextureData(4);
        } else {
            System.err.println("OPENGL2: insufficient texture units.");
        }
    }

    public void vertex(float x, float y, float z, float[] u, float[] v) {
        int len = PApplet.min((int)u.length, (int)v.length);
        if (len <= maxTextureUnits) {
            int t = 0;
            while (t < len) {
                this.vertexTexture(u[t], v[t], t);
                ++t;
            }
            this.vertex(x, y, z);
            this.setMultitextureData(len);
        } else {
            System.err.println("OPENGL2: insufficient texture units.");
        }
    }

    protected void vertexCheck() {
        super.vertexCheck();
        if (this.vertexCount == this.vertexTex.length) {
            float[][] tempu = new float[this.vertexCount << 1][this.numTexBuffers];
            float[][] tempv = new float[this.vertexCount << 1][this.numTexBuffers];
            PImage[][] tempi = new PImage[this.vertexCount << 1][this.numTexBuffers];
            int i = 0;
            while (i < this.vertexCount) {
                PApplet.arrayCopy((Object)this.vertexU[i], (int)0, (Object)tempu[i], (int)0, (int)this.numTexBuffers);
                PApplet.arrayCopy((Object)this.vertexV[i], (int)0, (Object)tempv[i], (int)0, (int)this.numTexBuffers);
                PApplet.arrayCopy((Object)this.vertexTex[i], (int)0, (Object)tempi[i], (int)0, (int)this.numTexBuffers);
                ++i;
            }
            this.vertexU = tempu;
            this.vertexV = tempv;
            this.vertexTex = tempi;
        }
    }

    protected void clearMultitextures() {
        Arrays.fill(this.multitextureImages, null);
    }

    protected void clearMultitextures0() {
        Arrays.fill(this.multitextureImages0, null);
    }

    protected boolean diffFromMultitextures0(PImage[] images) {
        if (1 < this.numMultitextures) {
            int i = 0;
            while (i < this.numMultitextures) {
                if (this.multitextureImages0[i] != images[i]) {
                    return true;
                }
                ++i;
            }
            return false;
        }
        if (this.numMultitextures > 0) {
            return this.multitextureImages0[0] != images[0];
        }
        return this.multitextureImages0[0] != null;
    }

    protected void setMultitextures0(PImage[] images) {
        if (1 < this.numMultitextures) {
            PApplet.arrayCopy((Object)images, (int)0, (Object)this.multitextureImages0, (int)0, (int)this.numMultitextures);
        } else {
            this.multitextureImages0[0] = this.numMultitextures > 0 ? images[0] : null;
        }
    }

    protected void vertexTexture(float u, float v, int t) {
        if (t == 0) {
            super.vertexTexture(u, v);
            this.multitextureU[0] = this.textureU;
            this.multitextureV[0] = this.textureV;
        } else {
            PImage img = this.multitextureImages[t];
            if (img == null) {
                throw new RuntimeException("You must first call texture() before using u and v coordinates with vertex()");
            }
            if (this.textureMode == 2) {
                u /= (float)img.width;
                v /= (float)img.height;
            }
            this.multitextureU[t] = u;
            this.multitextureV[t] = v;
        }
    }

    protected void addTexBuffers(int more) {
        int size = this.texCoordBuffer[this.numTexBuffers - 1].capacity();
        int i = 0;
        while (i < more) {
            ByteBuffer tbb = ByteBuffer.allocateDirect(size * 4);
            tbb.order(ByteOrder.nativeOrder());
            this.texCoordBuffer[this.numTexBuffers + i] = tbb.asFloatBuffer();
            ++i;
        }
        this.texCoordArray = new float[this.numTexBuffers + more][size];
        size = this.vertexTex.length;
        float[][] tempu = new float[size][this.numTexBuffers + more];
        float[][] tempv = new float[size][this.numTexBuffers + more];
        PImage[][] tempi = new PImage[size][this.numTexBuffers + more];
        int i2 = 0;
        while (i2 < size) {
            PApplet.arrayCopy((Object)this.vertexU[i2], (int)0, (Object)tempu[i2], (int)0, (int)this.numTexBuffers);
            PApplet.arrayCopy((Object)this.vertexV[i2], (int)0, (Object)tempv[i2], (int)0, (int)this.numTexBuffers);
            PApplet.arrayCopy((Object)this.vertexTex[i2], (int)0, (Object)tempi[i2], (int)0, (int)this.numTexBuffers);
            ++i2;
        }
        this.vertexU = tempu;
        this.vertexV = tempv;
        this.vertexTex = tempi;
        this.numTexBuffers += more;
    }

    protected void setMultitextureData(int ntex) {
        if (this.numTexBuffers < ntex) {
            this.addTexBuffers(ntex - this.numTexBuffers);
        }
        int n = this.vertexCount - 1;
        PApplet.arrayCopy((Object)this.multitextureU, (int)0, (Object)this.vertexU[n], (int)0, (int)ntex);
        PApplet.arrayCopy((Object)this.multitextureV, (int)0, (Object)this.vertexV[n], (int)0, (int)ntex);
        PApplet.arrayCopy((Object)this.multitextureImages, (int)0, (Object)this.vertexTex[n], (int)0, (int)ntex);
    }

    public void endShape(int mode) {
        this.shapeLast = this.vertexCount;
        if (this.vertexCount == 0) {
            this.shape = 0;
            return;
        }
        if (this.stroke) {
            this.endShapeStroke(mode);
        }
        if (this.fill) {
            this.endShapeFill();
        }
        if (!this.hints[5]) {
            if (this.fill) {
                this.renderTriangles(0, this.faceCount);
                this.faceCount = 0;
                this.vertexCount = 0;
                this.triangleCount = 0;
            }
            if (this.stroke) {
                this.renderLines(0, this.pathCount);
                this.lineCount = 0;
            }
            this.pathCount = 0;
            this.faceCount = 0;
        }
        this.shape = 0;
    }

    protected void endShapeStroke(int mode) {
        switch (this.shape) {
            case 2: {
                int stop = this.shapeLast;
                int i = this.shapeFirst;
                while (i < stop) {
                    this.addLineBreak();
                    this.addLine(i, i);
                    ++i;
                }
                break;
            }
            case 4: {
                int first = this.lineCount;
                int stop = this.shapeLast - 1;
                if (this.shape != 4) {
                    this.addLineBreak();
                }
                int i = this.shapeFirst;
                while (i < stop) {
                    if (this.shape == 4) {
                        this.addLineBreak();
                    }
                    this.addLine(i, i + 1);
                    i += 2;
                }
                if (mode != 2) break;
                this.addLine(stop, this.lines[first][0]);
                break;
            }
            case 9: {
                int i = this.shapeFirst;
                while (i < this.shapeLast - 2) {
                    this.addLineBreak();
                    this.addLine(i + 0, i + 1);
                    this.addLine(i + 1, i + 2);
                    this.addLine(i + 2, i + 0);
                    i += 3;
                }
                break;
            }
            case 10: {
                int stop = this.shapeLast - 1;
                this.addLineBreak();
                int i = this.shapeFirst;
                while (i < stop) {
                    this.addLine(i, i + 1);
                    ++i;
                }
                stop = this.shapeLast - 2;
                i = this.shapeFirst;
                while (i < stop) {
                    this.addLineBreak();
                    this.addLine(i, i + 2);
                    ++i;
                }
                break;
            }
            case 11: {
                int i = this.shapeFirst + 1;
                while (i < this.shapeLast) {
                    this.addLineBreak();
                    this.addLine(this.shapeFirst, i);
                    ++i;
                }
                this.addLineBreak();
                i = this.shapeFirst + 1;
                while (i < this.shapeLast - 1) {
                    this.addLine(i, i + 1);
                    ++i;
                }
                this.addLine(this.shapeLast - 1, this.shapeFirst + 1);
                break;
            }
            case 16: {
                int i = this.shapeFirst;
                while (i < this.shapeLast) {
                    this.addLineBreak();
                    this.addLine(i + 0, i + 1);
                    this.addLine(i + 1, i + 2);
                    this.addLine(i + 2, i + 3);
                    this.addLine(i + 3, i + 0);
                    i += 4;
                }
                break;
            }
            case 17: {
                int i = this.shapeFirst;
                while (i < this.shapeLast - 3) {
                    this.addLineBreak();
                    this.addLine(i + 0, i + 2);
                    this.addLine(i + 2, i + 3);
                    this.addLine(i + 3, i + 1);
                    this.addLine(i + 1, i + 0);
                    i += 2;
                }
                break;
            }
            case 20: {
                int stop = this.shapeLast - 1;
                this.addLineBreak();
                int i = this.shapeFirst;
                while (i < stop) {
                    this.addLine(i, i + 1);
                    ++i;
                }
                if (mode != 2) break;
                this.addLine(stop, this.shapeFirst);
            }
        }
    }

    protected void endShapeFill() {
        switch (this.shape) {
            case 11: {
                int stop = this.shapeLast - 1;
                int i = this.shapeFirst + 1;
                while (i < stop) {
                    this.addTriangle(this.shapeFirst, i, i + 1);
                    ++i;
                }
                break;
            }
            case 9: {
                int stop = this.shapeLast - 2;
                int i = this.shapeFirst;
                while (i < stop) {
                    if (i % 2 == 0) {
                        this.addTriangle(i, i + 2, i + 1);
                    } else {
                        this.addTriangle(i, i + 1, i + 2);
                    }
                    i += 3;
                }
                break;
            }
            case 10: {
                int stop = this.shapeLast - 2;
                int i = this.shapeFirst;
                while (i < stop) {
                    if (i % 2 == 0) {
                        this.addTriangle(i, i + 2, i + 1);
                    } else {
                        this.addTriangle(i, i + 1, i + 2);
                    }
                    ++i;
                }
                break;
            }
            case 16: {
                int stop = this.vertexCount - 3;
                int i = this.shapeFirst;
                while (i < stop) {
                    this.addTriangle(i, i + 1, i + 2);
                    this.addTriangle(i, i + 2, i + 3);
                    i += 4;
                }
                break;
            }
            case 17: {
                int stop = this.vertexCount - 3;
                int i = this.shapeFirst;
                while (i < stop) {
                    this.addTriangle(i + 0, i + 2, i + 1);
                    this.addTriangle(i + 2, i + 3, i + 1);
                    i += 2;
                }
                break;
            }
            case 20: {
                this.addPolygonTriangles();
            }
        }
    }

    public void endRecord() {
        if (this.recordingShape) {
            if (this.recordedVertices.size() > 0) {
                this.recordedShape.initShape(this.recordedVertices.size());
            }
            this.endShapeRecorderImpl(this.recordedShape);
            this.recordedShape = null;
        } else {
            System.err.println("OPENGL2: Start recording with beginRecord().");
        }
    }

    protected PShape3D endShapeRecorder() {
        return this.endShapeRecorder(1);
    }

    protected PShape3D endShapeRecorder(int mode) {
        this.endShape(mode);
        PShape3D shape = null;
        if (this.recordedVertices.size() > 0) {
            shape = new PShape3D(this.parent, this.recordedVertices.size());
        }
        this.endShapeRecorderImpl(shape);
        return shape;
    }

    protected PShape3D endShapesRecorder() {
        if (this.recordingShape) {
            PShape3D shape = null;
            if (this.recordedVertices.size() > 0) {
                shape = new PShape3D(this.parent, this.recordedVertices.size());
            }
            this.endShapeRecorderImpl(shape);
            return shape;
        }
        System.err.println("OPENGL2: Start recording with beginShapesRecorder().");
        return null;
    }

    protected void endShapeRecorderImpl(PShape3D shape) {
        this.recordingShape = false;
        if (this.recordedVertices.size() > 0 && shape != null) {
            shape.setVertices(this.recordedVertices);
            shape.setColors(this.recordedColors);
            shape.setNormals(this.recordedNormals);
            shape.optimizeChildren(this.recordedChildren);
            shape.setChildren(this.recordedChildren);
            int t = 0;
            while (t < this.numRecordedTextures) {
                shape.setTexcoords(t, this.recordedTexCoords[t]);
                ++t;
            }
            this.recordedVertices.clear();
            this.recordedColors.clear();
            this.recordedNormals.clear();
            t = 0;
            while (t < maxTextureUnits) {
                this.recordedTexCoords[t].clear();
                ++t;
            }
            this.recordedChildren.clear();
        }
    }

    public void shape(PShape shape, float x, float y, float z) {
        if (shape.isVisible()) {
            this.pushMatrix();
            if (this.shapeMode == 3) {
                this.translate(x - shape.getWidth() / 2.0f, y - shape.getHeight() / 2.0f, z - shape.getDepth() / 2.0f);
            } else if (this.shapeMode == 0 || this.shapeMode == 1) {
                this.translate(x, y, z);
            }
            shape.draw((PGraphics)this);
            this.popMatrix();
        }
    }

    public void shape(PShape shape, float x, float y, float z, float c, float d, float e) {
        if (shape.isVisible()) {
            this.pushMatrix();
            if (this.shapeMode == 3) {
                this.translate(x - c / 2.0f, y - d / 2.0f, z - e / 2.0f);
                this.scale(c / shape.getWidth(), d / shape.getHeight(), e / shape.getDepth());
            } else if (this.shapeMode == 0) {
                this.translate(x, y, z);
                this.scale(c / shape.getWidth(), d / shape.getHeight(), e / shape.getDepth());
            } else if (this.shapeMode == 1) {
                this.translate(x, y, z);
                this.scale((c -= x) / shape.getWidth(), (d -= y) / shape.getHeight(), (e -= z) / shape.getDepth());
            }
            shape.draw((PGraphics)this);
            this.popMatrix();
        }
    }

    protected void renderPoints(int start, int stop) {
        this.gl2f.glEnableClientState(32884);
        this.gl2f.glEnableClientState(32886);
        int size = 3 * (stop - start);
        while (this.vertexBuffer.capacity() / 3 < size) {
            this.expandBuffers();
        }
        float sw = this.vertices[this.lines[start][0]][17];
        if (sw > 0.0f) {
            this.gl2f.glPointSize(sw);
            this.vertexBuffer.position(0);
            this.colorBuffer.position(0);
            int n = 0;
            int i = start;
            while (i < stop) {
                float[] a = this.vertices[this.points[i][0]];
                this.vertexArray[3 * n + 0] = a[0];
                this.vertexArray[3 * n + 1] = a[1];
                this.vertexArray[3 * n + 2] = a[2];
                this.colorArray[4 * n + 0] = a[13];
                this.colorArray[4 * n + 1] = a[14];
                this.colorArray[4 * n + 2] = a[15];
                this.colorArray[4 * n + 3] = a[16];
                ++n;
                ++i;
            }
            this.vertexBuffer.put(this.vertexArray);
            this.colorBuffer.put(this.colorArray);
            this.vertexBuffer.position(0);
            this.colorBuffer.position(0);
            this.gl2f.glVertexPointer(3, 5126, 0, (Buffer)this.vertexBuffer);
            this.gl2f.glColorPointer(4, 5126, 0, (Buffer)this.colorBuffer);
            this.gl2f.glDrawArrays(0, start, stop - start);
        }
        this.gl2f.glDisableClientState(32884);
        this.gl2f.glDisableClientState(32886);
    }

    protected final void addLineBreak() {
        if (this.pathCount == this.pathOffset.length) {
            this.pathOffset = PApplet.expand((int[])this.pathOffset);
            this.pathLength = PApplet.expand((int[])this.pathLength);
        }
        this.pathOffset[this.pathCount] = this.lineCount;
        this.pathLength[this.pathCount] = 0;
        ++this.pathCount;
    }

    protected void addLine(int a, int b) {
        if (this.lineCount == this.lines.length) {
            int[][] temp = new int[this.lineCount << 1][2];
            PApplet.arrayCopy((Object)this.lines, (int)0, (Object)temp, (int)0, (int)this.lineCount);
            this.lines = temp;
        }
        this.lines[this.lineCount][0] = a;
        this.lines[this.lineCount][1] = b;
        ++this.lineCount;
        int n = this.pathCount - 1;
        this.pathLength[n] = this.pathLength[n] + 1;
    }

    protected void renderLines(int start, int stop) {
        this.report("render_lines in");
        float sw0 = 0.0f;
        this.gl2f.glEnableClientState(32884);
        this.gl2f.glEnableClientState(32886);
        int j = start;
        while (j < stop) {
            int i = this.pathOffset[j];
            float sw = this.vertices[this.lines[i][0]][17];
            if (sw > 0.0f) {
                this.gl2f.glLineWidth(sw);
                if (sw0 != sw && this.recordingShape) {
                    int n0 = this.recordedVertices.size();
                    int n1 = n0 + this.pathLength[j];
                    int k = j + 1;
                    while (k < stop) {
                        int i1 = this.pathOffset[k];
                        float sw1 = this.vertices[this.lines[i1][0]][17];
                        if (sw0 != sw1) break;
                        n1 = n0 + this.pathLength[k];
                        ++k;
                    }
                    String name = "shape";
                    name = this.mergeRecShapes ? "shape" : (this.recShapeName.equals("") ? "shape:" + this.recordedChildren.size() : this.recShapeName);
                    PShape3D child = (PShape3D)PShape3D.createChild(name, n0, n1, 50, sw, null);
                    this.recordedChildren.add(child);
                }
                int size = 3 * (this.pathLength[j] + 1);
                while (this.vertexBuffer.capacity() / 3 < size) {
                    this.expandBuffers();
                }
                this.vertexBuffer.position(0);
                this.colorBuffer.position(0);
                int n = 0;
                float[] a = this.vertices[this.lines[i][0]];
                if (this.recordingShape) {
                    this.recordedVertices.add(new PVector(a[0], a[1], a[2]));
                    this.recordedColors.add(new float[]{a[13], a[14], a[15], a[16]});
                    this.recordedNormals.add(new PVector(0.0f, 0.0f, 0.0f));
                    int t = 0;
                    while (t < maxTextureUnits) {
                        this.recordedTexCoords[t].add(new PVector(0.0f, 0.0f, 0.0f));
                        ++t;
                    }
                } else {
                    this.vertexArray[3 * n + 0] = a[0];
                    this.vertexArray[3 * n + 1] = a[1];
                    this.vertexArray[3 * n + 2] = a[2];
                    this.colorArray[4 * n + 0] = a[13];
                    this.colorArray[4 * n + 1] = a[14];
                    this.colorArray[4 * n + 2] = a[15];
                    this.colorArray[4 * n + 3] = a[16];
                    ++n;
                }
                int k = 0;
                while (k < this.pathLength[j]) {
                    float[] b = this.vertices[this.lines[i][1]];
                    if (this.recordingShape) {
                        this.recordedVertices.add(new PVector(b[0], b[1], b[2]));
                        this.recordedColors.add(new float[]{b[13], b[14], b[15], b[16]});
                        this.recordedNormals.add(new PVector(0.0f, 0.0f, 0.0f));
                        int t = 0;
                        while (t < maxTextureUnits) {
                            this.recordedTexCoords[t].add(new PVector(0.0f, 0.0f, 0.0f));
                            ++t;
                        }
                    } else {
                        this.vertexArray[3 * n + 0] = b[0];
                        this.vertexArray[3 * n + 1] = b[1];
                        this.vertexArray[3 * n + 2] = b[2];
                        this.colorArray[4 * n + 0] = b[13];
                        this.colorArray[4 * n + 1] = b[14];
                        this.colorArray[4 * n + 2] = b[15];
                        this.colorArray[4 * n + 3] = b[16];
                        ++n;
                    }
                    ++i;
                    ++k;
                }
                if (!this.recordingShape) {
                    this.vertexBuffer.put(this.vertexArray);
                    this.colorBuffer.put(this.colorArray);
                    this.vertexBuffer.position(0);
                    this.colorBuffer.position(0);
                    this.gl2f.glVertexPointer(3, 5126, 0, (Buffer)this.vertexBuffer);
                    this.gl2f.glColorPointer(4, 5126, 0, (Buffer)this.colorBuffer);
                    this.gl2f.glDrawArrays(3, 0, this.pathLength[j] + 1);
                }
            }
            sw0 = sw;
            ++j;
        }
        this.gl2f.glDisableClientState(32884);
        this.gl2f.glDisableClientState(32886);
        this.report("render_lines out");
    }

    protected void addTriangle(int a, int b, int c) {
        boolean firstFace;
        if (this.triangleCount == this.triangles.length) {
            int[][] temp = new int[this.triangleCount << 1][3];
            PApplet.arrayCopy((Object)this.triangles, (int)0, (Object)temp, (int)0, (int)this.triangleCount);
            this.triangles = temp;
        }
        this.triangles[this.triangleCount][0] = a;
        this.triangles[this.triangleCount][1] = b;
        this.triangles[this.triangleCount][2] = c;
        PImage[] images = this.vertexTex[a];
        boolean bl = firstFace = this.triangleCount == 0;
        if (this.diffFromMultitextures0(images) || firstFace) {
            this.addNewFace(firstFace, images);
        } else {
            int n = this.faceCount - 1;
            this.faceLength[n] = this.faceLength[n] + 1;
        }
        ++this.triangleCount;
        this.setMultitextures0(images);
    }

    protected void addNewFace(boolean firstFace, PImage[] images) {
        if (this.faceCount == this.faceOffset.length) {
            this.faceOffset = PApplet.expand((int[])this.faceOffset);
            this.faceLength = PApplet.expand((int[])this.faceLength);
            PImage[][] tempi = new PImage[this.faceCount << 1][2];
            PApplet.arrayCopy((Object)this.faceTextures, (int)0, (Object)tempi, (int)0, (int)this.faceCount);
            this.faceTextures = tempi;
        }
        this.faceOffset[this.faceCount] = firstFace ? 0 : this.triangleCount;
        this.faceLength[this.faceCount] = 1;
        Object[] p = this.faceTextures[this.faceCount];
        if (1 < this.numMultitextures) {
            PApplet.arrayCopy((Object)images, (int)0, (Object)p, (int)0, (int)this.numMultitextures);
        }
        p[0] = this.numMultitextures > 0 ? images[0] : null;
        Arrays.fill(p, this.numMultitextures, maxTextureUnits, null);
        ++this.faceCount;
    }

    protected void renderTriangles(int start, int stop) {
        this.report("render_triangles in");
        int numTextures = 0;
        this.gl2f.glEnableClientState(32884);
        this.gl2f.glEnableClientState(32886);
        this.gl2f.glEnableClientState(32885);
        int j = start;
        while (j < stop) {
            int t;
            PTexture tex;
            int i = this.faceOffset[j];
            PImage[] images = this.faceTextures[j];
            if (1 < this.numMultitextures) {
                int t2 = 0;
                while (t2 < this.numMultitextures) {
                    PTexture tex2;
                    if (images[t2] != null && (tex2 = this.getTexture(images[t2])) != null) {
                        this.gl.glEnable(tex2.getGLTarget());
                        this.gl.glActiveTexture(33984 + t2);
                        this.gl.glBindTexture(tex2.getGLTarget(), tex2.getGLID());
                        this.renderTextures[numTextures] = tex2;
                        ++numTextures;
                        ++t2;
                        continue;
                    }
                    break;
                }
            } else if (images[0] != null && (tex = this.getTexture(images[0])) != null) {
                this.gl.glEnable(tex.getGLTarget());
                this.gl.glActiveTexture(33984);
                this.gl.glBindTexture(tex.getGLTarget(), tex.getGLID());
                this.renderTextures[0] = tex;
                numTextures = 1;
            }
            if (numTextures > 0) {
                if (this.numTexBuffers < numTextures) {
                    this.addTexBuffers(numTextures - this.numTexBuffers);
                }
                this.gl2f.glEnableClientState(32888);
                if (1 < numTextures) {
                    this.setMultitextureBlend(this.renderTextures, numTextures);
                }
            }
            if (this.recordingShape) {
                this.numRecordedTextures = PApplet.max((int)this.numRecordedTextures, (int)numTextures);
                int n0 = this.recordedVertices.size();
                int n1 = n0 + 3 * this.faceLength[j] - 1;
                String name = "shape";
                name = this.mergeRecShapes ? "shape" : (this.recShapeName.equals("") ? "shape:" + this.recordedChildren.size() : this.recShapeName);
                PShape3D child = (PShape3D)PShape3D.createChild(name, n0, n1, 9, 0.0f, images);
                this.recordedChildren.add(child);
            }
            int size = 3 * this.faceLength[j];
            while (this.vertexBuffer.capacity() / 3 < size) {
                this.expandBuffers();
            }
            this.vertexBuffer.position(0);
            this.colorBuffer.position(0);
            this.normalBuffer.position(0);
            int t3 = 0;
            while (t3 < numTextures) {
                this.texCoordBuffer[t3].position(0);
                ++t3;
            }
            int n = 0;
            int k = 0;
            while (k < this.faceLength[j]) {
                int t4;
                int na = this.triangles[i][0];
                int nb = this.triangles[i][1];
                int nc = this.triangles[i][2];
                float[] a = this.vertices[na];
                float[] b = this.vertices[nb];
                float[] c = this.vertices[nc];
                if (this.autoNormal && (a[36] == 0.0f || b[36] == 0.0f || c[36] == 0.0f)) {
                    float x1 = b[0] - a[0];
                    float y1 = b[1] - a[1];
                    float z1 = b[2] - a[2];
                    float x2 = b[0] - c[0];
                    float y2 = b[1] - c[1];
                    float z2 = b[2] - c[2];
                    float cx = y1 * z2 - y2 * z1;
                    float cy = z1 * x2 - z2 * x1;
                    float cz = x1 * y2 - x2 * y1;
                    float norm = PApplet.sqrt((float)(cx * cx + cy * cy + cz * cz));
                    b[9] = c[9] = (cx /= norm);
                    a[9] = c[9];
                    b[10] = c[10] = (cy /= norm);
                    a[10] = c[10];
                    b[11] = c[11] = (cz /= norm);
                    a[11] = c[11];
                    c[36] = 1.0f;
                    b[36] = 1.0f;
                    a[36] = 1.0f;
                }
                if (numTextures == 1) {
                    float uscale = 1.0f;
                    float vscale = 1.0f;
                    float cx = 0.0f;
                    float sx = 1.0f;
                    float cy = 0.0f;
                    float sy = 1.0f;
                    PTexture tex3 = this.renderTextures[0];
                    uscale *= tex3.getMaxTexCoordU();
                    vscale *= tex3.getMaxTexCoordV();
                    if (tex3.isFlippedX()) {
                        cx = 1.0f;
                        sx = -1.0f;
                    }
                    if (tex3.isFlippedY()) {
                        cy = 1.0f;
                        sy = -1.0f;
                    }
                    this.renderUa[0] = (cx + sx * a[7]) * uscale;
                    this.renderVa[0] = (cy + sy * a[8]) * vscale;
                    this.renderUb[0] = (cx + sx * b[7]) * uscale;
                    this.renderVb[0] = (cy + sy * b[8]) * vscale;
                    this.renderUc[0] = (cx + sx * c[7]) * uscale;
                    this.renderVc[0] = (cy + sy * c[8]) * vscale;
                } else if (1 < numTextures) {
                    int t5 = 0;
                    while (t5 < numTextures) {
                        float uscale = 1.0f;
                        float vscale = 1.0f;
                        float cx = 0.0f;
                        float sx = 1.0f;
                        float cy = 0.0f;
                        float sy = 1.0f;
                        PTexture tex4 = this.renderTextures[t5];
                        uscale *= tex4.getMaxTexCoordU();
                        vscale *= tex4.getMaxTexCoordV();
                        if (tex4.isFlippedX()) {
                            cx = 1.0f;
                            sx = -1.0f;
                        }
                        if (tex4.isFlippedY()) {
                            cy = 1.0f;
                            sy = -1.0f;
                        }
                        this.renderUa[t5] = (cx + sx * this.vertexU[na][t5]) * uscale;
                        this.renderVa[t5] = (cy + sy * this.vertexV[na][t5]) * vscale;
                        this.renderUb[t5] = (cx + sx * this.vertexU[nb][t5]) * uscale;
                        this.renderVb[t5] = (cy + sy * this.vertexV[nb][t5]) * vscale;
                        this.renderUc[t5] = (cx + sx * this.vertexU[nc][t5]) * uscale;
                        this.renderVc[t5] = (cy + sy * this.vertexV[nc][t5]) * vscale;
                        ++t5;
                    }
                }
                if (this.recordingShape) {
                    this.recordedVertices.add(new PVector(a[0], a[1], a[2]));
                    this.recordedColors.add(new float[]{a[3], a[4], a[5], a[6]});
                    this.recordedNormals.add(new PVector(a[9], a[10], a[11]));
                    t4 = 0;
                    while (t4 < numTextures) {
                        this.recordedTexCoords[t4].add(new PVector(this.vertexU[na][t4], this.vertexV[na][t4], 0.0f));
                        ++t4;
                    }
                    t4 = numTextures;
                    while (t4 < maxTextureUnits) {
                        this.recordedTexCoords[t4].add(new PVector(0.0f, 0.0f, 0.0f));
                        ++t4;
                    }
                } else {
                    this.vertexArray[3 * n + 0] = a[0];
                    this.vertexArray[3 * n + 1] = a[1];
                    this.vertexArray[3 * n + 2] = a[2];
                    this.colorArray[4 * n + 0] = a[3];
                    this.colorArray[4 * n + 1] = a[4];
                    this.colorArray[4 * n + 2] = a[5];
                    this.colorArray[4 * n + 3] = a[6];
                    this.normalArray[3 * n + 0] = a[9];
                    this.normalArray[3 * n + 1] = a[10];
                    this.normalArray[3 * n + 2] = a[11];
                    t4 = 0;
                    while (t4 < numTextures) {
                        this.texCoordArray[t4][2 * n + 0] = this.renderUa[t4];
                        this.texCoordArray[t4][2 * n + 1] = this.renderVa[t4];
                        ++t4;
                    }
                    ++n;
                }
                if (this.recordingShape) {
                    this.recordedVertices.add(new PVector(b[0], b[1], b[2]));
                    this.recordedColors.add(new float[]{b[3], b[4], b[5], b[6]});
                    this.recordedNormals.add(new PVector(b[9], b[10], b[11]));
                    t4 = 0;
                    while (t4 < numTextures) {
                        this.recordedTexCoords[t4].add(new PVector(this.vertexU[nb][t4], this.vertexV[nb][t4], 0.0f));
                        ++t4;
                    }
                    t4 = numTextures;
                    while (t4 < maxTextureUnits) {
                        this.recordedTexCoords[t4].add(new PVector(0.0f, 0.0f, 0.0f));
                        ++t4;
                    }
                } else {
                    this.vertexArray[3 * n + 0] = b[0];
                    this.vertexArray[3 * n + 1] = b[1];
                    this.vertexArray[3 * n + 2] = b[2];
                    this.colorArray[4 * n + 0] = b[3];
                    this.colorArray[4 * n + 1] = b[4];
                    this.colorArray[4 * n + 2] = b[5];
                    this.colorArray[4 * n + 3] = b[6];
                    this.normalArray[3 * n + 0] = b[9];
                    this.normalArray[3 * n + 1] = b[10];
                    this.normalArray[3 * n + 2] = b[11];
                    t4 = 0;
                    while (t4 < numTextures) {
                        this.texCoordArray[t4][2 * n + 0] = this.renderUb[t4];
                        this.texCoordArray[t4][2 * n + 1] = this.renderVb[t4];
                        ++t4;
                    }
                    ++n;
                }
                if (this.recordingShape) {
                    this.recordedVertices.add(new PVector(c[0], c[1], c[2]));
                    this.recordedColors.add(new float[]{c[3], c[4], c[5], c[6]});
                    this.recordedNormals.add(new PVector(c[9], c[10], c[11]));
                    t4 = 0;
                    while (t4 < numTextures) {
                        this.recordedTexCoords[t4].add(new PVector(this.vertexU[nc][t4], this.vertexV[nc][t4], 0.0f));
                        ++t4;
                    }
                    t4 = numTextures;
                    while (t4 < maxTextureUnits) {
                        this.recordedTexCoords[t4].add(new PVector(0.0f, 0.0f, 0.0f));
                        ++t4;
                    }
                } else {
                    this.vertexArray[3 * n + 0] = c[0];
                    this.vertexArray[3 * n + 1] = c[1];
                    this.vertexArray[3 * n + 2] = c[2];
                    this.colorArray[4 * n + 0] = c[3];
                    this.colorArray[4 * n + 1] = c[4];
                    this.colorArray[4 * n + 2] = c[5];
                    this.colorArray[4 * n + 3] = c[6];
                    this.normalArray[3 * n + 0] = c[9];
                    this.normalArray[3 * n + 1] = c[10];
                    this.normalArray[3 * n + 2] = c[11];
                    t4 = 0;
                    while (t4 < numTextures) {
                        this.texCoordArray[t4][2 * n + 0] = this.renderUc[t4];
                        this.texCoordArray[t4][2 * n + 1] = this.renderVc[t4];
                        ++t4;
                    }
                    ++n;
                }
                ++i;
                ++k;
            }
            if (!this.recordingShape) {
                this.vertexBuffer.put(this.vertexArray);
                this.colorBuffer.put(this.colorArray);
                this.normalBuffer.put(this.normalArray);
                t = 0;
                while (t < numTextures) {
                    this.texCoordBuffer[t].put(this.texCoordArray[t]);
                    ++t;
                }
                this.vertexBuffer.position(0);
                this.colorBuffer.position(0);
                this.normalBuffer.position(0);
                t = 0;
                while (t < numTextures) {
                    this.texCoordBuffer[t].position(0);
                    ++t;
                }
                this.gl2f.glVertexPointer(3, 5126, 0, (Buffer)this.vertexBuffer);
                this.gl2f.glColorPointer(4, 5126, 0, (Buffer)this.colorBuffer);
                this.gl2f.glNormalPointer(5126, 0, (Buffer)this.normalBuffer);
                t = 0;
                while (t < numTextures) {
                    this.gl2f.glClientActiveTexture(33984 + t);
                    this.gl2f.glTexCoordPointer(2, 5126, 0, (Buffer)this.texCoordBuffer[t]);
                    ++t;
                }
                this.gl2f.glDrawArrays(4, 0, 3 * this.faceLength[j]);
            }
            if (numTextures > 0) {
                PTexture tex5;
                if (1 < numTextures) {
                    this.clearMultitextureBlend(numTextures);
                }
                t = 0;
                while (t < numTextures) {
                    tex5 = this.renderTextures[t];
                    this.gl.glActiveTexture(33984 + t);
                    this.gl.glBindTexture(tex5.getGLTarget(), 0);
                    ++t;
                }
                t = 0;
                while (t < numTextures) {
                    tex5 = this.renderTextures[t];
                    this.gl.glDisable(tex5.getGLTarget());
                    ++t;
                }
                this.gl2f.glDisableClientState(32888);
            }
            ++j;
        }
        this.gl2f.glDisableClientState(32885);
        this.gl2f.glDisableClientState(32886);
        this.gl2f.glDisableClientState(32884);
        this.report("render_triangles out");
    }

    protected void addPolygonTriangles() {
        int i;
        float[] vlast;
        float[] vfirst;
        if (this.vertexOrder.length != this.vertices.length) {
            int[] temp = new int[this.vertices.length];
            PApplet.arrayCopy((Object)this.vertexOrder, (Object)temp, (int)this.vertexCount);
            this.vertexOrder = temp;
        }
        int d1 = 0;
        int d2 = 1;
        float area = 0.0f;
        int p = this.shapeLast - 1;
        int q = this.shapeFirst;
        while (q < this.shapeLast) {
            area += this.vertices[q][d1] * this.vertices[p][d2] - this.vertices[p][d1] * this.vertices[q][d2];
            p = q++;
        }
        if (area == 0.0f) {
            boolean foundValidX = false;
            boolean foundValidY = false;
            int i2 = this.shapeFirst;
            while (i2 < this.shapeLast) {
                int j = i2;
                while (j < this.shapeLast) {
                    if (this.vertices[i2][0] != this.vertices[j][0]) {
                        foundValidX = true;
                    }
                    if (this.vertices[i2][1] != this.vertices[j][1]) {
                        foundValidY = true;
                    }
                    ++j;
                }
                ++i2;
            }
            if (foundValidX) {
                d2 = 2;
            } else if (foundValidY) {
                d1 = 1;
                d2 = 2;
            } else {
                return;
            }
            int p2 = this.shapeLast - 1;
            int q2 = this.shapeFirst;
            while (q2 < this.shapeLast) {
                area += this.vertices[q2][d1] * this.vertices[p2][d2] - this.vertices[p2][d1] * this.vertices[q2][d2];
                p2 = q2++;
            }
        }
        if (PApplet.abs((float)((vfirst = this.vertices[this.shapeFirst])[0] - (vlast = this.vertices[this.shapeLast - 1])[0])) < 1.0E-4f && PApplet.abs((float)(vfirst[1] - vlast[1])) < 1.0E-4f && PApplet.abs((float)(vfirst[2] - vlast[2])) < 1.0E-4f) {
            --this.shapeLast;
        }
        int j = 0;
        if (area > 0.0f) {
            i = this.shapeFirst;
            while (i < this.shapeLast) {
                j = i - this.shapeFirst;
                this.vertexOrder[j] = i++;
            }
        } else {
            i = this.shapeFirst;
            while (i < this.shapeLast) {
                j = i - this.shapeFirst;
                this.vertexOrder[j] = this.shapeLast - 1 - j;
                ++i;
            }
        }
        int vc = this.shapeLast - this.shapeFirst;
        int count = 2 * vc;
        int m = 0;
        int v = vc - 1;
        while (vc > 2) {
            double Cx;
            double By;
            double Ay;
            double Cy;
            double Ax;
            double Bx;
            int w;
            boolean snip = true;
            if (count-- <= 0) break;
            int u = v;
            if (vc <= u) {
                u = 0;
            }
            if (vc <= (v = u + 1)) {
                v = 0;
            }
            if (vc <= (w = v + 1)) {
                w = 0;
            }
            if ((double)1.0E-4f > ((Bx = (double)(-10.0f * this.vertices[this.vertexOrder[v]][d1])) - (Ax = (double)(-10.0f * this.vertices[this.vertexOrder[u]][d1]))) * ((Cy = (double)(10.0f * this.vertices[this.vertexOrder[w]][d2])) - (Ay = (double)(10.0f * this.vertices[this.vertexOrder[u]][d2]))) - ((By = (double)(10.0f * this.vertices[this.vertexOrder[v]][d2])) - Ay) * ((Cx = (double)(-10.0f * this.vertices[this.vertexOrder[w]][d1])) - Ax)) continue;
            int p3 = 0;
            while (p3 < vc) {
                if (p3 != u && p3 != v && p3 != w) {
                    double Px = -10.0f * this.vertices[this.vertexOrder[p3]][d1];
                    double Py = 10.0f * this.vertices[this.vertexOrder[p3]][d2];
                    double ax = Cx - Bx;
                    double ay = Cy - By;
                    double bx = Ax - Cx;
                    double by = Ay - Cy;
                    double cx = Bx - Ax;
                    double cy = By - Ay;
                    double apx = Px - Ax;
                    double apy = Py - Ay;
                    double bpx = Px - Bx;
                    double bpy = Py - By;
                    double cpx = Px - Cx;
                    double cpy = Py - Cy;
                    double aCROSSbp = ax * bpy - ay * bpx;
                    double cCROSSap = cx * apy - cy * apx;
                    double bCROSScp = bx * cpy - by * cpx;
                    if (aCROSSbp >= 0.0 && bCROSScp >= 0.0 && cCROSSap >= 0.0) {
                        snip = false;
                    }
                }
                ++p3;
            }
            if (!snip) continue;
            this.addTriangle(this.vertexOrder[u], this.vertexOrder[v], this.vertexOrder[w]);
            ++m;
            int s = v;
            int t = v + 1;
            while (t < vc) {
                this.vertexOrder[s] = this.vertexOrder[t];
                ++s;
                ++t;
            }
            count = 2 * --vc;
        }
    }

    protected void expandBuffers() {
        int newSize = this.vertexBuffer.capacity() / 3 << 1;
        ByteBuffer vbb = ByteBuffer.allocateDirect(newSize * 3 * 4);
        vbb.order(ByteOrder.nativeOrder());
        this.vertexBuffer = vbb.asFloatBuffer();
        ByteBuffer cbb = ByteBuffer.allocateDirect(newSize * 4 * 4);
        cbb.order(ByteOrder.nativeOrder());
        this.colorBuffer = cbb.asFloatBuffer();
        ByteBuffer nbb = ByteBuffer.allocateDirect(newSize * 3 * 4);
        nbb.order(ByteOrder.nativeOrder());
        this.normalBuffer = nbb.asFloatBuffer();
        int t = 0;
        while (t < this.numTexBuffers) {
            ByteBuffer tbb = ByteBuffer.allocateDirect(newSize * 2 * 4);
            tbb.order(ByteOrder.nativeOrder());
            this.texCoordBuffer[t] = tbb.asFloatBuffer();
            ++t;
        }
        this.vertexArray = new float[newSize * 3];
        this.colorArray = new float[newSize * 4];
        this.normalArray = new float[newSize * 3];
        t = 0;
        while (t < this.numTexBuffers) {
            this.texCoordArray[t] = new float[newSize * 2];
            ++t;
        }
    }

    protected void ellipseImpl(float x, float y, float w, float h) {
        float val;
        float inc;
        int accuracy;
        float radiusH = w / 2.0f;
        float radiusV = h / 2.0f;
        float centerX = x + radiusH;
        float centerY = y + radiusV;
        float sx1 = this.screenX(x, y);
        float sy1 = this.screenY(x, y);
        float sx2 = this.screenX(x + w, y + h);
        float sy2 = this.screenY(x + w, y + h);
        if (this.fill) {
            accuracy = (int)((float)Math.PI * 2 * PApplet.dist((float)sx1, (float)sy1, (float)sx2, (float)sy2) / 20.0f);
            if (accuracy < 6) {
                accuracy = 6;
            }
            inc = 720.0f / (float)accuracy;
            val = 0.0f;
            boolean strokeSaved = this.stroke;
            this.stroke = false;
            boolean smoothSaved = this.smooth;
            if (this.smooth && this.stroke) {
                this.smooth = false;
            }
            this.beginShape(11);
            this.normal(0.0f, 0.0f, 1.0f);
            this.vertex(centerX, centerY);
            int i = 0;
            while (i < accuracy) {
                this.vertex(centerX + cosLUT[(int)val] * radiusH, centerY + sinLUT[(int)val] * radiusV);
                val = (val + inc) % 720.0f;
                ++i;
            }
            this.vertex(centerX + cosLUT[0] * radiusH, centerY + sinLUT[0] * radiusV);
            this.endShape();
            this.stroke = strokeSaved;
            this.smooth = smoothSaved;
        }
        if (this.stroke) {
            accuracy = (int)((float)Math.PI * 2 * PApplet.dist((float)sx1, (float)sy1, (float)sx2, (float)sy2) / 8.0f);
            if (accuracy < 6) {
                accuracy = 6;
            }
            inc = 720.0f / (float)accuracy;
            val = 0.0f;
            boolean savedFill = this.fill;
            this.fill = false;
            val = 0.0f;
            this.beginShape();
            int i = 0;
            while (i < accuracy) {
                this.vertex(centerX + cosLUT[(int)val] * radiusH, centerY + sinLUT[(int)val] * radiusV);
                val = (val + inc) % 720.0f;
                ++i;
            }
            this.endShape(2);
            this.fill = savedFill;
        }
    }

    public void shape(PShape3D shape) {
        shape.draw(this);
    }

    public void shape(PShape3D shape, float x, float y) {
        this.shape(shape, x, y, 0.0f);
    }

    public void shape(PShape3D shape, float x, float y, float z) {
        this.pushMatrix();
        this.translate(x, y, z);
        shape.draw(this);
        this.popMatrix();
    }

    public void beginText() {
        if (this.textMode == 4) {
            this.textBlockMode = true;
            this.textVertexCount = 0;
        }
    }

    public void endText() {
        if (this.textBlockMode) {
            this.textBlockMode = false;
            if (this.textVertexCount > 0) {
                if (!this.blend || this.blendMode != 1) {
                    this.gl.glEnable(3042);
                    if (blendEqSupported) {
                        this.gl.glBlendEquation(32774);
                    }
                    this.gl.glBlendFunc(770, 771);
                }
                this.textTex.setTexture(this.textBlockTex);
                this.renderTextModel();
                if (this.blend) {
                    this.blend(this.blendMode);
                } else {
                    this.noBlend();
                }
                this.gl.glBindTexture(3553, 0);
                this.gl.glDisable(3553);
            }
        }
    }

    protected void textLineImpl(char[] buffer, int start, int stop, float x, float y) {
        this.gl.glEnable(3553);
        if (!this.blend || this.blendMode != 1) {
            this.gl.glEnable(3042);
            if (blendEqSupported) {
                this.gl.glBlendEquation(32774);
            }
            this.gl.glBlendFunc(770, 771);
        }
        this.textTex = (PFontTexture)this.textFont.getCache((PGraphics)this.pgl);
        if (this.textTex == null) {
            this.textTex = new PFontTexture(this.parent, this.textFont, maxTextureSize, maxTextureSize);
            this.textFont.setCache((PGraphics)this, (PMetadata)this.textTex);
            this.textTex.addAllGlyphsToTexture();
        }
        this.textTex.setFirstTexture();
        this.setFillColor();
        if (this.textMode == 4) {
            if (this.textVertexBuffer == null) {
                this.allocateTextModel();
            }
            this.setDefNormals(0.0f, 0.0f, 1.0f);
            if (!this.textBlockMode) {
                this.textVertexCount = 0;
            }
        }
        super.textLineImpl(buffer, start, stop, x, y);
        if (this.textMode == 4 && this.textVertexCount > 0) {
            if (!this.textBlockMode) {
                this.renderTextModel();
            } else {
                this.textBlockTex = this.textTex.currentTex;
            }
        }
        if (this.blend) {
            this.blend(this.blendMode);
        } else {
            this.noBlend();
        }
        this.gl.glBindTexture(3553, 0);
        this.gl.glDisable(3553);
    }

    protected void textCharImpl(char ch, float x, float y) {
        PFont.Glyph glyph = this.textFont.getGlyph(ch);
        if (glyph != null) {
            PFontTexture.TextureInfo tinfo = this.textTex.getTexInfo(glyph);
            if (tinfo == null) {
                tinfo = this.textTex.addToTexture(glyph);
            }
            if (this.textMode == 4) {
                float high = (float)glyph.height / (float)this.textFont.getSize();
                float bwidth = (float)glyph.width / (float)this.textFont.getSize();
                float lextent = (float)glyph.leftExtent / (float)this.textFont.getSize();
                float textent = (float)glyph.topExtent / (float)this.textFont.getSize();
                float x1 = x + lextent * this.textSize;
                float y1 = y - textent * this.textSize;
                float x2 = x1 + bwidth * this.textSize;
                float y2 = y1 + high * this.textSize;
                this.textCharModelImpl(tinfo, x1, y1, x2, y2);
            } else if (this.textMode == 256) {
                int xx = (int)x + glyph.leftExtent;
                int yy = (int)y - glyph.topExtent;
                int w0 = glyph.width;
                int h0 = glyph.height;
                this.textCharScreenImpl(tinfo, xx, yy, w0, h0);
            }
        }
    }

    protected void textCharModelImpl(PFontTexture.TextureInfo info, float x1, float y1, float x2, float y2) {
        if (this.textTex.currentTex != info.texIndex || this.textBlockMode && this.textBlockTex != info.texIndex) {
            if (this.textVertexCount > 0) {
                this.renderTextModel();
                this.textVertexCount = 0;
            }
            this.textTex.setTexture(info.texIndex);
        }
        if (this.textVertexBuffer.capacity() / 3 < this.textVertexCount + 6) {
            this.expandTextBuffers();
        }
        int n = this.textVertexCount;
        this.textVertexArray[3 * n + 0] = x1;
        this.textVertexArray[3 * n + 1] = y1;
        this.textVertexArray[3 * n + 2] = 0.0f;
        this.textTexCoordArray[2 * n + 0] = info.u0;
        this.textTexCoordArray[2 * n + 1] = info.v0;
        this.textVertexArray[3 * ++n + 0] = x2;
        this.textVertexArray[3 * n + 1] = y2;
        this.textVertexArray[3 * n + 2] = 0.0f;
        this.textTexCoordArray[2 * n + 0] = info.u1;
        this.textTexCoordArray[2 * n + 1] = info.v1;
        this.textVertexArray[3 * ++n + 0] = x1;
        this.textVertexArray[3 * n + 1] = y2;
        this.textVertexArray[3 * n + 2] = 0.0f;
        this.textTexCoordArray[2 * n + 0] = info.u0;
        this.textTexCoordArray[2 * n + 1] = info.v1;
        this.textVertexArray[3 * ++n + 0] = x1;
        this.textVertexArray[3 * n + 1] = y1;
        this.textVertexArray[3 * n + 2] = 0.0f;
        this.textTexCoordArray[2 * n + 0] = info.u0;
        this.textTexCoordArray[2 * n + 1] = info.v0;
        this.textVertexArray[3 * ++n + 0] = x2;
        this.textVertexArray[3 * n + 1] = y1;
        this.textVertexArray[3 * n + 2] = 0.0f;
        this.textTexCoordArray[2 * n + 0] = info.u1;
        this.textTexCoordArray[2 * n + 1] = info.v0;
        this.textVertexArray[3 * ++n + 0] = x2;
        this.textVertexArray[3 * n + 1] = y2;
        this.textVertexArray[3 * n + 2] = 0.0f;
        this.textTexCoordArray[2 * n + 0] = info.u1;
        this.textTexCoordArray[2 * n + 1] = info.v1;
        this.textVertexCount = ++n;
    }

    protected void textCharScreenImpl(PFontTexture.TextureInfo info, int xx, int yy, int w0, int h0) {
        if (this.textTex.currentTex != info.texIndex) {
            this.textTex.setTexture(info.texIndex);
        }
    }

    protected void allocateTextModel() {
        ByteBuffer vbb = ByteBuffer.allocateDirect(6144);
        vbb.order(ByteOrder.nativeOrder());
        this.textVertexBuffer = vbb.asFloatBuffer();
        ByteBuffer tbb = ByteBuffer.allocateDirect(4096);
        tbb.order(ByteOrder.nativeOrder());
        this.textTexCoordBuffer = tbb.asFloatBuffer();
        this.textVertexArray = new float[1536];
        this.textTexCoordArray = new float[1024];
    }

    protected void renderTextModel() {
        this.textVertexBuffer.position(0);
        this.textTexCoordBuffer.position(0);
        this.textVertexBuffer.put(this.textVertexArray);
        this.textTexCoordBuffer.put(this.textTexCoordArray);
        this.gl2f.glEnableClientState(32884);
        this.gl2f.glEnableClientState(32888);
        this.textVertexBuffer.position(0);
        this.textTexCoordBuffer.position(0);
        this.gl2f.glVertexPointer(3, 5126, 0, (Buffer)this.textVertexBuffer);
        this.gl2f.glTexCoordPointer(2, 5126, 0, (Buffer)this.textTexCoordBuffer);
        this.gl2f.glDrawArrays(4, 0, this.textVertexCount);
        this.gl2f.glDisableClientState(32888);
        this.gl2f.glDisableClientState(32884);
    }

    protected void expandTextBuffers() {
        int newSize = this.textVertexBuffer.capacity() / 3 << 1;
        ByteBuffer vbb = ByteBuffer.allocateDirect(newSize * 3 * 4);
        vbb.order(ByteOrder.nativeOrder());
        this.textVertexBuffer = vbb.asFloatBuffer();
        ByteBuffer tbb = ByteBuffer.allocateDirect(newSize * 2 * 4);
        tbb.order(ByteOrder.nativeOrder());
        this.textTexCoordBuffer = tbb.asFloatBuffer();
        this.textVertexArray = new float[newSize * 3];
        this.textTexCoordArray = new float[newSize * 2];
    }

    public void pushMatrix() {
        this.gl2f.glPushMatrix();
        if (usingGLMatrixStack) {
            if (this.projectionMode) {
                projectionStack.push();
            } else {
                modelviewStack.push();
            }
        }
    }

    public void popMatrix() {
        this.gl2f.glPopMatrix();
        if (usingGLMatrixStack) {
            if (this.projectionMode) {
                projectionStack.pop();
                this.projectionUpdated = false;
            } else {
                modelviewStack.pop();
                this.modelviewUpdated = false;
            }
        }
    }

    public void translate(float tx, float ty) {
        this.translate(tx, ty, 0.0f);
    }

    public void translate(float tx, float ty, float tz) {
        this.gl2f.glTranslatef(tx, ty, tz);
        if (usingGLMatrixStack) {
            if (this.projectionMode) {
                projectionStack.translate(tx, ty, tz);
                this.projectionUpdated = false;
            } else {
                modelviewStack.translate(tx, ty, tz);
                this.modelviewUpdated = false;
            }
        }
    }

    public void rotate(float angle) {
        this.rotateZ(angle);
    }

    public void rotateX(float angle) {
        this.rotate(angle, 1.0f, 0.0f, 0.0f);
    }

    public void rotateY(float angle) {
        this.rotate(angle, 0.0f, 1.0f, 0.0f);
    }

    public void rotateZ(float angle) {
        this.rotate(angle, 0.0f, 0.0f, 1.0f);
    }

    public void rotate(float angle, float v0, float v1, float v2) {
        this.gl2f.glRotatef(PApplet.degrees((float)angle), v0, v1, v2);
        if (usingGLMatrixStack) {
            if (this.projectionMode) {
                projectionStack.rotate(angle, v0, v1, v2);
                this.projectionUpdated = false;
            } else {
                modelviewStack.rotate(angle, v0, v1, v2);
                this.modelviewUpdated = false;
            }
        }
    }

    public void scale(float s) {
        this.scale(s, s, s);
    }

    public void scale(float sx, float sy) {
        this.scale(sx, sy, 1.0f);
    }

    public void scale(float x, float y, float z) {
        if (this.manipulatingCamera) {
            this.scalingDuringCamManip = true;
        }
        this.gl2f.glScalef(x, y, z);
        if (usingGLMatrixStack) {
            if (this.projectionMode) {
                projectionStack.scale(x, y, z);
                this.projectionUpdated = false;
            } else {
                modelviewStack.scale(x, y, z);
                this.modelviewUpdated = false;
            }
        }
    }

    public void shearX(float angle) {
        float t = (float)Math.tan(angle);
        this.applyMatrix(1.0f, t, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);
    }

    public void shearY(float angle) {
        float t = (float)Math.tan(angle);
        this.applyMatrix(1.0f, 0.0f, 0.0f, 0.0f, t, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);
    }

    public void resetMatrix() {
        this.gl2f.glLoadIdentity();
    }

    public void applyMatrix(PMatrix2D source) {
        this.applyMatrix(source.m00, source.m01, source.m02, source.m10, source.m11, source.m12);
    }

    public void applyMatrix(float n00, float n01, float n02, float n10, float n11, float n12) {
        this.applyMatrix(n00, n01, n02, 0.0f, n10, n11, n12, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);
    }

    public void applyMatrix(PMatrix3D source) {
        this.applyMatrix(source.m00, source.m01, source.m02, source.m03, source.m10, source.m11, source.m12, source.m13, source.m20, source.m21, source.m22, source.m23, source.m30, source.m31, source.m32, source.m33);
    }

    public void applyMatrix(float n00, float n01, float n02, float n03, float n10, float n11, float n12, float n13, float n20, float n21, float n22, float n23, float n30, float n31, float n32, float n33) {
        this.gltemp[0] = n00;
        this.gltemp[1] = n10;
        this.gltemp[2] = n20;
        this.gltemp[3] = n30;
        this.gltemp[4] = n01;
        this.gltemp[5] = n11;
        this.gltemp[6] = n21;
        this.gltemp[7] = n31;
        this.gltemp[8] = n02;
        this.gltemp[9] = n12;
        this.gltemp[10] = n22;
        this.gltemp[11] = n32;
        this.gltemp[12] = n03;
        this.gltemp[13] = n13;
        this.gltemp[14] = n23;
        this.gltemp[15] = n33;
        this.gl2f.glMultMatrixf(this.gltemp, 0);
        if (usingGLMatrixStack) {
            if (this.projectionMode) {
                projectionStack.mult(this.gltemp);
                this.projectionUpdated = false;
            } else {
                modelviewStack.mult(this.gltemp);
                this.modelviewUpdated = false;
            }
        }
    }

    public void updateModelview() {
        this.updateModelview(true);
    }

    public void updateModelview(boolean calcInv) {
        this.copyPMatrixToGLArray(this.modelview, this.glmodelview);
        if (calcInv) {
            this.calculateModelviewInverse();
        } else {
            this.copyPMatrixToGLArray(this.modelviewInv, this.glmodelviewInv);
        }
        this.gl2f.glLoadMatrixf(this.glmodelview, 0);
        if (usingGLMatrixStack) {
            modelviewStack.set(this.glmodelview);
        }
        this.modelviewUpdated = true;
    }

    public void updateCamera() {
        if (!this.manipulatingCamera) {
            throw new RuntimeException("Cannot call updateCamera() without first calling beginCamera()");
        }
        this.copyPMatrixToGLArray(this.camera, this.glmodelview);
        this.gl2f.glLoadMatrixf(this.glmodelview, 0);
        if (usingGLMatrixStack) {
            modelviewStack.set(this.glmodelview);
        }
        this.scalingDuringCamManip = true;
        this.modelviewUpdated = true;
    }

    protected void copyPMatrixToGLArray(PMatrix3D src, float[] dest) {
        dest[0] = src.m00;
        dest[1] = src.m10;
        dest[2] = src.m20;
        dest[3] = src.m30;
        dest[4] = src.m01;
        dest[5] = src.m11;
        dest[6] = src.m21;
        dest[7] = src.m31;
        dest[8] = src.m02;
        dest[9] = src.m12;
        dest[10] = src.m22;
        dest[11] = src.m32;
        dest[12] = src.m03;
        dest[13] = src.m13;
        dest[14] = src.m23;
        dest[15] = src.m33;
    }

    protected void copyGLArrayToPMatrix(float[] src, PMatrix3D dest) {
        dest.m00 = src[0];
        dest.m10 = src[1];
        dest.m20 = src[2];
        dest.m30 = src[3];
        dest.m01 = src[4];
        dest.m11 = src[5];
        dest.m21 = src[6];
        dest.m31 = src[7];
        dest.m02 = src[8];
        dest.m12 = src[9];
        dest.m22 = src[10];
        dest.m32 = src[11];
        dest.m03 = src[12];
        dest.m13 = src[13];
        dest.m23 = src[14];
        dest.m33 = src[15];
    }

    public PMatrix getMatrix() {
        PMatrix3D res = new PMatrix3D();
        this.copyGLArrayToPMatrix(this.glmodelview, res);
        return res;
    }

    public PMatrix3D getMatrix(PMatrix3D target) {
        if (target == null) {
            target = new PMatrix3D();
        }
        this.copyGLArrayToPMatrix(this.glmodelview, target);
        return target;
    }

    public void setMatrix(PMatrix2D source) {
        this.resetMatrix();
        this.applyMatrix(source);
    }

    public void setMatrix(PMatrix3D source) {
        this.resetMatrix();
        this.applyMatrix(source);
    }

    public void printMatrix() {
        PMatrix3D temp = new PMatrix3D();
        this.copyGLArrayToPMatrix(this.glmodelview, temp);
        temp.print();
    }

    public void beginProjection() {
        this.gl2f.glMatrixMode(5889);
        this.projectionMode = true;
    }

    public void endProjection() {
        this.gl2f.glMatrixMode(5888);
        this.projectionMode = false;
    }

    protected void getProjectionMatrix() {
        if (usingGLMatrixStack) {
            projectionStack.get(this.glprojection);
        } else {
            this.gl2f.glGetFloatv(2983, this.glprojection, 0);
        }
        this.copyGLArrayToPMatrix(this.glprojection, this.projection);
        this.projectionUpdated = true;
    }

    public void updateProjection() {
        this.copyPMatrixToGLArray(this.projection, this.glprojection);
        this.gl2f.glMatrixMode(5889);
        this.gl2f.glLoadMatrixf(this.glprojection, 0);
        if (!this.projectionMode) {
            this.gl2f.glMatrixMode(5888);
        }
        if (usingGLMatrixStack) {
            this.projection.set(this.glmodelview);
        }
        this.projectionUpdated = true;
    }

    public void beginCamera() {
        if (this.manipulatingCamera) {
            throw new RuntimeException("beginCamera() cannot be called again before endCamera()");
        }
        this.manipulatingCamera = true;
        this.scalingDuringCamManip = false;
    }

    public void endCamera() {
        if (!this.manipulatingCamera) {
            throw new RuntimeException("Cannot call endCamera() without first calling beginCamera()");
        }
        this.getModelviewMatrix();
        if (this.scalingDuringCamManip) {
            this.calculateModelviewInverse();
        } else {
            this.calculateModelviewInvNoScaling();
        }
        PApplet.arrayCopy((Object)this.glmodelview, (Object)this.pcamera);
        PApplet.arrayCopy((Object)this.glmodelviewInv, (Object)this.pcameraInv);
        this.copyGLArrayToPMatrix(this.pcamera, this.camera);
        this.copyGLArrayToPMatrix(this.pcameraInv, this.cameraInv);
        this.manipulatingCamera = false;
        this.scalingDuringCamManip = false;
    }

    protected void getModelviewMatrix() {
        if (usingGLMatrixStack) {
            modelviewStack.get(this.glmodelview);
        } else {
            this.gl2f.glGetFloatv(2982, this.glmodelview, 0);
        }
        this.copyGLArrayToPMatrix(this.glmodelview, this.modelview);
        this.modelviewUpdated = true;
    }

    protected void calculateModelviewInverse() {
        float[] m = this.glmodelview;
        float[] inv = this.glmodelviewInv;
        float a0 = m[0] * m[5] - m[1] * m[4];
        float b5 = m[10] * m[15] - m[11] * m[14];
        float a1 = m[0] * m[6] - m[2] * m[4];
        float b4 = m[9] * m[15] - m[11] * m[13];
        float a2 = m[0] * m[7] - m[3] * m[4];
        float b3 = m[9] * m[14] - m[10] * m[13];
        float a3 = m[1] * m[6] - m[2] * m[5];
        float b2 = m[8] * m[15] - m[11] * m[12];
        float a4 = m[1] * m[7] - m[3] * m[5];
        float b1 = m[8] * m[14] - m[10] * m[12];
        float a5 = m[2] * m[7] - m[3] * m[6];
        float b0 = m[8] * m[13] - m[9] * m[12];
        float det = a0 * b5 - a1 * b4 + a2 * b3 + a3 * b2 - a4 * b1 + a5 * b0;
        if (PApplet.abs((float)det) > 0.0f) {
            inv[0] = m[5] * b5 - m[6] * b4 + m[7] * b3;
            inv[4] = -m[4] * b5 + m[6] * b2 - m[7] * b1;
            inv[8] = m[4] * b4 - m[5] * b2 + m[7] * b0;
            inv[12] = -m[4] * b3 + m[5] * b1 - m[6] * b0;
            inv[1] = -m[1] * b5 + m[2] * b4 - m[3] * b3;
            inv[5] = m[0] * b5 - m[2] * b2 + m[3] * b1;
            inv[9] = -m[0] * b4 + m[1] * b2 - m[3] * b0;
            inv[13] = m[0] * b3 - m[1] * b1 + m[2] * b0;
            inv[2] = m[13] * a5 - m[14] * a4 + m[15] * a3;
            inv[6] = -m[12] * a5 + m[14] * a2 - m[15] * a1;
            inv[10] = m[12] * a4 - m[13] * a2 + m[15] * a0;
            inv[14] = -m[12] * a3 + m[13] * a1 - m[14] * a0;
            inv[3] = -m[9] * a5 + m[10] * a4 - m[11] * a3;
            inv[7] = m[8] * a5 - m[10] * a2 + m[11] * a1;
            inv[11] = -m[8] * a4 + m[9] * a2 - m[11] * a0;
            inv[15] = m[8] * a3 - m[9] * a1 + m[10] * a0;
            float invDet = 1.0f / det;
            inv[0] = inv[0] * invDet;
            inv[1] = inv[1] * invDet;
            inv[2] = inv[2] * invDet;
            inv[3] = inv[3] * invDet;
            inv[4] = inv[4] * invDet;
            inv[5] = inv[5] * invDet;
            inv[6] = inv[6] * invDet;
            inv[7] = inv[7] * invDet;
            inv[8] = inv[8] * invDet;
            inv[9] = inv[9] * invDet;
            inv[10] = inv[10] * invDet;
            inv[11] = inv[11] * invDet;
            inv[12] = inv[12] * invDet;
            inv[13] = inv[13] * invDet;
            inv[14] = inv[14] * invDet;
            inv[15] = inv[15] * invDet;
            this.copyGLArrayToPMatrix(inv, this.modelviewInv);
        }
    }

    protected void calculateModelviewInvNoScaling() {
        float[] m = this.glmodelview;
        float[] inv = this.glmodelviewInv;
        float ux = m[0];
        float uy = m[1];
        float uz = m[2];
        float vx = m[4];
        float vy = m[5];
        float vz = m[6];
        float wx = m[8];
        float wy = m[9];
        float wz = m[10];
        float tx = m[12];
        float ty = m[13];
        float tz = m[14];
        inv[0] = ux;
        inv[1] = vx;
        inv[2] = wx;
        inv[3] = 0.0f;
        inv[4] = uy;
        inv[5] = vy;
        inv[6] = wy;
        inv[7] = 0.0f;
        inv[8] = uz;
        inv[9] = vz;
        inv[10] = wz;
        inv[11] = 0.0f;
        inv[12] = -(ux * tx + uy * ty + uz * tz);
        inv[13] = -(vx * tx + vy * ty + vz * tz);
        inv[14] = -(wx * tx + wy * ty + wz * tz);
        inv[15] = 1.0f;
        this.copyGLArrayToPMatrix(inv, this.modelviewInv);
    }

    public void camera() {
        this.camera(this.cameraX, this.cameraY, this.cameraZ, this.cameraX, this.cameraY, 0.0f, 0.0f, 1.0f, 0.0f);
    }

    public void camera(float eyeX, float eyeY, float eyeZ, float centerX, float centerY, float centerZ, float upX, float upY, float upZ) {
        float z0 = eyeX - centerX;
        float z1 = (eyeY = (float)this.height - eyeY) - (centerY = (float)this.height - centerY);
        float z2 = eyeZ - centerZ;
        float mag = PApplet.sqrt((float)(z0 * z0 + z1 * z1 + z2 * z2));
        if (mag != 0.0f) {
            z0 /= mag;
            z1 /= mag;
            z2 /= mag;
        }
        float y0 = upX;
        float y1 = upY;
        float y2 = upZ;
        float x0 = y1 * z2 - y2 * z1;
        float x1 = -y0 * z2 + y2 * z0;
        float x2 = y0 * z1 - y1 * z0;
        y0 = z1 * x2 - z2 * x1;
        y1 = -z0 * x2 + z2 * x0;
        y2 = z0 * x1 - z1 * x0;
        mag = PApplet.sqrt((float)(x0 * x0 + x1 * x1 + x2 * x2));
        if (mag != 0.0f) {
            x0 /= mag;
            x1 /= mag;
            x2 /= mag;
        }
        if ((mag = PApplet.sqrt((float)(y0 * y0 + y1 * y1 + y2 * y2))) != 0.0f) {
            y0 /= mag;
            y1 /= mag;
            y2 /= mag;
        }
        float[] m = this.glmodelview;
        m[0] = x0;
        m[1] = y0;
        m[2] = z0;
        m[3] = 0.0f;
        m[4] = x1;
        m[5] = y1;
        m[6] = z1;
        m[7] = 0.0f;
        m[8] = x2;
        m[9] = y2;
        m[10] = z2;
        m[11] = 0.0f;
        m[12] = 0.0f;
        m[13] = 0.0f;
        m[14] = 0.0f;
        m[15] = 1.0f;
        float tx = -eyeX;
        float ty = -eyeY + (float)this.height;
        float tz = -eyeZ;
        m[12] = m[12] + (tx * m[0] + ty * m[4] + tz * m[8]);
        m[13] = m[13] + (tx * m[1] + ty * m[5] + tz * m[9]);
        m[14] = m[14] + (tx * m[2] + ty * m[6] + tz * m[10]);
        m[15] = m[15] + (tx * m[3] + ty * m[7] + tz * m[11]);
        m[4] = -m[4];
        m[5] = -m[5];
        m[6] = -m[6];
        m[7] = -m[7];
        this.gl2f.glMatrixMode(5888);
        this.gl2f.glLoadMatrixf(this.glmodelview, 0);
        if (usingGLMatrixStack) {
            modelviewStack.set(this.glmodelview);
        }
        this.copyGLArrayToPMatrix(this.glmodelview, this.modelview);
        this.modelviewUpdated = true;
        this.calculateModelviewInvNoScaling();
        PApplet.arrayCopy((Object)this.glmodelview, (Object)this.pcamera);
        PApplet.arrayCopy((Object)this.glmodelviewInv, (Object)this.pcameraInv);
        this.copyGLArrayToPMatrix(this.pcamera, this.camera);
        this.copyGLArrayToPMatrix(this.pcameraInv, this.cameraInv);
    }

    public void printCamera() {
        PMatrix3D temp = new PMatrix3D();
        this.copyGLArrayToPMatrix(this.pcamera, temp);
        temp.print();
    }

    public void ortho() {
        this.ortho(0.0f, this.width, 0.0f, this.height, this.cameraNear, this.cameraFar);
    }

    public void ortho(float left, float right, float bottom, float top) {
        this.ortho(0.0f, this.width, 0.0f, this.height, this.cameraNear, this.cameraFar);
    }

    public void ortho(float left, float right, float bottom, float top, float near, float far) {
        float x = 2.0f / ((right -= (float)(this.width / 2)) - (left -= (float)(this.width / 2)));
        float y = 2.0f / ((top -= (float)(this.height / 2)) - (bottom -= (float)(this.height / 2)));
        float z = -2.0f / (far - near);
        float tx = -(right + left) / (right - left);
        float ty = -(top + bottom) / (top - bottom);
        float tz = -(far + near) / (far - near);
        this.glprojection[0] = x;
        this.glprojection[1] = 0.0f;
        this.glprojection[2] = 0.0f;
        this.glprojection[3] = 0.0f;
        this.glprojection[4] = 0.0f;
        this.glprojection[5] = y;
        this.glprojection[6] = 0.0f;
        this.glprojection[7] = 0.0f;
        this.glprojection[8] = 0.0f;
        this.glprojection[9] = 0.0f;
        this.glprojection[10] = z;
        this.glprojection[11] = 0.0f;
        this.glprojection[12] = tx;
        this.glprojection[13] = ty;
        this.glprojection[14] = tz;
        this.glprojection[15] = 1.0f;
        this.gl2f.glMatrixMode(5889);
        this.gl2f.glLoadMatrixf(this.glprojection, 0);
        this.copyGLArrayToPMatrix(this.glprojection, this.projection);
        this.projectionUpdated = true;
        this.gl2f.glMatrixMode(5888);
    }

    public void perspective() {
        this.perspective(this.cameraFOV, this.cameraAspect, this.cameraNear, this.cameraFar);
    }

    public void perspective(float fov, float aspect, float zNear, float zFar) {
        float ymax = zNear * (float)Math.tan(fov / 2.0f);
        float ymin = -ymax;
        float xmin = ymin * aspect;
        float xmax = ymax * aspect;
        this.frustum(xmin, xmax, ymin, ymax, zNear, zFar);
    }

    public void frustum(float left, float right, float bottom, float top, float znear, float zfar) {
        float temp = 2.0f * znear;
        float temp2 = right - left;
        float temp3 = top - bottom;
        float temp4 = zfar - znear;
        this.glprojection[0] = temp / temp2;
        this.glprojection[1] = 0.0f;
        this.glprojection[2] = 0.0f;
        this.glprojection[3] = 0.0f;
        this.glprojection[4] = 0.0f;
        this.glprojection[5] = temp / temp3;
        this.glprojection[6] = 0.0f;
        this.glprojection[7] = 0.0f;
        this.glprojection[8] = (right + left) / temp2;
        this.glprojection[9] = (top + bottom) / temp3;
        this.glprojection[10] = (-zfar - znear) / temp4;
        this.glprojection[11] = -1.0f;
        this.glprojection[12] = 0.0f;
        this.glprojection[13] = 0.0f;
        this.glprojection[14] = -temp * zfar / temp4;
        this.glprojection[15] = 0.0f;
        this.gl2f.glMatrixMode(5889);
        this.gl2f.glLoadMatrixf(this.glprojection, 0);
        this.copyGLArrayToPMatrix(this.glprojection, this.projection);
        this.projectionUpdated = true;
        this.gl2f.glMatrixMode(5888);
    }

    public void printProjection() {
        PMatrix3D temp = new PMatrix3D();
        this.copyGLArrayToPMatrix(this.glprojection, temp);
        temp.print();
    }

    public float screenX(float x, float y) {
        return this.screenX(x, y, 0.0f);
    }

    public float screenY(float x, float y) {
        return this.screenY(x, y, 0.0f);
    }

    public float screenX(float x, float y, float z) {
        y *= -1.0f;
        if (!this.modelviewUpdated) {
            this.getModelviewMatrix();
        }
        if (!this.projectionUpdated) {
            this.getProjectionMatrix();
        }
        float ax = this.glmodelview[0] * x + this.glmodelview[4] * y + this.glmodelview[8] * z + this.glmodelview[12];
        float ay = this.glmodelview[1] * x + this.glmodelview[5] * y + this.glmodelview[9] * z + this.glmodelview[13];
        float az = this.glmodelview[2] * x + this.glmodelview[6] * y + this.glmodelview[10] * z + this.glmodelview[14];
        float aw = this.glmodelview[3] * x + this.glmodelview[7] * y + this.glmodelview[11] * z + this.glmodelview[15];
        float ox = this.glprojection[0] * ax + this.glprojection[4] * ay + this.glprojection[8] * az + this.glprojection[12] * aw;
        float ow = this.glprojection[3] * ax + this.glprojection[7] * ay + this.glprojection[11] * az + this.glprojection[15] * aw;
        if (ow != 0.0f) {
            ox /= ow;
        }
        return (float)this.width * (1.0f + ox) / 2.0f;
    }

    public float screenY(float x, float y, float z) {
        y *= -1.0f;
        if (!this.modelviewUpdated) {
            this.getModelviewMatrix();
        }
        if (!this.projectionUpdated) {
            this.getProjectionMatrix();
        }
        float ax = this.glmodelview[0] * x + this.glmodelview[4] * y + this.glmodelview[8] * z + this.glmodelview[12];
        float ay = this.glmodelview[1] * x + this.glmodelview[5] * y + this.glmodelview[9] * z + this.glmodelview[13];
        float az = this.glmodelview[2] * x + this.glmodelview[6] * y + this.glmodelview[10] * z + this.glmodelview[14];
        float aw = this.glmodelview[3] * x + this.glmodelview[7] * y + this.glmodelview[11] * z + this.glmodelview[15];
        float oy = this.glprojection[1] * ax + this.glprojection[5] * ay + this.glprojection[9] * az + this.glprojection[13] * aw;
        float ow = this.glprojection[3] * ax + this.glprojection[7] * ay + this.glprojection[11] * az + this.glprojection[15] * aw;
        if (ow != 0.0f) {
            oy /= ow;
        }
        return (float)this.height * (1.0f + oy) / 2.0f;
    }

    public float screenZ(float x, float y, float z) {
        y *= -1.0f;
        if (!this.modelviewUpdated) {
            this.getModelviewMatrix();
        }
        if (!this.projectionUpdated) {
            this.getProjectionMatrix();
        }
        float ax = this.glmodelview[0] * x + this.glmodelview[4] * y + this.glmodelview[8] * z + this.glmodelview[12];
        float ay = this.glmodelview[1] * x + this.glmodelview[5] * y + this.glmodelview[9] * z + this.glmodelview[13];
        float az = this.glmodelview[2] * x + this.glmodelview[6] * y + this.glmodelview[10] * z + this.glmodelview[14];
        float aw = this.glmodelview[3] * x + this.glmodelview[7] * y + this.glmodelview[11] * z + this.glmodelview[15];
        float oz = this.glprojection[2] * ax + this.glprojection[6] * ay + this.glprojection[10] * az + this.glprojection[14] * aw;
        float ow = this.glprojection[3] * ax + this.glprojection[7] * ay + this.glprojection[11] * az + this.glprojection[15] * aw;
        if (ow != 0.0f) {
            oz /= ow;
        }
        return (oz + 1.0f) / 2.0f;
    }

    public float modelX(float x, float y, float z) {
        if (!this.modelviewUpdated) {
            this.getModelviewMatrix();
        }
        float ax = this.glmodelview[0] * x + this.glmodelview[4] * y + this.glmodelview[8] * z + this.glmodelview[12];
        float ay = this.glmodelview[1] * x + this.glmodelview[5] * y + this.glmodelview[9] * z + this.glmodelview[13];
        float az = this.glmodelview[2] * x + this.glmodelview[6] * y + this.glmodelview[10] * z + this.glmodelview[14];
        float aw = this.glmodelview[3] * x + this.glmodelview[7] * y + this.glmodelview[11] * z + this.glmodelview[15];
        float ox = this.pcameraInv[0] * ax + this.pcameraInv[4] * ay + this.pcameraInv[8] * az + this.pcameraInv[12] * aw;
        float ow = this.pcameraInv[3] * ax + this.pcameraInv[7] * ay + this.pcameraInv[11] * az + this.pcameraInv[15] * aw;
        return ow != 0.0f ? ox / ow : ox;
    }

    public float modelY(float x, float y, float z) {
        if (!this.modelviewUpdated) {
            this.getModelviewMatrix();
        }
        float ax = this.glmodelview[0] * x + this.glmodelview[4] * y + this.glmodelview[8] * z + this.glmodelview[12];
        float ay = this.glmodelview[1] * x + this.glmodelview[5] * y + this.glmodelview[9] * z + this.glmodelview[13];
        float az = this.glmodelview[2] * x + this.glmodelview[6] * y + this.glmodelview[10] * z + this.glmodelview[14];
        float aw = this.glmodelview[3] * x + this.glmodelview[7] * y + this.glmodelview[11] * z + this.glmodelview[15];
        float oy = this.pcameraInv[1] * ax + this.pcameraInv[5] * ay + this.pcameraInv[9] * az + this.pcameraInv[13] * aw;
        float ow = this.pcameraInv[3] * ax + this.pcameraInv[7] * ay + this.pcameraInv[11] * az + this.pcameraInv[15] * aw;
        return ow != 0.0f ? oy / ow : oy;
    }

    public float modelZ(float x, float y, float z) {
        if (!this.modelviewUpdated) {
            this.getModelviewMatrix();
        }
        float ax = this.glmodelview[0] * x + this.glmodelview[4] * y + this.glmodelview[8] * z + this.glmodelview[12];
        float ay = this.glmodelview[1] * x + this.glmodelview[5] * y + this.glmodelview[9] * z + this.glmodelview[13];
        float az = this.glmodelview[2] * x + this.glmodelview[6] * y + this.glmodelview[10] * z + this.glmodelview[14];
        float aw = this.glmodelview[3] * x + this.glmodelview[7] * y + this.glmodelview[11] * z + this.glmodelview[15];
        float oz = this.pcameraInv[2] * ax + this.pcameraInv[6] * ay + this.pcameraInv[10] * az + this.pcameraInv[14] * aw;
        float ow = this.pcameraInv[3] * ax + this.pcameraInv[7] * ay + this.pcameraInv[11] * az + this.pcameraInv[15] * aw;
        return ow != 0.0f ? oz / ow : oz;
    }

    public void strokeWeight(float weight) {
        this.strokeWeight = weight;
    }

    public void strokeJoin(int join) {
        if (join != 8) {
            PGraphicsOpenGL2.showMethodWarning((String)"strokeJoin");
        }
    }

    public void strokeCap(int cap) {
        if (cap != 2) {
            PGraphicsOpenGL2.showMethodWarning((String)"strokeCap");
        }
    }

    protected void fillFromCalc() {
        super.fillFromCalc();
        this.calcColorBuffer();
    }

    protected void setFillColor() {
        this.gl2f.glColor4f(this.fillR, this.fillG, this.fillB, this.fillA);
    }

    protected void setTintColor() {
        this.gl2f.glColor4f(this.tintR, this.tintG, this.tintB, this.tintA);
    }

    protected void ambientFromCalc() {
        super.ambientFromCalc();
        this.calcColorBuffer();
        this.gl2f.glMaterialfv(1032, 4608, this.colorFloats, 0);
    }

    protected void specularFromCalc() {
        super.specularFromCalc();
        this.calcColorBuffer();
        this.gl2f.glMaterialfv(1032, 4610, this.colorFloats, 0);
    }

    public void shininess(float shine) {
        super.shininess(shine);
        this.gl2f.glMaterialf(1032, 5633, shine);
    }

    protected void emissiveFromCalc() {
        super.emissiveFromCalc();
        this.calcColorBuffer();
        this.gl2f.glMaterialfv(1032, 5632, this.colorFloats, 0);
    }

    public void lights() {
        this.enableLighting();
        int colorModeSaved = this.colorMode;
        this.colorMode = 1;
        this.lightFalloff(1.0f, 0.0f, 0.0f);
        this.lightSpecular(0.0f, 0.0f, 0.0f);
        this.ambientLight(this.colorModeX * 0.5f, this.colorModeY * 0.5f, this.colorModeZ * 0.5f);
        this.directionalLight(this.colorModeX * 0.5f, this.colorModeY * 0.5f, this.colorModeZ * 0.5f, 0.0f, 0.0f, -1.0f);
        this.colorMode = colorModeSaved;
    }

    public void noLights() {
        this.disableLighting();
        this.lightCount = 0;
    }

    public void ambientLight(float r, float g, float b) {
        this.ambientLight(r, g, b, 0.0f, 0.0f, 0.0f);
    }

    public void ambientLight(float r, float g, float b, float x, float y, float z) {
        if (!this.lights) {
            this.enableLighting();
        }
        if (this.lightCount == 8) {
            throw new RuntimeException("can only create 8 lights");
        }
        this.colorCalc(r, g, b);
        this.lightDiffuse[this.lightCount][0] = this.calcR;
        this.lightDiffuse[this.lightCount][1] = this.calcG;
        this.lightDiffuse[this.lightCount][2] = this.calcB;
        this.lightDiffuse[this.lightCount][3] = 1.0f;
        this.lightType[this.lightCount] = 0;
        this.lightFalloffConstant[this.lightCount] = this.currentLightFalloffConstant;
        this.lightFalloffLinear[this.lightCount] = this.currentLightFalloffLinear;
        this.lightFalloffQuadratic[this.lightCount] = this.currentLightFalloffQuadratic;
        this.lightPosition[this.lightCount][0] = x;
        this.lightPosition[this.lightCount][1] = y;
        this.lightPosition[this.lightCount][2] = z;
        this.lightPosition[this.lightCount][3] = 1.0f;
        this.lightEnable(this.lightCount);
        this.lightAmbient(this.lightCount);
        this.lightPosition(this.lightCount);
        this.lightFalloff(this.lightCount);
        this.lightNoSpot(this.lightCount);
        this.lightNoDiffuse(this.lightCount);
        this.lightNoSpecular(this.lightCount);
        ++this.lightCount;
    }

    public void directionalLight(float r, float g, float b, float nx, float ny, float nz) {
        if (!this.lights) {
            this.enableLighting();
        }
        if (this.lightCount == 8) {
            throw new RuntimeException("can only create 8 lights");
        }
        this.colorCalc(r, g, b);
        this.lightDiffuse[this.lightCount][0] = this.calcR;
        this.lightDiffuse[this.lightCount][1] = this.calcG;
        this.lightDiffuse[this.lightCount][2] = this.calcB;
        this.lightDiffuse[this.lightCount][3] = 1.0f;
        this.lightType[this.lightCount] = 1;
        this.lightFalloffConstant[this.lightCount] = this.currentLightFalloffConstant;
        this.lightFalloffLinear[this.lightCount] = this.currentLightFalloffLinear;
        this.lightFalloffQuadratic[this.lightCount] = this.currentLightFalloffQuadratic;
        this.lightSpecular[this.lightCount][0] = this.currentLightSpecular[0];
        this.lightSpecular[this.lightCount][1] = this.currentLightSpecular[1];
        this.lightSpecular[this.lightCount][2] = this.currentLightSpecular[2];
        this.lightSpecular[this.lightCount][3] = this.currentLightSpecular[3];
        float invn = 1.0f / PApplet.dist((float)0.0f, (float)0.0f, (float)0.0f, (float)nx, (float)ny, (float)nz);
        this.lightNormal[this.lightCount][0] = invn * nx;
        this.lightNormal[this.lightCount][1] = invn * ny;
        this.lightNormal[this.lightCount][2] = invn * nz;
        this.lightNormal[this.lightCount][3] = 0.0f;
        this.lightEnable(this.lightCount);
        this.lightNoAmbient(this.lightCount);
        this.lightDirection(this.lightCount);
        this.lightDiffuse(this.lightCount);
        this.lightSpecular(this.lightCount);
        this.lightFalloff(this.lightCount);
        this.lightNoSpot(this.lightCount);
        ++this.lightCount;
    }

    public void pointLight(float r, float g, float b, float x, float y, float z) {
        if (!this.lights) {
            this.enableLighting();
        }
        if (this.lightCount == 8) {
            throw new RuntimeException("can only create 8 lights");
        }
        this.colorCalc(r, g, b);
        this.lightDiffuse[this.lightCount][0] = this.calcR;
        this.lightDiffuse[this.lightCount][1] = this.calcG;
        this.lightDiffuse[this.lightCount][2] = this.calcB;
        this.lightDiffuse[this.lightCount][3] = 1.0f;
        this.lightType[this.lightCount] = 2;
        this.lightFalloffConstant[this.lightCount] = this.currentLightFalloffConstant;
        this.lightFalloffLinear[this.lightCount] = this.currentLightFalloffLinear;
        this.lightFalloffQuadratic[this.lightCount] = this.currentLightFalloffQuadratic;
        this.lightSpecular[this.lightCount][0] = this.currentLightSpecular[0];
        this.lightSpecular[this.lightCount][1] = this.currentLightSpecular[1];
        this.lightSpecular[this.lightCount][2] = this.currentLightSpecular[2];
        this.lightPosition[this.lightCount][0] = x;
        this.lightPosition[this.lightCount][1] = y;
        this.lightPosition[this.lightCount][2] = z;
        this.lightPosition[this.lightCount][3] = 1.0f;
        this.lightEnable(this.lightCount);
        this.lightNoAmbient(this.lightCount);
        this.lightPosition(this.lightCount);
        this.lightDiffuse(this.lightCount);
        this.lightSpecular(this.lightCount);
        this.lightFalloff(this.lightCount);
        this.lightNoSpot(this.lightCount);
        ++this.lightCount;
    }

    public void spotLight(float r, float g, float b, float x, float y, float z, float nx, float ny, float nz, float angle, float concentration) {
        if (!this.lights) {
            this.enableLighting();
        }
        if (this.lightCount == 8) {
            throw new RuntimeException("can only create 8 lights");
        }
        this.colorCalc(r, g, b);
        this.lightDiffuse[this.lightCount][0] = this.calcR;
        this.lightDiffuse[this.lightCount][1] = this.calcG;
        this.lightDiffuse[this.lightCount][2] = this.calcB;
        this.lightDiffuse[this.lightCount][3] = 1.0f;
        this.lightType[this.lightCount] = 3;
        this.lightFalloffConstant[this.lightCount] = this.currentLightFalloffConstant;
        this.lightFalloffLinear[this.lightCount] = this.currentLightFalloffLinear;
        this.lightFalloffQuadratic[this.lightCount] = this.currentLightFalloffQuadratic;
        this.lightSpecular[this.lightCount][0] = this.currentLightSpecular[0];
        this.lightSpecular[this.lightCount][1] = this.currentLightSpecular[1];
        this.lightSpecular[this.lightCount][2] = this.currentLightSpecular[2];
        this.lightPosition[this.lightCount][0] = x;
        this.lightPosition[this.lightCount][1] = y;
        this.lightPosition[this.lightCount][2] = z;
        this.lightPosition[this.lightCount][3] = 1.0f;
        float invn = 1.0f / PApplet.dist((float)0.0f, (float)0.0f, (float)0.0f, (float)nx, (float)ny, (float)nz);
        this.lightNormal[this.lightCount][0] = invn * nx;
        this.lightNormal[this.lightCount][1] = invn * ny;
        this.lightNormal[this.lightCount][2] = invn * nz;
        this.lightNormal[this.lightCount][3] = 0.0f;
        this.lightSpotAngle[this.lightCount] = PApplet.degrees((float)angle);
        this.lightSpotAngleCos[this.lightCount] = Math.max(0.0f, (float)Math.cos(angle));
        this.lightSpotConcentration[this.lightCount] = concentration;
        this.lightEnable(this.lightCount);
        this.lightNoAmbient(this.lightCount);
        this.lightPosition(this.lightCount);
        this.lightDirection(this.lightCount);
        this.lightDiffuse(this.lightCount);
        this.lightSpecular(this.lightCount);
        this.lightFalloff(this.lightCount);
        this.lightSpotAngle(this.lightCount);
        this.lightSpotConcentration(this.lightCount);
        ++this.lightCount;
    }

    public void lightFalloff(float constant, float linear, float quadratic) {
        this.currentLightFalloffConstant = constant;
        this.currentLightFalloffLinear = linear;
        this.currentLightFalloffQuadratic = quadratic;
    }

    public void lightSpecular(float x, float y, float z) {
        this.colorCalc(x, y, z);
        this.currentLightSpecular[0] = this.calcR;
        this.currentLightSpecular[1] = this.calcG;
        this.currentLightSpecular[2] = this.calcB;
        this.currentLightSpecular[3] = 1.0f;
    }

    protected void enableLights() {
        int i = 0;
        while (i < this.lightCount) {
            this.lightEnable(i);
            ++i;
        }
    }

    protected void disableLights() {
        int i = 0;
        while (i < this.lightCount) {
            this.lightDisable(i);
            ++i;
        }
    }

    protected void enableLighting() {
        this.lights = true;
        this.gl2f.glEnable(2896);
    }

    protected void disableLighting() {
        this.lights = false;
        this.gl2f.glDisable(2896);
    }

    protected void lightAmbient(int num) {
        this.gl2f.glLightfv(16384 + num, 4608, this.lightDiffuse[num], 0);
    }

    protected void lightNoAmbient(int num) {
        this.gl2f.glLightfv(16384 + num, 4608, this.zeroLight, 0);
    }

    protected void lightNoSpot(int num) {
        this.gl2f.glLightf(16384 + num, 4614, 180.0f);
        this.gl2f.glLightf(16384 + num, 4613, 0.0f);
    }

    protected void lightDiffuse(int num) {
        this.gl2f.glLightfv(16384 + num, 4609, this.lightDiffuse[num], 0);
    }

    protected void lightNoDiffuse(int num) {
        this.gl2f.glLightfv(16384 + num, 4609, this.zeroLight, 0);
    }

    protected void lightDirection(int num) {
        if (this.lightType[num] == 1) {
            this.gl2f.glLightfv(16384 + num, 4611, this.lightNormal[num], 0);
        } else {
            this.gl2f.glLightfv(16384 + num, 4612, this.lightNormal[num], 0);
        }
    }

    protected void lightEnable(int num) {
        this.gl2f.glEnable(16384 + num);
    }

    protected void lightDisable(int num) {
        this.gl2f.glDisable(16384 + num);
    }

    protected void lightFalloff(int num) {
        this.gl2f.glLightf(16384 + num, 4615, this.lightFalloffConstant[num]);
        this.gl2f.glLightf(16384 + num, 4616, this.lightFalloffLinear[num]);
        this.gl2f.glLightf(16384 + num, 4617, this.lightFalloffQuadratic[num]);
    }

    protected void lightPosition(int num) {
        this.gl2f.glLightfv(16384 + num, 4611, this.lightPosition[num], 0);
    }

    protected void lightSpecular(int num) {
        this.gl2f.glLightfv(16384 + num, 4610, this.lightSpecular[num], 0);
    }

    protected void lightNoSpecular(int num) {
        this.gl2f.glLightfv(16384 + num, 4610, this.zeroLight, 0);
    }

    protected void lightSpotAngle(int num) {
        this.gl2f.glLightf(16384 + num, 4614, this.lightSpotAngle[num]);
    }

    protected void lightSpotConcentration(int num) {
        this.gl2f.glLightf(16384 + num, 4613, this.lightSpotConcentration[num]);
    }

    protected void backgroundImpl(PImage image) {
        this.gl.glClearColor(this.backgroundR, this.backgroundG, this.backgroundB, 1.0f);
        this.gl.glClear(16640);
        this.set(0, 0, image);
    }

    protected void backgroundImpl() {
        this.gl.glClearColor(this.backgroundR, this.backgroundG, this.backgroundB, 1.0f);
        this.gl.glClear(16640);
    }

    protected final void calcColorBuffer() {
        if (this.colorFloats == null) {
            this.colorFloats = new float[4];
        }
        this.colorFloats[0] = this.calcR;
        this.colorFloats[1] = this.calcG;
        this.colorFloats[2] = this.calcB;
        this.colorFloats[3] = this.calcA;
    }

    public void report(String where) {
        if (!this.hints[6]) {
            int n = this.gl.glGetError();
        }
    }

    public void loadPixels() {
        block10: {
            int x;
            if (this.pixels == null || this.pixels.length != this.width * this.height) {
                this.pixels = new int[this.width * this.height];
                this.pixelBuffer = IntBuffer.allocate(this.pixels.length);
                this.pixelBuffer.rewind();
            }
            this.gl.glReadPixels(0, 0, this.width, this.height, 6408, 5121, (Buffer)this.pixelBuffer);
            this.pixelBuffer.get(this.pixels);
            this.pixelBuffer.rewind();
            int index = 0;
            int yindex = (this.height - 1) * this.width;
            int y = 0;
            while (y < this.height / 2) {
                int temp;
                int x2;
                if (BIG_ENDIAN) {
                    x2 = 0;
                    while (x2 < this.width) {
                        temp = this.pixels[index];
                        this.pixels[index] = 0xFF000000 | this.pixels[yindex] >> 8 & 0xFFFFFF;
                        this.pixels[yindex] = 0xFF000000 | temp >> 8 & 0xFFFFFF;
                        ++index;
                        ++yindex;
                        ++x2;
                    }
                } else {
                    x2 = 0;
                    while (x2 < this.width) {
                        temp = this.pixels[index];
                        this.pixels[index] = 0xFF000000 | this.pixels[yindex] << 16 & 0xFF0000 | this.pixels[yindex] & 0xFF00 | this.pixels[yindex] >> 16 & 0xFF;
                        this.pixels[yindex] = 0xFF000000 | temp << 16 & 0xFF0000 | temp & 0xFF00 | temp >> 16 & 0xFF;
                        ++index;
                        ++yindex;
                        ++x2;
                    }
                }
                yindex -= this.width * 2;
                ++y;
            }
            if (this.height % 2 != 1) break block10;
            index = this.height / 2 * this.width;
            if (BIG_ENDIAN) {
                x = 0;
                while (x < this.width) {
                    this.pixels[index] = 0xFF000000 | this.pixels[index] >> 8 & 0xFFFFFF;
                    ++x;
                }
            } else {
                x = 0;
                while (x < this.width) {
                    this.pixels[index] = 0xFF000000 | this.pixels[index] << 16 & 0xFF0000 | this.pixels[index] & 0xFF00 | this.pixels[index] >> 16 & 0xFF;
                    ++x;
                }
            }
        }
    }

    public static void nativeToJavaRGB(PImage image) {
        int index = 0;
        int yindex = (image.height - 1) * image.width;
        int y = 0;
        while (y < image.height / 2) {
            int temp;
            int x;
            if (BIG_ENDIAN) {
                x = 0;
                while (x < image.width) {
                    temp = image.pixels[index];
                    image.pixels[index] = 0xFF000000 | image.pixels[yindex] >> 8 & 0xFFFFFF;
                    image.pixels[yindex] = 0xFF000000 | temp >> 8 & 0xFFFFFF;
                    ++index;
                    ++yindex;
                    ++x;
                }
            } else {
                x = 0;
                while (x < image.width) {
                    temp = image.pixels[index];
                    image.pixels[index] = 0xFF000000 | image.pixels[yindex] << 16 & 0xFF0000 | image.pixels[yindex] & 0xFF00 | image.pixels[yindex] >> 16 & 0xFF;
                    image.pixels[yindex] = 0xFF000000 | temp << 16 & 0xFF0000 | temp & 0xFF00 | temp >> 16 & 0xFF;
                    ++index;
                    ++yindex;
                    ++x;
                }
            }
            yindex -= image.width * 2;
            ++y;
        }
    }

    public static void nativeToJavaARGB(PImage image) {
        int index = 0;
        int yindex = (image.height - 1) * image.width;
        int y = 0;
        while (y < image.height / 2) {
            int temp;
            int x;
            if (BIG_ENDIAN) {
                x = 0;
                while (x < image.width) {
                    temp = image.pixels[index];
                    image.pixels[index] = image.pixels[yindex] & 0xFF000000 | image.pixels[yindex] >> 8 & 0xFFFFFF;
                    image.pixels[yindex] = temp & 0xFF000000 | temp >> 8 & 0xFFFFFF;
                    ++index;
                    ++yindex;
                    ++x;
                }
            } else {
                x = 0;
                while (x < image.width) {
                    temp = image.pixels[index];
                    image.pixels[index] = image.pixels[yindex] & 0xFF000000 | image.pixels[yindex] << 16 & 0xFF0000 | image.pixels[yindex] & 0xFF00 | image.pixels[yindex] >> 16 & 0xFF;
                    image.pixels[yindex] = temp & 0xFF000000 | temp << 16 & 0xFF0000 | temp & 0xFF00 | temp >> 16 & 0xFF;
                    ++index;
                    ++yindex;
                    ++x;
                }
            }
            yindex -= image.width * 2;
            ++y;
        }
    }

    public static void javaToNativeRGB(PImage image) {
        int width = image.width;
        int height = image.height;
        int[] pixels = image.pixels;
        int index = 0;
        int yindex = (height - 1) * width;
        int y = 0;
        while (y < height / 2) {
            int temp;
            int x;
            if (BIG_ENDIAN) {
                x = 0;
                while (x < image.width) {
                    temp = pixels[index];
                    pixels[index] = pixels[yindex] << 8 & 0xFFFFFF00 | 0xFF;
                    pixels[yindex] = temp << 8 & 0xFFFFFF00 | 0xFF;
                    ++index;
                    ++yindex;
                    ++x;
                }
            } else {
                x = 0;
                while (x < width) {
                    temp = pixels[index];
                    pixels[index] = 0xFF000000 | pixels[yindex] << 16 & 0xFF0000 | pixels[yindex] & 0xFF00 | pixels[yindex] >> 16 & 0xFF;
                    pixels[yindex] = 0xFF000000 | temp << 16 & 0xFF0000 | temp & 0xFF00 | temp >> 16 & 0xFF;
                    ++index;
                    ++yindex;
                    ++x;
                }
            }
            yindex -= width * 2;
            ++y;
        }
    }

    public static void javaToNativeARGB(PImage image) {
        int width = image.width;
        int height = image.height;
        int[] pixels = image.pixels;
        int index = 0;
        int yindex = (height - 1) * width;
        int y = 0;
        while (y < height / 2) {
            int temp;
            int x;
            if (BIG_ENDIAN) {
                x = 0;
                while (x < image.width) {
                    temp = pixels[index];
                    pixels[index] = pixels[yindex] >> 24 & 0xFF | pixels[yindex] << 8 & 0xFFFFFF00;
                    pixels[yindex] = temp >> 24 & 0xFF | temp << 8 & 0xFFFFFF00;
                    ++index;
                    ++yindex;
                    ++x;
                }
            } else {
                x = 0;
                while (x < width) {
                    temp = pixels[index];
                    pixels[index] = pixels[yindex] & 0xFF000000 | pixels[yindex] << 16 & 0xFF0000 | pixels[yindex] & 0xFF00 | pixels[yindex] >> 16 & 0xFF;
                    pixels[yindex] = pixels[yindex] & 0xFF000000 | temp << 16 & 0xFF0000 | temp & 0xFF00 | temp >> 16 & 0xFF;
                    ++index;
                    ++yindex;
                    ++x;
                }
            }
            yindex -= width * 2;
            ++y;
        }
    }

    public void updatePixels() {
        int index = 0;
        int yindex = (this.height - 1) * this.width;
        int y = 0;
        while (y < this.height / 2) {
            int temp;
            int x;
            if (BIG_ENDIAN) {
                x = 0;
                while (x < this.width) {
                    temp = this.pixels[index];
                    this.pixels[index] = this.pixels[yindex] << 8 & 0xFFFFFF00 | 0xFF;
                    this.pixels[yindex] = temp << 8 & 0xFFFFFF00 | 0xFF;
                    ++index;
                    ++yindex;
                    ++x;
                }
            } else {
                x = 0;
                while (x < this.width) {
                    temp = this.pixels[index];
                    this.pixels[index] = 0xFF000000 | this.pixels[yindex] << 16 & 0xFF0000 | this.pixels[yindex] & 0xFF00 | this.pixels[yindex] >> 16 & 0xFF;
                    this.pixels[yindex] = 0xFF000000 | temp << 16 & 0xFF0000 | temp & 0xFF00 | temp >> 16 & 0xFF;
                    ++index;
                    ++yindex;
                    ++x;
                }
            }
            yindex -= this.width * 2;
            ++y;
        }
        this.pixelBuffer.put(this.pixels);
        this.pixelBuffer.rewind();
        this.copyToTexture(this.pixelBuffer);
        this.drawTexture(this.texture, this.texCrop, 0, 0, this.width, this.height);
    }

    public void loadTexture() {
        if (this.primarySurface) {
            this.loadTextureImpl(2);
            this.loadPixels();
            this.pixelsToTexture();
        }
    }

    protected void loadTextureImpl(int sampling) {
        if (this.width == 0 || this.height == 0) {
            return;
        }
        if (this.texture == null) {
            PTexture.Parameters params = PTexture.newParameters(2, sampling);
            this.texture = new PTexture(this.parent, this.width, this.height, params);
            this.texture.setFlippedY(true);
            this.setCache(this.pgl, this.texture);
            this.setParams(this.pgl, params);
            this.texCrop = new int[4];
            this.texCrop[0] = 0;
            this.texCrop[1] = 0;
            this.texCrop[2] = this.width;
            this.texCrop[3] = this.height;
        }
    }

    public void updateTexture() {
        this.drawTexture(this.texture, this.texCrop, 0, 0, this.width, this.height);
    }

    protected void copyToTexture(IntBuffer buffer) {
        this.copyToTexture(this.texture, buffer, 0, 0, this.width, this.height);
    }

    protected void copyFrameToTexture() {
        this.gl.glFinish();
        this.loadTexture();
    }

    protected void pixelsToTexture() {
        this.texture.set(this.pixels);
    }

    protected void textureToPixels() {
        this.texture.get(this.pixels);
    }

    public void resize(int wide, int high) {
        PGraphics.showMethodWarning((String)"resize");
    }

    public int get(int x, int y) {
        if (this.getsetBuffer == null) {
            this.getsetBuffer = IntBuffer.allocate(1);
            this.getsetBuffer.rewind();
        }
        this.gl.glReadPixels(x, this.height - y, 1, 1, 6408, 5121, (Buffer)this.getsetBuffer);
        int getset = this.getsetBuffer.get(0);
        if (BIG_ENDIAN) {
            return 0xFF000000 | getset >> 8 & 0xFFFFFF;
        }
        return 0xFF000000 | getset << 16 & 0xFF0000 | getset & 0xFF00 | getset >> 16 & 0xFF;
    }

    protected PImage getImpl(int x, int y, int w, int h) {
        PImage newbie = this.parent.createImage(w, h, 2);
        PTexture newbieTex = this.addTexture(newbie);
        IntBuffer newbieBuffer = IntBuffer.allocate(w * h);
        this.gl.glReadPixels(x, this.height - y, w, -h, 6408, 5121, (Buffer)newbieBuffer);
        this.copyToTexture(newbieTex, newbieBuffer, 0, 0, w, h);
        newbie.loadPixels();
        newbieTex.get(newbie.pixels);
        return newbie;
    }

    public PImage get() {
        return this.get(0, 0, this.width, this.height);
    }

    public void set(int x, int y, int argb) {
        int getset = 0;
        getset = BIG_ENDIAN ? argb << 8 | 0xFF : argb & 0xFF00FF00 | argb << 16 & 0xFF0000 | argb >> 16 & 0xFF;
        if (this.getsetBuffer == null) {
            this.getsetBuffer = IntBuffer.allocate(1);
            this.getsetBuffer.rewind();
        }
        this.getsetBuffer.put(0, getset);
        this.getsetBuffer.rewind();
        if (this.getsetTexture == null) {
            this.getsetTexture = new PTexture(this.parent, 1, 1, new PTexture.Parameters(2, 2));
        }
        this.copyToTexture(this.getsetTexture, this.getsetBuffer, 0, 0, 1, 1);
        this.drawTexture(this.getsetTexture, 0, 0, 1, 1, x, this.height - y, 1, 1);
    }

    public void set(int x, int y, PImage source) {
        PTexture tex = (PTexture)source.getCache((PGraphics)this.pgl);
        if (tex != null) {
            int w = source.width;
            int h = source.height;
            this.drawTexture(tex, 0, h, w, -h, x, this.height - y, w, h);
        }
    }

    public void mask(int[] alpha) {
        PGraphics.showMethodWarning((String)"mask");
    }

    public void mask(PImage alpha) {
        PGraphics.showMethodWarning((String)"mask");
    }

    public void filter(int kind) {
        PImage temp = this.get();
        temp.filter(kind);
        this.set(0, 0, temp);
    }

    public void filter(int kind, float param) {
        PImage temp = this.get();
        temp.filter(kind, param);
        this.set(0, 0, temp);
    }

    public void blend(int mode) {
        this.blend = true;
        this.blendMode = mode;
        this.gl.glEnable(3042);
        if (mode == 0) {
            if (blendEqSupported) {
                this.gl.glBlendEquation(32774);
            }
            this.gl.glBlendFunc(1, 0);
        } else if (mode == 1) {
            if (blendEqSupported) {
                this.gl.glBlendEquation(32774);
            }
            this.gl.glBlendFunc(770, 771);
        } else if (mode == 2) {
            if (blendEqSupported) {
                this.gl.glBlendEquation(32774);
            }
            this.gl.glBlendFunc(770, 1);
        } else if (mode == 4) {
            if (blendEqSupported) {
                this.gl.glBlendEquation(32774);
            }
            this.gl.glBlendFunc(775, 0);
        } else if (mode == 8) {
            if (blendEqSupported) {
                this.gl.glBlendEquation(32776);
                this.gl.glBlendFunc(770, 772);
            } else {
                PGraphics.showWarning((String)"OPENGL2: This blend mode is currently unsupported.");
            }
        } else if (mode == 16) {
            if (blendEqSupported) {
                this.gl.glBlendEquation(32775);
                this.gl.glBlendFunc(770, 772);
            } else {
                PGraphics.showWarning((String)"OPENGL2: This blend mode is currently unsupported.");
            }
        } else if (mode == 32) {
            if (blendEqSupported) {
                this.gl.glBlendEquation(32779);
                this.gl.glBlendFunc(1, 1);
            } else {
                PGraphics.showWarning((String)"OPENGL2: This blend mode is currently unsupported.");
            }
        } else if (mode == 64) {
            if (blendEqSupported) {
                this.gl.glBlendEquation(32774);
            }
            this.gl.glBlendFunc(775, 769);
        } else if (mode == 128) {
            if (blendEqSupported) {
                this.gl.glBlendEquation(32774);
            }
            this.gl.glBlendFunc(774, 768);
        } else if (mode == 256) {
            if (blendEqSupported) {
                this.gl.glBlendEquation(32774);
            }
            this.gl.glBlendFunc(775, 1);
        }
    }

    public void noBlend() {
        this.blend = false;
        this.gl.glDisable(3042);
    }

    public void textureBlend(int mode) {
        this.multitexureBlendMode = mode;
    }

    public void noTextureBlend() {
        this.multitexureBlendMode = 0;
    }

    protected void setMultitextureBlend(PTexture[] textures, int num) {
        if (2 < num) {
            PGraphics.showWarning((String)"OPENGL2: multitexture blending currently supports only two textures.");
            return;
        }
        if (!texenvCrossbarSupported) {
            PGraphics.showWarning((String)"OPENGL2: Texture environment crossbar not supported, so the textures won't be affected by tint or light.");
            if (this.multitexureBlendMode == 0) {
                this.gl2f.glActiveTexture(33984);
                this.gl2f.glBindTexture(textures[0].getGLTarget(), textures[0].getGLID());
                this.gl2f.glTexEnvi(8960, 8704, 7681);
                this.gl2f.glActiveTexture(33985);
                this.gl2f.glBindTexture(textures[1].getGLTarget(), textures[1].getGLID());
                this.gl2f.glTexEnvi(8960, 8704, 7681);
            } else if (this.multitexureBlendMode == 1) {
                this.gl2f.glActiveTexture(33984);
                this.gl2f.glBindTexture(textures[0].getGLTarget(), textures[0].getGLID());
                this.gl2f.glTexEnvi(8960, 8704, 7681);
                this.gl2f.glActiveTexture(33985);
                this.gl2f.glBindTexture(textures[1].getGLTarget(), textures[1].getGLID());
                this.gl2f.glTexEnvi(8960, 8704, 34160);
                this.gl2f.glTexEnvi(8960, 34161, 34165);
                this.gl2f.glTexEnvi(8960, 34176, 34168);
                this.gl2f.glTexEnvi(8960, 34177, 5890);
                this.gl2f.glTexEnvi(8960, 34178, 5890);
                this.gl2f.glTexEnvi(8960, 34192, 768);
                this.gl2f.glTexEnvi(8960, 34193, 768);
                this.gl2f.glTexEnvi(8960, 34194, 771);
                this.gl2f.glTexEnvi(8960, 34162, 34165);
                this.gl2f.glTexEnvi(8960, 34184, 34168);
                this.gl2f.glTexEnvi(8960, 34185, 5890);
                this.gl2f.glTexEnvi(8960, 34186, 5890);
                this.gl2f.glTexEnvi(8960, 34200, 770);
                this.gl2f.glTexEnvi(8960, 34201, 770);
                this.gl2f.glTexEnvi(8960, 34202, 771);
            } else if (this.multitexureBlendMode == 128) {
                this.gl2f.glActiveTexture(33984);
                this.gl2f.glBindTexture(textures[0].getGLTarget(), textures[0].getGLID());
                this.gl2f.glTexEnvi(8960, 8704, 7681);
                this.gl2f.glActiveTexture(33985);
                this.gl2f.glBindTexture(textures[1].getGLTarget(), textures[1].getGLID());
                this.gl2f.glTexEnvi(8960, 8704, 34160);
                this.gl2f.glTexEnvi(8960, 34161, 8448);
                this.gl2f.glTexEnvi(8960, 34176, 34168);
                this.gl2f.glTexEnvi(8960, 34177, 5890);
                this.gl2f.glTexEnvi(8960, 34192, 768);
                this.gl2f.glTexEnvi(8960, 34193, 768);
                this.gl2f.glTexEnvi(8960, 34162, 8448);
                this.gl2f.glTexEnvi(8960, 34184, 34168);
                this.gl2f.glTexEnvi(8960, 34185, 5890);
                this.gl2f.glTexEnvi(8960, 34200, 770);
                this.gl2f.glTexEnvi(8960, 34201, 770);
            } else if (this.multitexureBlendMode == 2) {
                this.gl2f.glActiveTexture(33984);
                this.gl2f.glBindTexture(textures[0].getGLTarget(), textures[0].getGLID());
                this.gl2f.glTexEnvi(8960, 8704, 7681);
                this.gl2f.glActiveTexture(33985);
                this.gl2f.glBindTexture(textures[1].getGLTarget(), textures[1].getGLID());
                this.gl2f.glTexEnvi(8960, 8704, 34160);
                this.gl2f.glTexEnvi(8960, 34161, 260);
                this.gl2f.glTexEnvi(8960, 34176, 34168);
                this.gl2f.glTexEnvi(8960, 34177, 5890);
                this.gl2f.glTexEnvi(8960, 34192, 768);
                this.gl2f.glTexEnvi(8960, 34193, 768);
                this.gl2f.glTexEnvi(8960, 34162, 260);
                this.gl2f.glTexEnvi(8960, 34184, 34168);
                this.gl2f.glTexEnvi(8960, 34185, 5890);
                this.gl2f.glTexEnvi(8960, 34200, 770);
                this.gl2f.glTexEnvi(8960, 34201, 770);
            } else if (this.multitexureBlendMode == 4) {
                this.gl2f.glActiveTexture(33984);
                this.gl2f.glBindTexture(textures[0].getGLTarget(), textures[0].getGLID());
                this.gl2f.glTexEnvi(8960, 8704, 7681);
                this.gl2f.glActiveTexture(33985);
                this.gl2f.glBindTexture(textures[1].getGLTarget(), textures[1].getGLID());
                this.gl2f.glTexEnvi(8960, 8704, 34160);
                this.gl2f.glTexEnvi(8960, 34161, 34023);
                this.gl2f.glTexEnvi(8960, 34176, 34168);
                this.gl2f.glTexEnvi(8960, 34177, 5890);
                this.gl2f.glTexEnvi(8960, 34192, 768);
                this.gl2f.glTexEnvi(8960, 34193, 768);
                this.gl2f.glTexEnvi(8960, 34162, 260);
                this.gl2f.glTexEnvi(8960, 34184, 34168);
                this.gl2f.glTexEnvi(8960, 34185, 5890);
                this.gl2f.glTexEnvi(8960, 34200, 770);
                this.gl2f.glTexEnvi(8960, 34201, 770);
            } else {
                PGraphics.showWarning((String)"OPENGL2: This blend mode is currently unsupported in multitexture mode.");
            }
        } else if (this.multitexureBlendMode == 0) {
            this.gl2f.glActiveTexture(33984);
            this.gl2f.glBindTexture(textures[0].getGLTarget(), textures[0].getGLID());
            this.gl2f.glTexEnvi(8960, 8704, 34160);
            this.gl2f.glTexEnvi(8960, 34161, 7681);
            this.gl2f.glTexEnvi(8960, 34176, 33985);
            this.gl2f.glTexEnvi(8960, 34192, 768);
            this.gl2f.glTexEnvi(8960, 34162, 7681);
            this.gl2f.glTexEnvi(8960, 34184, 33985);
            this.gl2f.glTexEnvi(8960, 34200, 770);
            this.modulateWithPrimaryColor(1, textures[1]);
        } else if (this.multitexureBlendMode == 1) {
            this.gl2f.glActiveTexture(33984);
            this.gl2f.glBindTexture(textures[0].getGLTarget(), textures[0].getGLID());
            this.gl2f.glTexEnvi(8960, 8704, 34160);
            this.gl2f.glTexEnvi(8960, 34161, 34165);
            this.gl2f.glTexEnvi(8960, 34176, 33984);
            this.gl2f.glTexEnvi(8960, 34177, 33985);
            this.gl2f.glTexEnvi(8960, 34178, 33985);
            this.gl2f.glTexEnvi(8960, 34192, 768);
            this.gl2f.glTexEnvi(8960, 34193, 768);
            this.gl2f.glTexEnvi(8960, 34194, 771);
            this.gl2f.glTexEnvi(8960, 34162, 34165);
            this.gl2f.glTexEnvi(8960, 34184, 33984);
            this.gl2f.glTexEnvi(8960, 34185, 33985);
            this.gl2f.glTexEnvi(8960, 34186, 33985);
            this.gl2f.glTexEnvi(8960, 34200, 770);
            this.gl2f.glTexEnvi(8960, 34201, 770);
            this.gl2f.glTexEnvi(8960, 34202, 771);
            this.modulateWithPrimaryColor(1, textures[1]);
        } else if (this.multitexureBlendMode == 128) {
            this.gl2f.glActiveTexture(33984);
            this.gl2f.glBindTexture(textures[0].getGLTarget(), textures[0].getGLID());
            this.gl2f.glTexEnvi(8960, 8704, 34160);
            this.gl2f.glTexEnvi(8960, 34161, 8448);
            this.gl2f.glTexEnvi(8960, 34176, 33984);
            this.gl2f.glTexEnvi(8960, 34177, 33985);
            this.gl2f.glTexEnvi(8960, 34192, 768);
            this.gl2f.glTexEnvi(8960, 34193, 768);
            this.gl2f.glTexEnvi(8960, 34162, 8448);
            this.gl2f.glTexEnvi(8960, 34184, 33984);
            this.gl2f.glTexEnvi(8960, 34185, 33985);
            this.gl2f.glTexEnvi(8960, 34200, 770);
            this.gl2f.glTexEnvi(8960, 34201, 770);
            this.modulateWithPrimaryColor(1, textures[1]);
        } else if (this.multitexureBlendMode == 2) {
            this.gl2f.glActiveTexture(33984);
            this.gl2f.glBindTexture(textures[0].getGLTarget(), textures[0].getGLID());
            this.gl2f.glTexEnvi(8960, 8704, 34160);
            this.gl2f.glTexEnvi(8960, 34161, 260);
            this.gl2f.glTexEnvi(8960, 34176, 33984);
            this.gl2f.glTexEnvi(8960, 34177, 33985);
            this.gl2f.glTexEnvi(8960, 34192, 768);
            this.gl2f.glTexEnvi(8960, 34193, 768);
            this.gl2f.glTexEnvi(8960, 34162, 260);
            this.gl2f.glTexEnvi(8960, 34184, 33984);
            this.gl2f.glTexEnvi(8960, 34185, 33985);
            this.gl2f.glTexEnvi(8960, 34200, 770);
            this.gl2f.glTexEnvi(8960, 34201, 770);
            this.modulateWithPrimaryColor(1, textures[1]);
        } else if (this.multitexureBlendMode == 4) {
            this.gl2f.glActiveTexture(33984);
            this.gl2f.glBindTexture(textures[0].getGLTarget(), textures[0].getGLID());
            this.gl2f.glTexEnvi(8960, 8704, 34160);
            this.gl2f.glTexEnvi(8960, 34161, 34023);
            this.gl2f.glTexEnvi(8960, 34176, 33984);
            this.gl2f.glTexEnvi(8960, 34177, 33985);
            this.gl2f.glTexEnvi(8960, 34192, 768);
            this.gl2f.glTexEnvi(8960, 34193, 768);
            this.gl2f.glTexEnvi(8960, 34162, 34023);
            this.gl2f.glTexEnvi(8960, 34184, 33984);
            this.gl2f.glTexEnvi(8960, 34185, 33985);
            this.gl2f.glTexEnvi(8960, 34200, 770);
            this.gl2f.glTexEnvi(8960, 34201, 770);
            this.modulateWithPrimaryColor(1, textures[1]);
        } else {
            PGraphics.showWarning((String)"OPENGL2: This blend mode is currently unsupported in multitexture mode.");
        }
        this.gl2f.glDisable(3042);
    }

    protected void modulateWithPrimaryColor(int unit, PTexture tex) {
        this.gl2f.glActiveTexture(33984 + unit);
        this.gl2f.glBindTexture(tex.getGLTarget(), tex.getGLID());
        this.gl2f.glTexEnvi(8960, 8704, 34160);
        this.gl2f.glTexEnvi(8960, 34161, 8448);
        this.gl2f.glTexEnvi(8960, 34176, 34168);
        this.gl2f.glTexEnvi(8960, 34177, 34167);
        this.gl2f.glTexEnvi(8960, 34192, 768);
        this.gl2f.glTexEnvi(8960, 34193, 768);
        this.gl2f.glTexEnvi(8960, 34162, 7681);
        this.gl2f.glTexEnvi(8960, 34184, 34168);
        this.gl2f.glTexEnvi(8960, 34200, 770);
    }

    protected void clearMultitextureBlend(int num) {
        int i = 0;
        while (i < num) {
            this.gl2f.glActiveTexture(33984 + i);
            this.gl2f.glTexEnvi(8960, 8704, 8448);
            ++i;
        }
        if (this.blend) {
            this.blend(this.blendMode);
        } else {
            this.noBlend();
        }
    }

    protected String[] getSupportedShapeFormats() {
        return new String[]{"obj"};
    }

    protected PShape loadShape(String filename, PParameters params) {
        return new PShape3D(this.parent, filename, (PShape3D.Parameters)params);
    }

    protected PShape createShape(int size, PParameters params) {
        return new PShape3D(this.parent, size, (PShape3D.Parameters)params);
    }

    protected PTexture getTexture(PImage img) {
        PTexture tex = (PTexture)img.getCache((PGraphics)this.pgl);
        if (tex == null) {
            tex = this.addTexture(img);
        } else if (img.isModified()) {
            this.updateTexture(img, tex);
        }
        return tex;
    }

    protected PTexture addTexture(PImage img) {
        PTexture.Parameters params = (PTexture.Parameters)img.getParams((PGraphics)this);
        if (params == null) {
            params = PTexture.newParameters();
            img.setParams((PGraphics)this, (PParameters)params);
        }
        PTexture tex = new PTexture(img.parent, img.width, img.height, params);
        img.loadPixels();
        tex.set(img.pixels);
        img.setCache((PGraphics)this, (PMetadata)tex);
        return tex;
    }

    protected void updateTexture(PImage img, PTexture tex) {
        if (tex != null) {
            int x = img.getModifiedX1();
            int y = img.getModifiedY1();
            int w = img.getModifiedX2() - x;
            int h = img.getModifiedY2() - y;
            tex.set(img.pixels, x, y, w, h, img.format);
        }
        img.setModified(false);
    }

    protected void drawTexture(PTexture tex, int x1, int y1, int w1, int h1, int x2, int y2, int w2, int h2) {
        int[] crop = new int[]{x1, y1, w1, h1};
        this.drawTexture(tex, crop, x2, y2, w2, h2);
    }

    protected void drawTexture(PTexture tex, int[] crop, int x, int y, int w, int h) {
        this.gl.glViewport(0, 0, w, h);
        this.gl2f.glMatrixMode(5889);
        this.gl2f.glPushMatrix();
        this.gl2f.glLoadIdentity();
        this.gl2f.glOrthof(0.0f, (float)w, 0.0f, (float)h, -1.0f, 1.0f);
        this.gl2f.glMatrixMode(5888);
        this.gl2f.glPushMatrix();
        this.gl2f.glLoadIdentity();
        this.gl.glEnable(tex.getGLTarget());
        this.gl.glBindTexture(tex.getGLTarget(), tex.getGLID());
        this.gl.glDepthMask(false);
        this.gl.glDisable(3042);
        this.gl2f.glTexEnvi(8960, 8704, 7681);
        this.gl2f.glTranslatef((float)x, (float)y, 0.0f);
        this.gl2f.glScalef((float)w, (float)h, 1.0f);
        this.renderTexQuad(crop[0] / w, crop[1] / h, (crop[0] + crop[2]) / w, (crop[1] + crop[3]) / h);
        this.gl2f.glTexEnvi(8960, 8704, 8448);
        this.gl.glBindTexture(tex.getGLTarget(), 0);
        this.gl.glDisable(tex.getGLTarget());
        if (this.hints[8]) {
            this.gl.glDepthMask(false);
        } else {
            this.gl.glDepthMask(true);
        }
        if (this.blend) {
            this.blend(this.blendMode);
        } else {
            this.noBlend();
        }
        this.gl.glViewport(0, 0, this.width, this.height);
        this.gl2f.glMatrixMode(5889);
        this.gl2f.glPopMatrix();
        this.gl2f.glMatrixMode(5888);
        this.gl2f.glPopMatrix();
    }

    protected void allocateTexQuad() {
        ByteBuffer vbb = ByteBuffer.allocateDirect(48);
        vbb.order(ByteOrder.nativeOrder());
        quadVertexBuffer = vbb.asFloatBuffer();
        ByteBuffer tbb = ByteBuffer.allocateDirect(32);
        tbb.order(ByteOrder.nativeOrder());
        quadTexCoordBuffer = tbb.asFloatBuffer();
        quadVertexBuffer.position(0);
        quadVertexBuffer.put(new float[]{0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.0f});
    }

    protected void renderTexQuad() {
        this.renderTexQuad(0.0f, 0.0f, 1.0f, 1.0f);
    }

    protected void renderTexQuad(float u0, float v0, float u1, float v1) {
        if (quadVertexBuffer == null) {
            this.allocateTexQuad();
        }
        quadTexCoordBuffer.position(0);
        quadTexCoordBuffer.put(new float[]{u0, v0, u0, v1, u1, v0, u1, v1});
        this.gl2f.glEnableClientState(32884);
        this.gl2f.glEnableClientState(32888);
        quadVertexBuffer.position(0);
        quadTexCoordBuffer.position(0);
        this.gl2f.glVertexPointer(3, 5126, 0, (Buffer)quadVertexBuffer);
        this.gl2f.glTexCoordPointer(2, 5126, 0, (Buffer)quadTexCoordBuffer);
        this.gl2f.glDrawArrays(5, 0, 12);
        this.gl2f.glDisableClientState(32888);
        this.gl2f.glDisableClientState(32884);
    }

    protected void copyToTexture(PTexture tex, IntBuffer buffer, int x, int y, int w, int h) {
        this.gl.glEnable(tex.getGLTarget());
        this.gl.glBindTexture(tex.getGLTarget(), tex.getGLID());
        this.gl.glTexSubImage2D(tex.getGLTarget(), 0, x, y, w, h, 6408, 5121, (Buffer)buffer);
        this.gl.glBindTexture(tex.getGLTarget(), 0);
        this.gl.glDisable(tex.getGLTarget());
    }

    protected void setSurfaceParams() {
        this.gl2f.glShadeModel(7425);
        this.gl2f.glEnable(2903);
        this.gl2f.glEnable(2977);
        this.gl2f.glEnable(32826);
        this.gl2f.glLightModelfv(2899, this.baseLight, 0);
        this.gl2f.glLightModelf(2898, 0.0f);
    }

    protected void saveGLMatrices() {
        this.gl2f.glMatrixMode(5889);
        this.gl2f.glPushMatrix();
        this.gl2f.glMatrixMode(5888);
        this.gl2f.glPushMatrix();
    }

    protected void restoreGLMatrices() {
        this.gl2f.glMatrixMode(5889);
        this.gl2f.glPopMatrix();
        this.gl2f.glMatrixMode(5888);
        this.gl2f.glPopMatrix();
    }

    protected void setDefNormals(float nx, float ny, float nz) {
        this.gl2f.glNormal3f(nx, ny, nz);
    }

    protected void initPrimary() {
        GLProfile.initSingleton((boolean)true);
        this.pgl = this;
        this.profile = null;
        this.profile = GLProfile.get((String)"GL2ES1");
        this.pipeline = 0;
        if (this.profile == null) {
            this.parent.die("Cannot get a valid OpenGL profile");
        }
        this.capabilities = new GLCapabilities(this.profile);
        if (!this.hints[1]) {
            this.capabilities.setSampleBuffers(true);
            this.capabilities.setNumSamples(2);
        } else if (this.hints[2]) {
            this.capabilities.setSampleBuffers(true);
            this.capabilities.setNumSamples(4);
        }
        AWTGraphicsScreen screen = (AWTGraphicsScreen)AWTGraphicsScreen.createDefault();
        AWTGraphicsConfiguration config = (AWTGraphicsConfiguration)GraphicsConfigurationFactory.getFactory(AWTGraphicsDevice.class).chooseGraphicsConfiguration((CapabilitiesImmutable)this.capabilities, (CapabilitiesImmutable)this.capabilities, null, (AbstractGraphicsScreen)screen);
        NativeWindow win = NativeWindowFactory.getNativeWindow((Object)this.parent, (AbstractGraphicsConfiguration)config);
        GLDrawableFactory factory = GLDrawableFactory.getFactory((GLProfile)this.profile);
        this.drawable = factory.createGLDrawable((NativeSurface)win);
        this.context = this.drawable.createContext(null);
    }

    protected void initOffscreen() {
        this.pgl = (PGraphicsOpenGL2)this.parent.g;
        this.context = this.pgl.getContext();
        this.capabilities = this.pgl.getCapabilities();
        this.drawable = null;
        this.getGLObjects();
        this.loadTextureImpl(3);
        if (this.offscreenFramebuffer != null) {
            this.offscreenFramebuffer.delete();
            this.offscreenFramebuffer = null;
        }
        if (this.offscreenFramebufferMultisample != null) {
            this.offscreenFramebufferMultisample.delete();
            this.offscreenFramebufferMultisample = null;
        }
        boolean opengl2X = !this.hints[1];
        boolean opengl4X = this.hints[2];
        this.offscreenMultisample = false;
        this.offscreenFramebuffer = new PFramebuffer(this.parent, this.texture.getGLWidth(), this.texture.getGLHeight(), false);
        if (fboMultisampleSupported && this.gl2x != null && (opengl2X || opengl4X)) {
            int nsamples = 1;
            if (opengl2X) {
                nsamples = 2;
            } else if (opengl4X) {
                nsamples = 4;
            }
            this.offscreenFramebufferMultisample = new PFramebuffer(this.parent, this.texture.getGLWidth(), this.texture.getGLHeight(), false);
            try {
                this.offscreenFramebufferMultisample.addColorBufferMultisample(nsamples);
                this.offscreenMultisample = true;
            }
            catch (GLException e) {
                PGraphics.showWarning((String)"Unable to create antialised offscreen surface.");
            }
        }
        if (this.offscreenMultisample) {
            if (this.offscreenDepthBits == 24 && this.offscreenStencilBits == 8) {
                this.offscreenFramebufferMultisample.addDepthStencilBuffer();
            } else {
                this.offscreenFramebufferMultisample.addDepthBuffer(this.offscreenDepthBits);
                if (this.offscreenStencilBits > 0) {
                    this.offscreenFramebufferMultisample.addStencilBuffer(this.offscreenStencilBits);
                }
            }
            this.offscreenFramebufferMultisample.clear();
            this.offscreenFramebuffer.setColorBuffer(this.texture);
        } else {
            this.offscreenFramebuffer.setColorBuffer(this.texture);
            if (this.offscreenDepthBits == 24 && this.offscreenStencilBits == 8) {
                this.offscreenFramebuffer.addDepthStencilBuffer();
            } else {
                this.offscreenFramebuffer.addDepthBuffer(this.offscreenDepthBits);
                if (this.offscreenStencilBits > 0) {
                    this.offscreenFramebuffer.addStencilBuffer(this.offscreenStencilBits);
                }
            }
        }
        this.offscreenFramebuffer.clear();
    }

    protected void getGLObjects() {
        this.gl = this.context.getGL();
        if (this.pipeline == 3) {
            this.gl4p = this.gl.getGL4();
            this.gl3p = this.gl4p;
            this.gl2p = this.gl4p;
            this.gl2f = null;
        } else if (this.pipeline == 2) {
            this.gl4p = null;
            this.gl3p = this.gl.getGL3();
            this.gl2p = this.gl3p;
            this.gl2f = null;
        } else if (this.pipeline == 1) {
            this.gl4p = null;
            this.gl3p = null;
            this.gl2p = this.gl.getGL2ES2();
            this.gl2f = null;
        } else if (this.pipeline == 0) {
            this.gl4p = null;
            this.gl3p = null;
            this.gl2p = null;
            this.gl2f = this.gl.getGL2ES1();
        }
        try {
            this.gl2x = this.gl.getGL2GL3();
        }
        catch (GLException gLException) {
            // empty catch block
        }
    }

    protected void getGLParameters() {
        OPENGL_VENDOR = this.gl.glGetString(7936);
        OPENGL_RENDERER = this.gl.glGetString(7937);
        OPENGL_VERSION = this.gl.glGetString(7938);
        npotTexSupported = false;
        mipmapGeneration = false;
        matrixGetSupported = false;
        texenvCrossbarSupported = false;
        vboSupported = false;
        fboSupported = false;
        fboMultisampleSupported = false;
        String extensions = this.gl.glGetString(7939);
        if (-1 < extensions.indexOf("texture_non_power_of_two")) {
            npotTexSupported = true;
        }
        if (-1 < extensions.indexOf("generate_mipmap")) {
            mipmapGeneration = true;
        }
        if (-1 < extensions.indexOf("matrix_get")) {
            matrixGetSupported = true;
        }
        if (-1 < extensions.indexOf("texture_env_crossbar")) {
            texenvCrossbarSupported = true;
        }
        if (-1 < extensions.indexOf("vertex_buffer_object")) {
            vboSupported = true;
        }
        if (-1 < extensions.indexOf("framebuffer_object")) {
            fboSupported = true;
        }
        if (-1 < extensions.indexOf("framebuffer_multisample")) {
            fboMultisampleSupported = true;
        }
        blendEqSupported = true;
        usingGLMatrixStack = !matrixGetSupported;
        int[] temp = new int[2];
        this.gl.glGetIntegerv(3379, temp, 0);
        maxTextureSize = temp[0];
        this.gl.glGetIntegerv(33902, temp, 0);
        maxLineWidth = temp[1];
        this.gl.glGetIntegerv(33901, temp, 0);
        maxPointSize = temp[1];
        this.gl.glGetIntegerv(34018, temp, 0);
        maxTextureUnits = PApplet.min((int)2, (int)temp[0]);
        glparamsRead = true;
    }

    protected class DrawingState {
        int tMode0;
        boolean auto0;
        boolean stroke0;
        int cMode0;
        boolean merge0;
        float specularR0;
        float specularG0;
        float specularB0;
        float ambientR0;
        float ambientG0;
        float ambientB0;
        boolean fill0;
        float fillR0;
        float fillG0;
        float fillB0;
        float fillA0;
        int fillRi0;
        int fillGi0;
        int fillBi0;
        int fillAi0;
        int fillColor0;
        boolean fillAlpha0;
        boolean tint0;
        float tintR0;
        float tintG0;
        float tintB0;
        float tintA0;
        int tintRi0;
        int tintGi0;
        int tintBi0;
        int tintAi0;
        int tintColor0;
        boolean tintAlpha0;
        float shininess0;

        DrawingState() {
        }

        void save() {
            this.tMode0 = PGraphicsOpenGL2.this.textureMode;
            this.auto0 = PGraphicsOpenGL2.this.autoNormal;
            this.stroke0 = PGraphicsOpenGL2.this.stroke;
            this.cMode0 = PGraphicsOpenGL2.this.colorMode;
            this.merge0 = PGraphicsOpenGL2.this.mergeRecShapes;
            this.specularR0 = PGraphicsOpenGL2.this.specularR;
            this.specularG0 = PGraphicsOpenGL2.this.specularG;
            this.specularB0 = PGraphicsOpenGL2.this.specularB;
            this.ambientR0 = PGraphicsOpenGL2.this.ambientR;
            this.ambientG0 = PGraphicsOpenGL2.this.ambientG;
            this.ambientB0 = PGraphicsOpenGL2.this.ambientB;
            this.fill0 = PGraphicsOpenGL2.this.fill;
            this.fillR0 = PGraphicsOpenGL2.this.fillR;
            this.fillG0 = PGraphicsOpenGL2.this.fillG;
            this.fillB0 = PGraphicsOpenGL2.this.fillB;
            this.fillA0 = PGraphicsOpenGL2.this.fillA;
            this.fillRi0 = PGraphicsOpenGL2.this.fillRi;
            this.fillGi0 = PGraphicsOpenGL2.this.fillGi;
            this.fillBi0 = PGraphicsOpenGL2.this.fillBi;
            this.fillAi0 = PGraphicsOpenGL2.this.fillAi;
            this.fillColor0 = PGraphicsOpenGL2.this.fillColor;
            this.fillAlpha0 = PGraphicsOpenGL2.this.fillAlpha;
            this.tint0 = PGraphicsOpenGL2.this.tint;
            this.tintR0 = PGraphicsOpenGL2.this.tintR;
            this.tintG0 = PGraphicsOpenGL2.this.tintG;
            this.tintB0 = PGraphicsOpenGL2.this.tintB;
            this.tintA0 = PGraphicsOpenGL2.this.tintA;
            this.tintRi0 = PGraphicsOpenGL2.this.tintRi;
            this.tintGi0 = PGraphicsOpenGL2.this.tintGi;
            this.tintBi0 = PGraphicsOpenGL2.this.tintBi;
            this.tintAi0 = PGraphicsOpenGL2.this.tintAi;
            this.tintColor0 = PGraphicsOpenGL2.this.tintColor;
            this.tintAlpha0 = PGraphicsOpenGL2.this.tintAlpha;
            this.shininess0 = PGraphicsOpenGL2.this.shininess;
        }

        void restore() {
            PGraphicsOpenGL2.this.textureMode = this.tMode0;
            PGraphicsOpenGL2.this.colorMode = this.cMode0;
            PGraphicsOpenGL2.this.autoNormal = this.auto0;
            PGraphicsOpenGL2.this.stroke = this.stroke0;
            PGraphicsOpenGL2.this.mergeRecShapes = this.merge0;
            PGraphicsOpenGL2.this.calcR = this.specularR0;
            PGraphicsOpenGL2.this.calcG = this.specularG0;
            PGraphicsOpenGL2.this.calcB = this.specularB0;
            PGraphicsOpenGL2.this.specularFromCalc();
            PGraphicsOpenGL2.this.calcR = this.ambientR0;
            PGraphicsOpenGL2.this.calcG = this.ambientG0;
            PGraphicsOpenGL2.this.calcB = this.ambientB0;
            PGraphicsOpenGL2.this.ambientFromCalc();
            if (!this.fill0) {
                PGraphicsOpenGL2.this.noFill();
            } else {
                PGraphicsOpenGL2.this.calcR = this.fillR0;
                PGraphicsOpenGL2.this.calcG = this.fillG0;
                PGraphicsOpenGL2.this.calcB = this.fillB0;
                PGraphicsOpenGL2.this.calcA = this.fillA0;
                PGraphicsOpenGL2.this.calcRi = this.fillRi0;
                PGraphicsOpenGL2.this.calcGi = this.fillGi0;
                PGraphicsOpenGL2.this.calcBi = this.fillBi0;
                PGraphicsOpenGL2.this.calcAi = this.fillAi0;
                PGraphicsOpenGL2.this.calcColor = this.fillColor0;
                PGraphicsOpenGL2.this.calcAlpha = this.fillAlpha0;
                PGraphicsOpenGL2.this.fillFromCalc();
            }
            if (!this.tint0) {
                PGraphicsOpenGL2.this.noTint();
            } else {
                PGraphicsOpenGL2.this.calcR = this.tintR0;
                PGraphicsOpenGL2.this.calcG = this.tintG0;
                PGraphicsOpenGL2.this.calcB = this.tintB0;
                PGraphicsOpenGL2.this.calcA = this.tintA0;
                PGraphicsOpenGL2.this.calcRi = this.tintRi0;
                PGraphicsOpenGL2.this.calcGi = this.tintGi0;
                PGraphicsOpenGL2.this.calcBi = this.tintBi0;
                PGraphicsOpenGL2.this.calcAi = this.tintAi0;
                PGraphicsOpenGL2.this.calcColor = this.tintColor0;
                PGraphicsOpenGL2.this.calcAlpha = this.tintAlpha0;
                PGraphicsOpenGL2.this.tintFromCalc();
            }
            PGraphicsOpenGL2.this.shininess(this.shininess0);
        }
    }

    protected class GLMatrixStack {
        protected Stack<float[]> matrixStack = new Stack();
        protected float[] current = new float[16];

        public GLMatrixStack() {
            this.set(1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);
        }

        public void push() {
            float[] mat = new float[16];
            PApplet.arrayCopy((Object)this.current, (Object)mat);
            this.matrixStack.push(mat);
        }

        public void pop() {
            try {
                float[] mat = this.matrixStack.pop();
                PApplet.arrayCopy((Object)mat, (Object)this.current);
            }
            catch (EmptyStackException e) {
                PGraphics.showWarning((String)"OPENGL2: Empty modelview stack");
            }
        }

        public void mult(float[] mat) {
            this.mult(mat[0], mat[4], mat[8], mat[12], mat[1], mat[5], mat[9], mat[13], mat[2], mat[6], mat[10], mat[14], mat[3], mat[7], mat[11], mat[15]);
        }

        public void mult(float n0, float n4, float n8, float n12, float n1, float n5, float n9, float n13, float n2, float n6, float n10, float n14, float n3, float n7, float n11, float n15) {
            float r0 = this.current[0] * n0 + this.current[4] * n1 + this.current[8] * n2 + this.current[12] * n3;
            float r4 = this.current[0] * n4 + this.current[4] * n5 + this.current[8] * n6 + this.current[12] * n7;
            float r8 = this.current[0] * n8 + this.current[4] * n9 + this.current[8] * n10 + this.current[12] * n11;
            float r12 = this.current[0] * n12 + this.current[4] * n13 + this.current[8] * n14 + this.current[12] * n15;
            float r1 = this.current[1] * n0 + this.current[5] * n1 + this.current[9] * n2 + this.current[13] * n3;
            float r5 = this.current[1] * n4 + this.current[5] * n5 + this.current[9] * n6 + this.current[13] * n7;
            float r9 = this.current[1] * n8 + this.current[5] * n8 + this.current[9] * n10 + this.current[13] * n11;
            float r13 = this.current[1] * n12 + this.current[5] * n13 + this.current[9] * n14 + this.current[13] * n15;
            float r2 = this.current[2] * n0 + this.current[6] * n1 + this.current[10] * n2 + this.current[14] * n3;
            float r6 = this.current[2] * n4 + this.current[6] * n5 + this.current[10] * n6 + this.current[14] * n7;
            float r10 = this.current[2] * n8 + this.current[6] * n9 + this.current[10] * n10 + this.current[14] * n11;
            float r14 = this.current[2] * n12 + this.current[6] * n13 + this.current[10] * n14 + this.current[14] * n15;
            float r3 = this.current[3] * n0 + this.current[7] * n1 + this.current[11] * n2 + this.current[15] * n3;
            float r7 = this.current[3] * n4 + this.current[7] * n5 + this.current[11] * n6 + this.current[15] * n7;
            float r11 = this.current[3] * n8 + this.current[7] * n9 + this.current[11] * n10 + this.current[15] * n11;
            float r15 = this.current[3] * n12 + this.current[7] * n13 + this.current[11] * n14 + this.current[15] * n15;
            this.current[0] = r0;
            this.current[4] = r4;
            this.current[8] = r8;
            this.current[12] = r12;
            this.current[1] = r1;
            this.current[5] = r5;
            this.current[9] = r9;
            this.current[13] = r13;
            this.current[2] = r2;
            this.current[6] = r6;
            this.current[10] = r10;
            this.current[14] = r14;
            this.current[3] = r3;
            this.current[7] = r7;
            this.current[11] = r11;
            this.current[15] = r15;
        }

        public void get(float[] mat) {
            PApplet.arrayCopy((Object)this.current, (Object)mat);
        }

        public void set(float[] mat) {
            PApplet.arrayCopy((Object)mat, (Object)this.current);
        }

        public void set(float n0, float n4, float n8, float n12, float n1, float n5, float n9, float n13, float n2, float n6, float n10, float n14, float n3, float n7, float n11, float n15) {
            this.current[0] = n0;
            this.current[4] = n4;
            this.current[8] = n8;
            this.current[12] = n12;
            this.current[1] = n1;
            this.current[5] = n5;
            this.current[9] = n9;
            this.current[13] = n13;
            this.current[2] = n2;
            this.current[6] = n6;
            this.current[10] = n10;
            this.current[14] = n14;
            this.current[3] = n3;
            this.current[7] = n7;
            this.current[11] = n11;
            this.current[15] = n15;
        }

        public void translate(float tx, float ty, float tz) {
            this.current[12] = this.current[12] + (tx * this.current[0] + ty * this.current[4] + tz * this.current[8]);
            this.current[13] = this.current[13] + (tx * this.current[1] + ty * this.current[5] + tz * this.current[9]);
            this.current[14] = this.current[14] + (tx * this.current[2] + ty * this.current[6] + tz * this.current[10]);
            this.current[15] = this.current[15] + (tx * this.current[3] + ty * this.current[7] + tz * this.current[11]);
        }

        public void rotate(float angle, float rx, float ry, float rz) {
            float c = PApplet.cos((float)angle);
            float s = PApplet.sin((float)angle);
            float t = 1.0f - c;
            this.mult(t * rx * rx + c, t * rx * ry - s * rz, t * rx * rz + s * ry, 0.0f, t * rx * ry + s * rz, t * ry * ry + c, t * ry * rz - s * rx, 0.0f, t * rx * rz - s * ry, t * ry * rz + s * rx, t * rz * rz + c, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);
        }

        public void scale(float sx, float sy, float sz) {
            this.current[0] = this.current[0] * sx;
            this.current[4] = this.current[4] * sy;
            this.current[8] = this.current[8] * sz;
            this.current[1] = this.current[1] * sx;
            this.current[5] = this.current[5] * sy;
            this.current[9] = this.current[9] * sz;
            this.current[2] = this.current[2] * sx;
            this.current[6] = this.current[6] * sy;
            this.current[10] = this.current[10] * sz;
            this.current[3] = this.current[3] * sx;
            this.current[7] = this.current[7] * sy;
            this.current[11] = this.current[11] * sz;
        }
    }
}

