/*
 * Decompiled with CFR 0.152.
 */
package processing.opengl2;

import java.nio.Buffer;
import java.nio.IntBuffer;
import java.util.Arrays;
import javax.media.opengl.GL;
import processing.core.PApplet;
import processing.core.PConstants;
import processing.core.PGraphics;
import processing.core.PImage;
import processing.core.PMetadata;
import processing.core.PParameters;
import processing.opengl2.PFramebuffer;
import processing.opengl2.PGraphicsOpenGL2;

public class PTexture
extends PMetadata
implements PConstants {
    public int width;
    public int height;
    protected PApplet parent;
    protected PGraphicsOpenGL2 pgl;
    protected GL gl;
    protected int glID;
    protected int glTarget;
    protected int glFormat;
    protected int glMinFilter;
    protected int glMagFilter;
    protected int glWrapS;
    protected int glWrapT;
    protected int glWidth;
    protected int glHeight;
    protected boolean usingMipmaps;
    protected float maxTexCoordU;
    protected float maxTexCoordV;
    protected boolean flippedX;
    protected boolean flippedY;
    protected int[] tempPixels = null;
    protected PFramebuffer tempFbo = null;

    public PTexture(PApplet parent, int width, int height) {
        this(parent, width, height, new Parameters());
    }

    public PTexture(PApplet parent, int width, int height, PParameters params) {
        this.parent = parent;
        this.width = width;
        this.height = height;
        this.pgl = (PGraphicsOpenGL2)parent.g;
        this.gl = this.pgl.gl;
        this.glID = 0;
        this.setParameters((Parameters)params);
        this.createTexture(width, height);
    }

    public PTexture(PApplet parent, String filename) {
        this(parent, filename, new Parameters());
    }

    public PTexture(PApplet parent, String filename, PParameters params) {
        this.parent = parent;
        this.pgl = (PGraphicsOpenGL2)parent.g;
        this.gl = this.pgl.gl;
        this.glID = 0;
        PImage img = parent.loadImage(filename);
        this.setParameters((Parameters)params);
        this.set(img);
    }

    public void delete() {
        this.deleteTexture();
    }

    public void init(int width, int height) {
        this.init(width, height, new Parameters());
    }

    public void init(int width, int height, Parameters params) {
        this.width = width;
        this.height = height;
        this.setParameters(params);
        this.createTexture(width, height);
    }

    public void resize(int wide, int high) {
        PTexture tex = new PTexture(this.parent, wide, high, this.getParameters());
        tex.set(this);
        this.delete();
        this.copyObject(tex);
        this.tempPixels = null;
        this.tempFbo = null;
    }

    public boolean available() {
        return this.glID > 0;
    }

    public void set(PImage img) {
        PTexture tex = (PTexture)img.getCache((PGraphics)this.pgl);
        this.set(tex);
    }

    public void set(PImage img, int x, int y, int w, int h) {
        PTexture tex = (PTexture)img.getCache((PGraphics)this.pgl);
        this.set(tex, x, y, w, h);
    }

    public void set(PTexture tex) {
        this.copyTexels(tex, 0, 0, tex.width, tex.height, true);
    }

    public void set(PTexture tex, int x, int y, int w, int h) {
        this.copyTexels(tex, x, y, w, h, true);
    }

    public void set(int[] pixels) {
        this.set(pixels, 0, 0, this.width, this.height, 2);
    }

    public void set(int[] pixels, int format) {
        this.set(pixels, 0, 0, this.width, this.height, format);
    }

    public void set(int[] pixels, int x, int y, int w, int h) {
        this.set(pixels, x, y, w, h, 2);
    }

    public void set(int[] pixels, int x, int y, int w, int h, int format) {
        if (pixels == null) {
            throw new RuntimeException("PTexture: null pixels array");
        }
        if (pixels.length != w * h) {
            throw new RuntimeException("PTexture: wrong length of pixels array");
        }
        if (this.glID == 0) {
            this.createTexture(this.width, this.height);
        }
        this.gl.glEnable(this.glTarget);
        this.gl.glBindTexture(this.glTarget, this.glID);
        if (this.usingMipmaps) {
            if (PGraphicsOpenGL2.mipmapGeneration) {
                int[] rgbaPixels = new int[w * h];
                this.convertToRGBA(pixels, rgbaPixels, format, w, h);
                this.gl.glTexParameteri(3553, 33169, 1);
                this.setTexels(x, y, w, h, rgbaPixels);
            }
        } else {
            int[] rgbaPixels = new int[w * h];
            this.convertToRGBA(pixels, rgbaPixels, format, w, h);
            this.setTexels(x, y, w, h, rgbaPixels);
        }
        this.gl.glBindTexture(this.glTarget, 0);
        this.gl.glDisable(this.glTarget);
    }

    public void get(int[] pixels) {
        if (pixels == null || pixels.length != this.width * this.height) {
            pixels = new int[this.width * this.height];
        }
        int size = this.glWidth * this.glHeight;
        if (this.tempFbo == null) {
            this.tempFbo = new PFramebuffer(this.parent, this.glWidth, this.glHeight);
        }
        if (PGraphicsOpenGL2.fboSupported) {
            this.tempFbo.setColorBuffer(this);
            this.pgl.pushFramebuffer();
            this.pgl.setFramebuffer(this.tempFbo);
            this.tempFbo.readPixels();
            this.pgl.popFramebuffer();
        } else {
            this.pgl.pushFramebuffer();
            this.pgl.setFramebuffer(this.tempFbo);
            this.pgl.drawTexture(this, 0, 0, this.glWidth, this.glHeight, 0, 0, this.glWidth, this.glHeight);
            this.tempFbo.readPixels();
            this.pgl.popFramebuffer();
        }
        if (this.tempPixels == null) {
            this.tempPixels = new int[size];
        }
        this.tempFbo.getPixels(this.tempPixels);
        this.convertToARGB(this.tempPixels, pixels);
        if (this.flippedX) {
            this.flipArrayOnX(pixels, 1);
        }
        if (this.flippedY) {
            this.flipArrayOnY(pixels, 1);
        }
    }

    public void put(PTexture tex) {
        this.copyTexels(tex, 0, 0, tex.width, tex.height, false);
    }

    public void put(PTexture tex, int x, int y, int w, int h) {
        this.copyTexels(tex, x, y, w, h, false);
    }

    protected int getGLWidth() {
        return this.glWidth;
    }

    protected int getGLHeight() {
        return this.glHeight;
    }

    protected int getGLID() {
        return this.glID;
    }

    protected int getGLTarget() {
        return this.glTarget;
    }

    protected int getGLFormat() {
        return this.glFormat;
    }

    protected int getGLMinFilter() {
        return this.glMinFilter;
    }

    protected int getGLMagFilter() {
        return this.glMagFilter;
    }

    protected int getGLWrapS() {
        return this.glWrapS;
    }

    protected int getGLWrapT() {
        return this.glWrapT;
    }

    protected boolean usingMipmaps() {
        return this.usingMipmaps;
    }

    protected float getMaxTexCoordU() {
        return this.maxTexCoordU;
    }

    protected float getMaxTexCoordV() {
        return this.maxTexCoordV;
    }

    protected boolean isFlippedX() {
        return this.flippedX;
    }

    protected void setFlippedX(boolean v) {
        this.flippedX = v;
    }

    protected boolean isFlippedY() {
        return this.flippedY;
    }

    public void setFlippedY(boolean v) {
        this.flippedY = v;
    }

    private int nextPowerOfTwo(int val) {
        int ret = 1;
        while (ret < val) {
            ret <<= 1;
        }
        return ret;
    }

    protected void flipArrayOnX(int[] intArray, int mult) {
        int index = 0;
        int xindex = mult * (this.width - 1);
        int x = 0;
        while (x < this.width / 2) {
            int y = 0;
            while (y < this.height) {
                int i = index + mult * y * this.width;
                int j = xindex + mult * y * this.width;
                int c = 0;
                while (c < mult) {
                    int temp = intArray[i];
                    intArray[i] = intArray[j];
                    intArray[j] = temp;
                    ++i;
                    ++j;
                    ++c;
                }
                ++y;
            }
            index += mult;
            xindex -= mult;
            ++x;
        }
    }

    protected void flipArrayOnY(int[] intArray, int mult) {
        int index = 0;
        int yindex = mult * (this.height - 1) * this.width;
        int y = 0;
        while (y < this.height / 2) {
            int x = 0;
            while (x < mult * this.width) {
                int temp = intArray[index];
                intArray[index] = intArray[yindex];
                intArray[yindex] = temp;
                ++index;
                ++yindex;
                ++x;
            }
            yindex -= mult * this.width * 2;
            ++y;
        }
    }

    protected void convertToRGBA(int[] intArray, int[] tIntArray, int arrayFormat, int w, int h) {
        block17: {
            block16: {
                if (!PGraphicsOpenGL2.BIG_ENDIAN) break block16;
                switch (arrayFormat) {
                    case 4: {
                        int i = 0;
                        while (i < intArray.length) {
                            tIntArray[i] = 0xFFFFFF00 | intArray[i];
                            ++i;
                        }
                        break block17;
                    }
                    case 1: {
                        int i = 0;
                        while (i < intArray.length) {
                            int pixel = intArray[i];
                            tIntArray[i] = pixel << 8 | 0xFF;
                            ++i;
                        }
                        break block17;
                    }
                    case 2: {
                        int i = 0;
                        while (i < intArray.length) {
                            int pixel = intArray[i];
                            tIntArray[i] = pixel << 8 | pixel >> 24 & 0xFF;
                            ++i;
                        }
                        break block0;
                    }
                }
                break block17;
            }
            switch (arrayFormat) {
                case 4: {
                    int i = 0;
                    while (i < intArray.length) {
                        tIntArray[i] = intArray[i] << 24 | 0xFFFFFF;
                        ++i;
                    }
                    break;
                }
                case 1: {
                    int i = 0;
                    while (i < intArray.length) {
                        int pixel = intArray[i];
                        tIntArray[i] = 0xFF000000 | (pixel & 0xFF) << 16 | (pixel & 0xFF0000) >> 16 | pixel & 0xFF00;
                        ++i;
                    }
                    break;
                }
                case 2: {
                    int i = 0;
                    while (i < intArray.length) {
                        int pixel = intArray[i];
                        tIntArray[i] = (pixel & 0xFF) << 16 | (pixel & 0xFF0000) >> 16 | pixel & 0xFF00FF00;
                        ++i;
                    }
                    break;
                }
            }
        }
    }

    protected void convertToARGB(int[] intArray, int[] tIntArray, int arrayFormat) {
        int t = 0;
        int p = 0;
        switch (arrayFormat) {
            case 4: {
                int y = 0;
                while (y < this.height) {
                    int x = 0;
                    while (x < this.width) {
                        int pixel = intArray[p++];
                        tIntArray[t++] = pixel << 24 & 0xFF000000;
                        ++x;
                    }
                    t += this.glWidth - this.width;
                    ++y;
                }
                break;
            }
            case 1: {
                int y = 0;
                while (y < this.height) {
                    int x = 0;
                    while (x < this.width) {
                        int pixel = intArray[p++];
                        tIntArray[t++] = pixel | 0xFF000000;
                        ++x;
                    }
                    t += this.glWidth - this.width;
                    ++y;
                }
                break;
            }
            case 2: {
                int y = 0;
                while (y < this.height) {
                    PApplet.arrayCopy((Object)intArray, (int)(this.width * y), (Object)tIntArray, (int)(this.glWidth * y), (int)this.width);
                    ++y;
                }
                break;
            }
        }
    }

    protected void convertToARGB(int[] intArray, int[] tIntArray) {
        int t = 0;
        int p = 0;
        if (PGraphicsOpenGL2.BIG_ENDIAN) {
            int y = 0;
            while (y < this.height) {
                int x = 0;
                while (x < this.width) {
                    int pixel = intArray[p++];
                    tIntArray[t++] = pixel >> 8 | pixel << 24 & 0xFF000000;
                    ++x;
                }
                p += this.glWidth - this.width;
                ++y;
            }
        } else {
            int y = 0;
            while (y < this.height) {
                int x = 0;
                while (x < this.width) {
                    int pixel = intArray[p++];
                    tIntArray[t++] = (pixel & 0xFF) << 16 | (pixel & 0xFF0000) >> 16 | pixel & 0xFF00FF00;
                    ++x;
                }
                p += this.glWidth - this.width;
                ++y;
            }
        }
    }

    protected void createTexture(int w, int h) {
        this.deleteTexture();
        if (PGraphicsOpenGL2.npotTexSupported) {
            this.glWidth = w;
            this.glHeight = h;
        } else {
            this.glWidth = this.nextPowerOfTwo(w);
            this.glHeight = this.nextPowerOfTwo(h);
        }
        if (this.glWidth > PGraphicsOpenGL2.maxTextureSize || this.glHeight > PGraphicsOpenGL2.maxTextureSize) {
            this.glHeight = 0;
            this.glWidth = 0;
            throw new RuntimeException("Image width and height cannot be larger than " + PGraphicsOpenGL2.maxTextureSize + " with this graphics card.");
        }
        this.usingMipmaps = this.glMinFilter == 9987;
        this.gl.glEnable(this.glTarget);
        this.glID = this.pgl.createGLResource(0);
        this.gl.glBindTexture(this.glTarget, this.glID);
        this.gl.glTexParameteri(this.glTarget, 10241, this.glMinFilter);
        this.gl.glTexParameteri(this.glTarget, 10240, this.glMagFilter);
        this.gl.glTexParameteri(this.glTarget, 10242, this.glWrapS);
        this.gl.glTexParameteri(this.glTarget, 10243, this.glWrapT);
        int[] initArray = new int[this.glWidth * this.glHeight];
        Arrays.fill(initArray, 0, this.glWidth * this.glHeight, 0);
        this.gl.glTexImage2D(this.glTarget, 0, this.glFormat, this.glWidth, this.glHeight, 0, 6408, 5121, (Buffer)IntBuffer.wrap(initArray));
        this.gl.glBindTexture(this.glTarget, 0);
        this.gl.glDisable(this.glTarget);
        this.flippedX = false;
        this.flippedY = false;
        this.maxTexCoordU = (float)w / (float)this.glWidth;
        this.maxTexCoordV = (float)h / (float)this.glHeight;
    }

    protected void deleteTexture() {
        if (this.glID != 0) {
            this.pgl.deleteGLResource(this.glID, 0);
            this.glID = 0;
        }
    }

    protected void copyTexels(PTexture tex, int x, int y, int w, int h, boolean scale) {
        if (tex == null) {
            throw new RuntimeException("PTexture: source texture is null");
        }
        if (this.tempFbo == null) {
            this.tempFbo = new PFramebuffer(this.parent, this.glWidth, this.glHeight);
        }
        this.tempFbo.setColorBuffer(this);
        this.tempFbo.disableDepthTest();
        this.pgl.pushFramebuffer();
        this.pgl.setFramebuffer(this.tempFbo);
        if (scale) {
            this.pgl.drawTexture(tex, x, y, w, h, 0, 0, this.width, this.height);
        } else {
            this.pgl.drawTexture(tex, x, y, w, h, x, y, w, h);
        }
        this.pgl.popFramebuffer();
    }

    protected void setTexels(int x, int y, int w, int h, int[] pix) {
        this.setTexels(0, x, y, w, h, pix);
    }

    protected void setTexels(int level, int x, int y, int w, int h, int[] pix) {
        this.gl.glTexSubImage2D(this.glTarget, 0, x, y, w, h, 6408, 5121, (Buffer)IntBuffer.wrap(pix));
    }

    protected void bind() {
        this.gl.glEnable(this.glTarget);
        this.gl.glBindTexture(this.glTarget, this.glID);
    }

    protected void unbind() {
        this.gl.glEnable(this.glTarget);
        this.gl.glBindTexture(this.glTarget, 0);
    }

    protected void copyObject(PTexture src) {
        this.deleteTexture();
        this.width = src.width;
        this.height = src.height;
        this.parent = src.parent;
        this.pgl = src.pgl;
        this.gl = src.gl;
        this.glID = src.glID;
        this.glTarget = src.glTarget;
        this.glFormat = src.glFormat;
        this.glMinFilter = src.glMinFilter;
        this.glMagFilter = src.glMagFilter;
        this.glWidth = src.glWidth;
        this.glHeight = src.glHeight;
        this.usingMipmaps = src.usingMipmaps;
        this.maxTexCoordU = src.maxTexCoordU;
        this.maxTexCoordV = src.maxTexCoordV;
        this.flippedX = src.flippedX;
        this.flippedY = src.flippedY;
    }

    public Parameters getParameters() {
        Parameters res = new Parameters();
        if (this.glTarget == 3553) {
            res.target = 0;
        }
        if (this.glFormat == 6407) {
            res.format = 1;
        } else if (this.glFormat == 6408) {
            res.format = 2;
        } else if (this.glFormat == 6406) {
            res.format = 4;
        }
        if (this.glMinFilter == 9728) {
            res.sampling = 2;
        } else if (this.glMinFilter == 9729) {
            res.sampling = 3;
        } else if (this.glMinFilter == 9987) {
            res.sampling = 4;
        }
        if (this.glWrapS == 33071) {
            res.wrapU = 0;
        } else if (this.glWrapS == 10497) {
            res.wrapU = 1;
        }
        if (this.glWrapT == 33071) {
            res.wrapV = 0;
        } else if (this.glWrapT == 10497) {
            res.wrapV = 1;
        }
        return res;
    }

    protected void setParameters(Parameters params) {
        if (params.target != 0) {
            throw new RuntimeException("GTexture: Unknown texture target");
        }
        this.glTarget = 3553;
        if (params.format == 1) {
            this.glFormat = 6407;
        } else if (params.format == 2) {
            this.glFormat = 6408;
        } else if (params.format == 4) {
            this.glFormat = 6406;
        } else {
            throw new RuntimeException("GTexture: Unknown texture format");
        }
        if (params.sampling == 2) {
            this.glMagFilter = 9728;
            this.glMinFilter = 9728;
        } else if (params.sampling == 3) {
            this.glMagFilter = 9729;
            this.glMinFilter = 9729;
        } else if (params.sampling == 4) {
            this.glMagFilter = 9729;
            this.glMinFilter = 9987;
        } else {
            throw new RuntimeException("GTexture: Unknown texture filtering mode");
        }
        if (params.wrapU == 0) {
            this.glWrapS = 33071;
        } else if (params.wrapU == 1) {
            this.glWrapS = 10497;
        } else {
            throw new RuntimeException("GTexture: Unknown wrapping mode");
        }
        if (params.wrapV == 0) {
            this.glWrapT = 33071;
        } else if (params.wrapV == 1) {
            this.glWrapT = 10497;
        } else {
            throw new RuntimeException("GTexture: Unknown wrapping mode");
        }
    }

    public static Parameters newParameters() {
        return new Parameters();
    }

    public static Parameters newParameters(int format) {
        return new Parameters(format);
    }

    public static Parameters newParameters(int format, int sampling) {
        return new Parameters(format, sampling);
    }

    public static Parameters newParameters(Parameters params) {
        return new Parameters(params);
    }

    public static class Parameters
    extends PParameters {
        public int target;
        public int format;
        public int sampling;
        public int wrapU;
        public int wrapV;

        public Parameters() {
            this.target = 0;
            this.format = 2;
            this.sampling = 3;
            this.wrapU = 0;
            this.wrapV = 0;
        }

        public Parameters(int format) {
            this.target = 0;
            this.format = format;
            this.sampling = 3;
            this.wrapU = 0;
            this.wrapV = 0;
        }

        public Parameters(int format, int sampling) {
            this.target = 0;
            this.format = format;
            this.sampling = sampling;
            this.wrapU = 0;
            this.wrapV = 0;
        }

        public Parameters(Parameters src) {
            this.target = src.target;
            this.format = src.format;
            this.sampling = src.sampling;
            this.wrapU = src.wrapU;
            this.wrapV = src.wrapV;
        }

        public void set(int format) {
            this.format = format;
        }

        public void set(int format, int sampling) {
            this.format = format;
            this.sampling = sampling;
        }

        public void set(Parameters src) {
            this.target = src.target;
            this.format = src.format;
            this.sampling = src.sampling;
            this.wrapU = src.wrapU;
            this.wrapV = src.wrapV;
        }
    }
}

