/*
 * $Id: SimpleTutorial.java,v 1.18 2005/07/08 19:55:08 cxh Exp $
 *
 @Copyright (c) 1998-2005 The Regents of the University of California.
 All rights reserved.

 Permission is hereby granted, without written agreement and without
 license or royalty fees, to use, copy, modify, and distribute this
 software and its documentation for any purpose, provided that the
 above copyright notice and the following two paragraphs appear in all
 copies of this software.

 IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY
 FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES
 ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF
 THE UNIVERSITY OF CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF
 SUCH DAMAGE.

 THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
 INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE
 PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE UNIVERSITY OF
 CALIFORNIA HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT, UPDATES,
 ENHANCEMENTS, OR MODIFICATIONS.

 PT_COPYRIGHT_VERSION_2
 COPYRIGHTENDKEY




 */
package diva.graph.tutorial;

import javax.swing.SwingUtilities;

import diva.graph.GraphPane;
import diva.graph.JGraph;
import diva.graph.basic.BasicGraphController;
import diva.graph.basic.BasicGraphModel;
import diva.gui.AppContext;
import diva.gui.BasicFrame;

/**
 * This is the most basic tutorial, popping up an empty graph
 * editing window.  Control-click to add nodes,
 * select a node and control-drag to create new edges.
 *
 * @author Michael Shilman
 * @version $Id: SimpleTutorial.java,v 1.18 2005/07/08 19:55:08 cxh Exp $
 * @Pt.AcceptedRating Red
 */
public class SimpleTutorial {
    /**
     * Pop up an empty graph editing window.
     */
    public static void main(String[] argv) {
        final AppContext context = new BasicFrame("Simple Tutorial");
        SwingUtilities.invokeLater(new Runnable() {
            public void run() {
                new SimpleTutorial(context);
                context.setVisible(true);
            }
        });
    }

    public SimpleTutorial(AppContext context) {
        JGraph jg = new JGraph(new GraphPane(new BasicGraphController(),
                new BasicGraphModel()));
        context.getContentPane().add("Center", jg);
    }
}
