/* Marker interface for receivers that have state semantics.

 Copyright (c) 2004-2006 The Regents of the University of California.
 All rights reserved.
 Permission is hereby granted, without written agreement and without
 license or royalty fees, to use, copy, modify, and distribute this
 software and its documentation for any purpose, provided that the above
 copyright notice and the following two paragraphs appear in all copies
 of this software.

 IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY
 FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES
 ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF
 THE UNIVERSITY OF CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF
 SUCH DAMAGE.

 THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
 INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE
 PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE UNIVERSITY OF
 CALIFORNIA HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT, UPDATES,
 ENHANCEMENTS, OR MODIFICATIONS.

 PT_COPYRIGHT_VERSION_2
 COPYRIGHTENDKEY

 */
package ptolemy.actor;

//////////////////////////////////////////////////////////////////////////
//// StateReceiver

/**
 This is a marker interface for receivers that have <i>state</i> semantics.
 That is, whenever a get method is called on this receiver, the
 current token is always available and returned. Further more, if
 no put method is called between get methods, the returned tokens are
 always the same. Usually, the receivers that implement this interface
 have capacity of 1.
 <p>
 Receivers that do not implement this marker interface have <i>event</i>
 semantics, which means that when a get method is called on the receiver,
 the current token is returned and it is also removed from the receiver.

 @see ptolemy.domains.giotto.kernel.GiottoReceiver
 @author Haiyang Zheng
 @version $Id: StateReceiver.java,v 1.12 2006/08/21 23:12:42 cxh Exp $
 @since Ptolemy II 4.1
 @Pt.ProposedRating Yellow (hyzheng)
 @Pt.AcceptedRating Red (hyzheng)
 */
public interface StateReceiver {
}
