/* Interface for directors that can directs timed actors.

 Copyright (c) 2004-2005 The Regents of the University of California.
 All rights reserved.
 Permission is hereby granted, without written agreement and without
 license or royalty fees, to use, copy, modify, and distribute this
 software and its documentation for any purpose, provided that the above
 copyright notice and the following two paragraphs appear in all copies
 of this software.

 IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY
 FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES
 ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF
 THE UNIVERSITY OF CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF
 SUCH DAMAGE.

 THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
 INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE
 PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE UNIVERSITY OF
 CALIFORNIA HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT, UPDATES,
 ENHANCEMENTS, OR MODIFICATIONS.

 PT_COPYRIGHT_VERSION_2
 COPYRIGHTENDKEY

 */
package ptolemy.actor;

import ptolemy.actor.util.Time;

//////////////////////////////////////////////////////////////////////////
//// TimedDirector

/**
 This is an interface for directors that direct the executions of timed
 actors. Actors that implement the TimedActor marker interface are allowed
 to be executed by directors that implement this interface.

 @see TimedActor
 @author Haiyang Zheng
 @version $Id: TimedDirector.java,v 1.16 2005/07/08 19:37:34 cxh Exp $
 @since Ptolemy II 4.1
 @Pt.ProposedRating Yellow (hyzheng)
 @Pt.AcceptedRating Red (hyzheng)
 */
public interface TimedDirector {
    /** Return a time object that contains the value of the current time.
     *  @return A time object that contains the value of the current time.
     */
    public Time getModelTime();

    /** Get the time resolution of the model.
     *  @return The time resolution of the model.
     */
    public double getTimeResolution();
}
