# Tests for the PtArrayList class
#
# @Author: Christopher Brooks
#
# @Version: $Id: PtArrayList.tcl,v 1.4 2005/02/28 21:00:44 cxh Exp $
#
# @Copyright (c) 2003-2005 The Regents of the University of California.
# All rights reserved.
#
# Permission is hereby granted, without written agreement and without
# license or royalty fees, to use, copy, modify, and distribute this
# software and its documentation for any purpose, provided that the
# above copyright notice and the following two paragraphs appear in all
# copies of this software.
#
# IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY
# FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES
# ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF
# THE UNIVERSITY OF CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF
# SUCH DAMAGE.
#
# THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
# INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
# MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE
# PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE UNIVERSITY OF
# CALIFORNIA HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT, UPDATES,
# ENHANCEMENTS, OR MODIFICATIONS.
#
# 						PT_COPYRIGHT_VERSION_2
# 						COPYRIGHTENDKEY
#######################################################################

# Ptolemy II test bed, see $PTII/doc/coding/testing.html for more information.

# Load up the test definitions.
if {[string compare test [info procs test]] == 1} then {
    source testDefs.tcl
} {}

# Uncomment this to get a full report, or set in your Tcl shell window.
# set VERBOSE 1

######################################################################
####
#
test PtArrayList1.1 {Construct a PtArrayList} {
    set value0 [java::new ptolemy.data.StringToken AB]
    set value1 [java::new ptolemy.data.StringToken CD]
    set valueArray [java::new {ptolemy.data.Token[]} \
	    2 [list $value0 $value1]]
    set arrayToken [java::new {ptolemy.data.ArrayToken} $valueArray]
    set arrayList [java::new ptolemy.caltrop.util.PtArrayList $arrayToken]
    catch {$arrayList get 3} errMsg
    list \
	    [$arrayList size] \
	    [[$arrayList get 0] toString] \
	    [[$arrayList get 1] toString] \
	    $errMsg

} {2 {"AB"} {"CD"} {java.lang.ArrayIndexOutOfBoundsException: 3}}
