/* A helper class for ptolemy.actor.lib.Sequence

 Copyright (c) 2006 The Regents of the University of California.
 All rights reserved.
 Permission is hereby granted, without written agreement and without
 license or royalty fees, to use, copy, modify, and distribute this
 software and its documentation for any purpose, provided that the above
 copyright notice and the following two paragraphs appear in all copies
 of this software.

 IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY
 FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES
 ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF
 THE UNIVERSITY OF CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF
 SUCH DAMAGE.

 THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
 INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE
 PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE UNIVERSITY OF
 CALIFORNIA HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT, UPDATES,
 ENHANCEMENTS, OR MODIFICATIONS.

 PT_COPYRIGHT_VERSION_2
 COPYRIGHTENDKEY

 */
package ptolemy.codegen.c.actor.lib;

import ptolemy.codegen.c.kernel.CCodeGeneratorHelper;
import ptolemy.kernel.util.IllegalActionException;

//////////////////////////////////////////////////////////////////////////
//// Sequence

/**
 A helper class for ptolemy.actor.lib.Sequence.

 @author Man-Kit Leung, Gang Zhou
 @version $Id: Sequence.java,v 1.37 2006/05/16 23:40:06 cxh Exp $
 @since Ptolemy II 6.0
 @Pt.ProposedRating Green (mankit)
 @Pt.AcceptedRating Green (cxh)
 */
public class Sequence extends CCodeGeneratorHelper {
    /**
     * Construct a Sequence helper.
     * @param actor the associated actor
     */
    public Sequence(ptolemy.actor.lib.Sequence actor) {
        super(actor);
    }

    /**
     * Generate fire code.
     * The method reads in <code>codeBlock1</code>, <code>codeBlock2</code>,
     * and <code>codeBlock3</code> from Sequence.c, replaces macros with
     * their values and returns the processed code block.
     * @return The generated code.
     * @exception IllegalActionException If the code stream encounters an
     *  error in processing the specified code block(s).
     */
    public String generateFireCode() throws IllegalActionException {
        super.generateFireCode();
        ptolemy.actor.lib.Sequence actor = (ptolemy.actor.lib.Sequence) getComponent();

        if (actor.enable.getWidth() == 0) {
            _codeStream.appendCodeBlock("codeBlock1");
        } else {
            _codeStream.appendCodeBlock("codeBlock2");
        }

        _codeStream.appendCodeBlock("codeBlock3");
        return processCode(_codeStream.toString());
    }
}
