# Tests for the AWTImageToken class
#
# @Author: Christopher Brooks
#
# @Version $Id: AWTImageToken.tcl,v 1.4 2008/01/24 00:35:10 cxh Exp $
#
# @Copyright (c) 2006-2008 The Regents of the University of California.
# All rights reserved.
# 
# Permission is hereby granted, without written agreement and without
# license or royalty fees, to use, copy, modify, and distribute this
# software and its documentation for any purpose, provided that the
# above copyright notice and the following two paragraphs appear in all
# copies of this software.
# 
# IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY
# FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES
# ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF
# THE UNIVERSITY OF CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF
# SUCH DAMAGE.
# 
# THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
# INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
# MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE
# PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE UNIVERSITY OF
# CALIFORNIA HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT, UPDATES,
# ENHANCEMENTS, OR MODIFICATIONS.
# 
# 						PT_COPYRIGHT_VERSION_2
# 						COPYRIGHTENDKEY
#######################################################################

# Ptolemy II test bed, see $PTII/doc/coding/testing.html for more information.

# Load up the test definitions.
if {[string compare test [info procs test]] == 1} then { 
    source testDefs.tcl
} {}

# Uncomment this to get a full report, or set in your Tcl shell window.
# set VERBOSE 1

######################################################################
####
# 
test AWTImageToken-1.0 {Create a nil AWTImageToken} {
    set a [java::new ptolemy.data.AWTImageToken [java::null]]
    $a toString
} {{type="class ptolemy.data.AWTImageToken" width="-1" height="-1"}}

######################################################################
####
# 
test AWTImageToken-1.1 {Create a  AWTImageToken} {
    set image [java::new java.awt.image.BufferedImage 1 1 \
	[java::field java.awt.image.BufferedImage TYPE_INT_RGB]]
    set a [java::new ptolemy.data.AWTImageToken $image]
    list [$a toString] [[$a getType] toString]
} {{{type="class ptolemy.data.AWTImageToken" width="1" height="1"}} Object}

######################################################################
####
# 
test AWTImageToken-2.0 {asAWTImage, getValue} {
    # Uses 1.1 above
    list [[$a asAWTImage] equals $image] \
	[[$a getValue] equals $image]

} {1 1}
