# Tests for Unit
#
# @author: Christopher Brooks
#
# @Version $Id: Unit.tcl,v 1.1 2007/09/10 01:05:32 cxh Exp $
#
# @Copyright (c) 2007 The Regents of the University of California.
# All rights reserved.
# 
# Permission is hereby granted, without written agreement and without
# license or royalty fees, to use, copy, modify, and distribute this
# software and its documentation for any purpose, provided that the
# above copyright notice and the following two paragraphs appear in all
# copies of this software.
# 
# IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY
# FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES
# ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF
# THE UNIVERSITY OF CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF
# SUCH DAMAGE.
# 
# THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
# INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
# MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE
# PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE UNIVERSITY OF
# CALIFORNIA HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT, UPDATES,
# ENHANCEMENTS, OR MODIFICATIONS.
# 
# 						PT_COPYRIGHT_VERSION_3
# 						COPYRIGHTENDKEY
#######################################################################

# Ptolemy II test bed, see $PTII/doc/coding/testing.html for more information.

# Load up the test definitions.
if {[string compare test [info procs test]] == 1} then { 
    source testDefs.tcl
} {}

# Uncomment this to get a full report, or set in your Tcl shell window.
#set VERBOSE 1

# 
#

######################################################################
####
# 
test Unit-1.0 {Construct a Unit} {
    set unit0 [java::new ptolemy.data.unit.Unit]
    set unit1 [java::new ptolemy.data.unit.Unit myUnit]
    list [$unit0 equals $unit1] \
	[$unit1 equals $unit1] \
	[$unit0 equals $unit0] \
	[expr {[$unit0 hashCode] == [$unit0 hashCode]}] \
	[expr {[$unit1 hashCode] == [$unit1 hashCode]}] \
	[expr {[$unit0 hashCode] == [$unit1 hashCode]}]
} {0 1 1 1 1 0}


