/* Handle an exception.

 Copyright (c) 2006 The Regents of the University of California.
 All rights reserved.
 Permission is hereby granted, without written agreement and without
 license or royalty fees, to use, copy, modify, and distribute this
 software and its documentation for any purpose, provided that the above
 copyright notice and the following two paragraphs appear in all copies
 of this software.

 IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY
 FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES
 ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF
 THE UNIVERSITY OF CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF
 SUCH DAMAGE.

 THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
 INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE
 PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE UNIVERSITY OF
 CALIFORNIA HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT, UPDATES,
 ENHANCEMENTS, OR MODIFICATIONS.

 PT_COPYRIGHT_VERSION_2
 COPYRIGHTENDKEY

 */
package ptolemy.kernel.util;

//////////////////////////////////////////////////////////////////////////
//// ExceptionHandler

/**
 Interface for exception handlers. If a model contains an entity that
 implements this interface, then if running the model results in an
 exception, the exception is delegated to this exception handler.

 @author Haiyang Zheng
 @version $Id: ExceptionHandler.java,v 1.7 2007/12/07 06:24:47 cxh Exp $
 @since Ptolemy II 5.2
 @Pt.ProposedRating Green (hyzheng)
 @Pt.AcceptedRating Green (hyzheng)
 */
public interface ExceptionHandler {
    ///////////////////////////////////////////////////////////////////
    ////                         public methods                    ////

    /** Handle an exception. This method may throw another exception.
     *  @param context The object in which the exception occurred.
     *  @param exception An exception to be handled.
     *  @return True if the exception has been handled, or false if the
     *   exception is not handled.
     *  @exception IllegalActionException If this handler handles the
     *   exception by throwing an exception.
     */
    public boolean handleException(NamedObj context, Throwable exception)
            throws IllegalActionException;
}
