/*
 * OPALE is a scientific library under LGPL. Its main goal is to
 * develop mathematical tools for any scientist.
 *
 * Copyright (C) 2002 Opale Group
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 * You can visit the web site http://opale.tuxfamily.org to obtain more
 * informations about this program and/or to contact the authors by mail
 * developers@opale.tuxfamily.org.
 */

package otests.matrix.Jacobi;
import opale.tools.*;
import opale.mathtools.*;
import opale.matrix.*;
import opale.matrix.solver.*;


public class Jacobi implements OTest
{
public void run(String path)
	{
	final int size = 100;
	Matrix A = new Matrix (size,size);
	DVect b = new DVect(size);
	DVect x = new DVect(size);
	
	for (int i=0;i<size;i++)
		{
		A.set(i,i,2);
		if (i>0) A.set(i,i-1,-1);
		if (i<size-1) A.set(i,i+1,-1);
		 }
	b.set(0,1);
	b.set(1,3);
	//System.out.println(A);
	Matrix AA=(Matrix)A.clone();	 
	SolverJacobi jac = new SolverJacobi();
	jac.solve(AA,b,x);

	
	
	DVect err = new DVect(size);
	double tmp;
	for (int i=0;i<size;i++)
		{
		tmp = 0-b.get(i);
		for(int j = 0;j <size;j++)
				tmp +=A.get(i,j)*x.get(j);
		err.set(i,tmp);
		}
	
	System.out.println("Err = "+err.getMax());
	
	}
public void stop()
	{
	}
	
}
