package apps;

import java.io.*;
import java.text.*;
import java.util.logging.Logger;

import misc.LoggedException;

import tools.CL_Initializer;

/**
 * <dl>
 * 
 * <dt>Purpose:
 * 
 * <dd>Converts binary data to text.
 * 
 * <dt>Description:
 * 
 * <dd>Reads in binary data with format specified on the command line, although
 * assumed big-endian, and writes out the values as numbers in text line by
 * line.
 * 
 * </dl>
 * 
 * @author Danny Alexander
 * @version $Id: BinaryToText.java,v 1.1 2008/12/08 17:48:43 bennett Exp $
 *  
 */
public class BinaryToText {

    /**
     * the logger object for message handling
     */
    private static Logger logger = Logger.getLogger("camino.apps.BinaryToText");

    /**
     * The type of the input data.
     */
    private static String inputDataType = "float";

    /**
     * Input data file. If left null, the program reads data from the standard
     * input.
     */
    private static String inputFile = null;

    /**
     * The stream from which to read the input.
     */
    private static DataInputStream in = new DataInputStream(System.in);

    public static void main(String[] args) {

        // This is the number of decimal places to print in scientific
        // notation.
        int decimalPlaces = 6;

        // parse arguments
        CL_Initializer.CL_init(args);

        // Parse the command line arguments
        for (int i = 0; i < args.length; i++) {
            if (args[i].equals("-inputdatatype")) {
                inputDataType = args[i + 1];
                CL_Initializer.markAsParsed(i);
                CL_Initializer.markAsParsed(i + 1);
            }
            if (args[i].equals("-dp")) {
                decimalPlaces = Integer.parseInt(args[i + 1]);
                CL_Initializer.markAsParsed(i);
                CL_Initializer.markAsParsed(i + 1);
            }
        }

        // check all arguments parsed
        CL_Initializer.checkParsing(args);

        // Set up the scientific notation format.
        String zeros = "";
        for (int i = 0; i < decimalPlaces; i++) {
            zeros += "0";
        }
        DecimalFormat sciForm = new DecimalFormat("0." + zeros + "E00;-0." + zeros
                + "E00");

        Object[] o = new Object[1];
        while (true) {

            readNext(inputDataType, o);

            if (inputDataType.equals("char") || inputDataType.equals("byte")
                    || inputDataType.equals("short") || inputDataType.equals("int")
                    || inputDataType.equals("long")) {

                System.out.println(MessageFormat.format("{0,number, 0;-0}", o));
            }
            else if (inputDataType.equals("float") || inputDataType.equals("double")) {

                System.out.println(sciForm.format(((Number) o[0]).doubleValue()));
            }

        }

    }

    /**
     * Reads the next value and places it in the first element of array <code>o</code>.
     *
     * @param inputDataType as defined in {@link data.ExternalDataSource}.
     * 
     */
    public static void readNext(String inputDataType, Object[] o) {

        try {

            if (inputDataType.equals("byte")) {
                o[0] = new Byte(in.readByte());
            }
            else if (inputDataType.equals("char")) {
                int b = in.readByte();
                o[0] = new Integer(b >= 0 ? b : 256 + b);
            }
            else if (inputDataType.equals("short")) {
                o[0] = new Short(in.readShort());
            }
            else if (inputDataType.equals("int")) {
                o[0] = new Integer(in.readInt());
            }
            else if (inputDataType.equals("long")) {
                o[0] = new Long(in.readLong());
            }
            else if (inputDataType.equals("float")) {
                o[0] = new Float(in.readFloat());
            }
            else if (inputDataType.equals("double")) {
                o[0] = new Double(in.readDouble());
            }

        }
        catch (Exception e) {

            // End of stream reached. Tidy up and exit.
            try {
                in.close();
            }
            catch (Exception e2) {
                LoggedException.logExceptionWarning(e2, Thread.currentThread().getName());
                
            }

            System.exit(0);
        }
    }

}
