package apps;

import java.util.logging.Logger;

import data.*;
import tools.*;
import inverters.*;

/**
 * <dl>
 * 
 * <dt>Purpose:
 * 
 * <dd>Classified model fitting program.
 * 
 * <dt>Description:
 * 
 * <dd>The program fits models to each voxel depending on a
 * precomputed classification.
 * 
 * </dl>
 * 
 * @see inverters.ModelIndex 
 *
 * @author Danny Alexander
 * @version $Id: ClassifiedModelFit.java,v 1.1 2008/12/08 17:48:43 bennett Exp $
 *  
 */
public class ClassifiedModelFit {

    /**
     * Logging object
     */
    private static Logger logger = Logger.getLogger("camino.apps.ClassifiedModelFit");

    /**
     * Output manager
     */
    private static OutputManager om;


    public static void main(String[] args) {

        // Parse the command line arguments
        CL_Initializer.CL_init(args);
        CL_Initializer.checkParsing(args);
        CL_Initializer.initImagingScheme();
        CL_Initializer.initDataSynthesizer();

        om = new OutputManager();

        // Check that the essential information is provided.
        if(CL_Initializer.voxelClassMap == null) {
            logger.severe("Need a voxel classification map.");
            System.exit(1);
        }

        // Construct the multi-tensor inverter
        MultiTensorInversion inv = new MultiTensorInversion(CL_Initializer.imPars, CL_Initializer.voxelClassMap, CL_Initializer.classifiedModelIndices, CL_Initializer.maxTensorComponents);

        // Loop over the voxels and do the fitting.
        ModelFit.processVoxels(inv, om);
    }


}
