package apps;

import java.util.logging.Logger;

import data.*;
import tools.*;
import inverters.*;

/**
 * <dl>
 * 
 * <dt>Purpose:
 * 
 * <dd>Performs a linear reconstruction in each voxel.
 * 
 * <dt>Description:
 * 
 * <dd>The program reads in a linear transformation matrix and uses it to
 * transform the data in each voxel.
 * 
 * </dl>
 * 
 * @author Danny Alexander
 * @version $Id: LinearRecon.java,v 1.1 2008/12/08 17:48:43 bennett Exp $
 *  
 */
public class LinearRecon {

    private static Logger logger = Logger.getLogger("camino.apps.LinearRecon");

    /**
     * Output manager
     */
    private static OutputManager om;


    public static void main(String[] args) {

        // Parse the command line arguments
        CL_Initializer.CL_init(args);
        CL_Initializer.checkParsing(args);
        CL_Initializer.initImagingScheme();
        CL_Initializer.initDataSynthesizer();

        om = new OutputManager();

        if (CL_Initializer.matrixFile == null) {
            logger.severe("LinearRecon requires a matrix file.");
            System.exit(1);
        }

        // Read in the matrix.
        LinearInversion inv = new LinearInversion(CL_Initializer.imPars,
                CL_Initializer.matrixFile, CL_Initializer.lrNormalize,
                CL_Initializer.lrLog);

        ModelFit.processVoxels(inv, om);
    }

}
