package apps;

import java.util.logging.Logger;

import misc.LoggedException;

import tools.*;
import data.*;
import sphfunc.*;

/**
 * <dl>
 * 
 * <dt>Purpose:
 * 
 * <dd>Computes the kurtosis (fourth root of normalized fourth moment:
 * \sqrt[4]{\int (f(x) - m)^4/\int f^4(x) dx) normalized by the
 * anisotropy (see SphFuncAnisotropy) of an input stream of spherical
 * functions.
 * 
 * <dt>Description:
 * 
 * <dd>Uses standard input and output streams for input and output data.
 * 
 * 
 * </dl>
 * 
 * @author Danny Alexander
 * @version $Id: SphFuncKurtosis.java,v 1.1 2008/12/08 17:48:43 bennett Exp $
 *  
 */
public class SphFuncKurtosis {

    private static Logger logger = Logger.getLogger("camino.apps.SphFuncKurtosis");

    /**
     * Output manager
     */
    private static OutputManager om;


    public static void main(String[] args) {

        // Parse the command line arguments
        CL_Initializer.inputDataType = "double";
        //CL_Initializer cl = new CL_Initializer(args);
        CL_Initializer.CL_init(args);
        CL_Initializer.checkParsing(args);

        CL_Initializer.initImagingScheme();
        CL_Initializer.initMaxEnt();
        CL_Initializer.initSphFuncDataSource();

        om = new OutputManager();

        // Loop over the data
        while (CL_Initializer.data.more())
            try {

                // Read in the coefficients.
                double[] coeffs = CL_Initializer.data.nextVoxel();

                // Construct a spherical function using the
                // coefficients.
                SphericalFunction sf = null;
                if (CL_Initializer.inputModel.equals("sh")) {
                    sf = new EvenSHS(coeffs, CL_Initializer.maxOrder);
                }
                else if (CL_Initializer.inputModel.equals("maxent")) {
                    sf = new MaxEntProfile(coeffs, CL_Initializer.kernelParams);
                }
                else {
                    sf = new TuchRBF_Sum(coeffs);
                }

                double[] kurt = {1.0};
                if (coeffs[0]>=0 && !ModelFit.isBG(Math.exp(coeffs[1]))) {
                    kurt[0] = sf.kurtosis();
                }

                om.output(kurt);

            }
            catch (Exception e) {
                
                LoggedException.logExceptionWarning(e, Thread.currentThread().getName());
            }

        // Tidy up.
        om.close();
    }

}
