package data;

/**
 * <dl>
 * 
 * <dt>Purpose:
 * 
 * <dd>General interface for models for the diffusion displacement density
 * function.
 * 
 * <dt>Description:
 * 
 * <dd>Provides methods to access the value of a test function and its Fourier
 * transform and a specific time and displacement/wavenumber.
 * 
 * </dl>
 * 
 * @author Danny Alexander
 * @version $Id: ModelPDF.java,v 1.1 2008/12/08 17:48:43 bennett Exp $
 *  
 */
public interface ModelPDF {

    /**
     * Returns the value of the function at the specified point and time.
     * 
     * @param x
     *            The point to sample at.
     * 
     * @param tau
     *            The diffusion time.
     * 
     * @return The value of the function at x.
     */
    public double at(double[] x, double tau);


    /**
     * Returns the value of the FT of the function at the specified wavenumber.
     * 
     * @param q
     *            The wavenumber to sample at.
     * 
     * @param tau
     *            The diffusion time.
     * 
     * @return The value of the FT at q.
     */
    public double ftAt(double[] q, double tau);


    /**
     * Returns a list of principal directions of the test function.
     * 
     * @return Array of principal directions. The first index is the principal
     *         direction number. Each principal direction is stored in Cartesian
     *         coordinates: {x, y, z}.
     */
    public double[][] getPDs();

}
