package simulation.measurement;

import java.util.logging.Logger;

import misc.LoggedException;

import imaging.Scheme;
import imaging.SchemeV3;
import simulation.SimulationParams;
import simulation.dynamics.Walker;
import simulation.geometry.Substrate;

/**
 * factory class for creating scans (and other measurement modules).
 * it also contains the constant identifiers for various scan types.
 * 
 * @author matt (m.hall@cs.ucl.ac.uk)
 *
 */
public class ScanFactory {

	/** standard PGSE scan identifier */
	public static final int PGSE_SCAN = 0;
	
	/** twice refocessed spin-echo sequence */
	public static final int TWICE_REFOCUSED = 1;
	
	/** logging object */
	private static Logger logger= Logger.getLogger("simulation.measurement.ScanFactory");
	
	/** factory method. scan objects are not singletons 
	 * 
	 * @param simParams simulation parameters object
	 * @param scheme acquisition scheme
	 * @param substrate the substrate
	 * @param walker array of walkers
	 * @param scanType what type of scan do we want?
	 * 
	 * @return a new scan object based on the above
	 */
	public static final SyntheticScan getMeasurementModule(SimulationParams simParams, Scheme scheme, 
																Substrate substrate, Walker[] walker){
		if(SimulationParams.scanType==PGSE_SCAN){
			return new PGSEscan(simParams, scheme, substrate, walker);
		}
		else if(SimulationParams.scanType== TWICE_REFOCUSED){
			if(scheme.getVersion()!=2){
				throw new LoggedException("Twice refocssed spin-echo sequence requires a type 2 scheme file");
			}
			//return new TwiceRefocussedSpinEchoScan(simParams, (SchemeV3)scheme, substrate, walker);
			return new PGSEscan(simParams, scheme, substrate, walker);
			
		}
		else{
			throw new LoggedException("sythetic scan type "+SimulationParams.scanType+" not known. no synthetic scan returned");
		}
		
	}
	
	
}
