package edu.jhu.bme.smile.demo;
import edu.jhu.ece.iacl.io.StringReaderWriter;
import edu.jhu.ece.iacl.pipeline.CalculationMonitor;
import edu.jhu.ece.iacl.pipeline.ProcessingAlgorithm;
import edu.jhu.ece.iacl.pipeline.parameter.ParamCollection;
import edu.jhu.ece.iacl.pipeline.parameter.ParamInteger;
import edu.jhu.ece.iacl.pipeline.parameter.ParamObject;
import edu.jhu.ece.iacl.pipeline.parameter.ParamVolume;
import edu.jhu.ece.iacl.pipeline.parameter.ParamVolumeCollection;
import edu.jhu.ece.iacl.structures.image.ImageDataFloat;

public class SmileAlgorithmDemo extends ProcessingAlgorithm{
	
	private ParamVolumeCollection ratervols;
	ParamObject<String> pl;
	private ParamVolumeCollection truthOut;
	private ParamInteger maxiters;

	protected void createInputParameters(ParamCollection inputParams) {

		inputParams.add(ratervols=new ParamVolumeCollection("Rater Volumes"));
		inputParams.setName("staple");
		inputParams.setLabel("STAPLE");
		
		inputParams.add(maxiters=new ParamInteger("Max Iterations"));
		maxiters.setValue(new Integer(200));
		inputParams.setCategory("PAMI.demo");
		
	}
	protected void createOutputParameters(ParamCollection outputParams) {		
		truthOut = new ParamVolumeCollection("Truth Estimates");
		truthOut.setName("Truth Estimate");
		outputParams.add(truthOut);
		
		pl = new ParamObject<String>("PerformanceLevels",new StringReaderWriter());
		outputParams.add(pl);
		
	}
	protected void execute(CalculationMonitor monitor) {
		
	/*	STAPLEmulti staple = new STAPLEmulti(ratervols.getVolumes());
//		STAPLEsingle staple = new STAPLEsingle(ratervols.getVolumes());
		staple.setmaxIters(maxiters.getInt());
		staple.iterate();
		
//		ArrayList<CubicVolumeFloat> list = new ArrayList<CubicVolumeFloat>(1);
//		list.add(staple.getTruth());
//		list.trimToSize();
//		truthOut.setValue(list);
		truthOut.setValue(staple.getTruth());
		pl.setObject(staple.getPeformanceLevel().toString());
		*/
		System.out.println("FINISHED");
	}
}
