package edu.jhu.ece.iacl.algorithms.dti.tractography.FACT;

import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;

import edu.jhu.ece.iacl.structures.fiber.Fiber;
import edu.jhu.ece.iacl.structures.fiber.XYZ;

public class DtisVsIacl {

	/**
	 * @param args
	 */
	public static void main(String[] args) {
		// TODO Auto-generated method stub
		String dir = "/home/john/Research/20070727/corrected_dti/processed/jb_8/";
		String iaclname = dir+"jb_8_iacl_7.dat";
		String dtisname = dir+"jb_8_dtis_7.dat";
		
		System.out.println(dtisname);
		System.out.println(iaclname);
		
		DTIStudioReader reader1 = new DTIStudioReader();
		DTIStudioReader reader2 = new DTIStudioReader();
		
		try{
			
			reader1.read(dtisname);
			Fiber[] dtis = reader1.getFibers();
			System.out.println("*********************************");
			reader2.read(iaclname);
			Fiber[] iacl = reader2.getFibers();
			
			int howmany = 500;
			
			boolean[][][] missimg = new boolean[256][256][173];
			double[] alldistances= new double[howmany];
			int matches = 0;
			int misses = 0;
//			for(int i=0; i<dtis.length; i++){
			for(int i=0; i<howmany; i++){
//				System.out.println("Working on fiber " + i);
				
				for(int j=0; j<dtis[i].getXYZChain().length; j++){	
					XYZ pt = dtis[i].getChain()[j];
					
					if((pt.x % 1f)==0.5 && (pt.y % 1f)==0.5 && (pt.z % 1f)==0.5){
//						System.out.println(pt.x+" " + pt.y + " " +pt.z);
//						System.out.println("Match Found!");
						
						int x=Math.round(pt.x);
						int y=Math.round(pt.y);
						int z=Math.round(pt.z);
//						System.out.println(x+" " + y + " " +z);
						//WE HAVE THE SEED VOXEL!
						//FIND OUR FIBER WITH THE SAME SEED...
						boolean foundmatch = false;
						for(int k=0; k<iacl.length; k++){
							for(int l=0; l<iacl[k].getXYZChain().length; l++){
								XYZ ourpt = (iacl[k].getXYZChain())[l];
								if(ourpt.x==x && ourpt.y==y && ourpt.z==z){
									alldistances[i] = getdist(dtis[i].getXYZChain(), iacl[k].getXYZChain());
									matches++;
									foundmatch = true;
									break;
//									System.out.println("We've found a matching seed in iacl!");
								}
							}
							if(foundmatch){
								break;
							}
						}
						if(!foundmatch){
							misses++;
							missimg[x][y][z]=true;
							alldistances[i]=-1;
						}
						
					}
//					System.out.println("**********************");
				}
//				System.out.println("We had "+ matches + " matches");
//				System.out.println("We had "+ misses + " misses");
//				System.out.println("*********************************");
				
			}
			System.out.println("We had "+ matches + " matches");
			System.out.println("We had "+ misses + " misses");
			
//			DataOutputStream imgout = new DataOutputStream(new FileOutputStream(dir+"_missimg.raw"));
//			for(int k=0; k<missimg[0][0].length;k++){
//				for(int j=1; j<=missimg[0].length;j++){
//					for(int i=0; i<missimg.length;i++){
//						imgout.writeBoolean(missimg[i][missimg[0].length-j][k]);
//					}
//				}
//			}
			
			DataOutputStream distout = new DataOutputStream(new FileOutputStream(dir+"dists.raw"));
			distout.writeInt(howmany);
			for(int g=0; g<howmany;g++){
						distout.writeDouble(alldistances[g]);
			}
			
			
//			for(int i=0; i<10; i++){
//				System.out.println(dtis[i]);
//			}
//			System.out.println("*********************************");
//			for(int i=0; i<10; i++){
//				System.out.println(iacl[i]);
//			}
			
			
		}catch(IOException e){
			e.printStackTrace();
		}
		
	}
	
	
	public static double getdist(XYZ[] in1, XYZ[] in2){
		double dist=0;
		for(int i=0; i<in1.length; i++){
			
			double cdist = Double.MAX_VALUE;
			
			for(int j=0; j<in2.length; j++){
				double l = (in1[i].minus(in2[j])).length();
				if(l<cdist){  cdist=l; }
			}
			if(cdist>dist){dist=cdist;}
		}
		return dist;
	}

}
