package edu.jhu.ece.iacl.algorithms.hardi;

import java.util.Vector;

import Jama.Matrix;
import imaging.Scheme;

public class CFARIBasisSet {

	Scheme acquisition;
	Matrix compressedSensingMatrix;
	Vector<CFARIBasisFunction> basisSet;
	
	public void setDWScheme(Scheme ischeme) {
		acquisition = ischeme;
	}
	
	public Scheme getDWScheme() {
		return acquisition;
	}

	public void setSensingMatrix(Matrix sensingMatrix) { 
		compressedSensingMatrix = (Matrix)sensingMatrix.clone();
	} 
	
	public void setBasisSet(Vector<CFARIBasisFunction> set) {
		basisSet = set;
	}

	public int getNumberOfBasisFunctions() {
		return basisSet.size();
	}

	public Matrix getSensingMatrix() {
		// TODO Auto-generated method stub
		return (Matrix)(compressedSensingMatrix.clone());
	}
	
}
