package edu.jhu.ece.iacl.plugins.dti;
/* This plugin does not compile - in development - only checked
 * in because build path became corrupt.
 */
import imaging.Scheme;
import imaging.SchemeV1;
import inverters.AlgebraicDT_Inversion;
import inverters.DT_Inversion;
import inverters.DiffusionInversion;
import inverters.LinearDT_Inversion;
import inverters.NonLinearDT_Inversion;
import inverters.RestoreDT_Inversion;
import inverters.TensorModelFitter;
import inverters.WeightedLinearDT_Inversion;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Date;

import com.thoughtworks.xstream.XStream;

import edu.jhu.bme.smile.commons.textfiles.TextFileReader;
import edu.jhu.ece.iacl.algorithms.dti.EstimateTensorLLMSE;
import edu.jhu.ece.iacl.io.FileExtensionFilter;
import edu.jhu.ece.iacl.io.StringReaderWriter;
import edu.jhu.ece.iacl.pipeline.AlgorithmInformation;
import edu.jhu.ece.iacl.pipeline.CalculationMonitor;
import edu.jhu.ece.iacl.pipeline.ProcessingAlgorithm;
import edu.jhu.ece.iacl.pipeline.AlgorithmInformation.*;
import edu.jhu.ece.iacl.pipeline.parameter.ParamCollection;
import edu.jhu.ece.iacl.pipeline.parameter.ParamFile;
import edu.jhu.ece.iacl.pipeline.parameter.ParamFloat;
import edu.jhu.ece.iacl.pipeline.parameter.ParamInteger;
import edu.jhu.ece.iacl.pipeline.parameter.ParamObject;
import edu.jhu.ece.iacl.pipeline.parameter.ParamOption;
import edu.jhu.ece.iacl.pipeline.parameter.ParamVolume;
import edu.jhu.ece.iacl.pipeline.parameter.ParamVolumeCollection;
import edu.jhu.ece.iacl.structures.image.ImageDataFloat;
import edu.jhu.ece.iacl.structures.image.ImageDataMipav;
import edu.jhu.ece.iacl.structures.image.ImageDataUByte;
import edu.jhu.ece.iacl.utility.FileUtil;
import gov.nih.mipav.model.structures.ModelImage;

public class DWITensorEstCamino extends ProcessingAlgorithm{ 

	/****************************************************
	 * Input Parameters 
	 ****************************************************/
	private ParamVolume DWdata4D; 		// Imaging Data
	private ParamVolume Mask3D;			// Binary mask to indicate computation volume
	private ParamOption estOptions;		// Option to attempt to estimate with missing data
	private ParamFloat noiseLevel;		// Used for restore
	//	private ParamFile bvaluesTable;		// .b file with a list of b-values
	//	private ParamFile gradsTable;		// .grad or .dpf file with a list of gradient directions
	private ParamFile SchemeFile;
	/****************************************************
	 * Output Parameters
	 ****************************************************/
	private ParamVolume tensorVolume;	// A 4D volume with one tensor estimated per pixel
	private ParamVolume exitCodeVolume;	// A 3D volume 
	private ParamVolume intensityVolume;// A 3D volume 

	private static final String rcsid =
		"$Id: DWITensorEstCamino.java,v 1.6 2009/03/27 01:28:44 bennett Exp $";
	private static final String cvsversion =
		"$Revision: 1.6 $";
	private static final String revnum = cvsversion.replace("Revision: ", "").replace("$", "");
		
	protected void createInputParameters(ParamCollection inputParams) {

		/****************************************************
		 * Step 1. Set Plugin Information 
		 ****************************************************/
		inputParams.setName("Tensor Estimation Camino");
		inputParams.setLabel("Single Tensor Est");
		inputParams.setCategory("Modeling.Diffusion.WholeVolume");
		inputParams.setPackage("Camino");
		AlgorithmInformation info=getAlgorithmInformation();
		info.setWebsite("http://sites.google.com/site/jhupami/");
		info.add(new AlgorithmAuthor("Bennett Landman","landman@jhu.edu","http://sites.google.com/site/bennettlandman/"));
		info.setDescription("Tensor estimation provided by CAMINO.");
		info.setLongDescription("Various tensor estimators. See Camino webpage for more details.");
		info.setAffiliation("Computer Science Department - University College London");
		info.add(new Citation("Basser PJ, Mattielo J, and Lebihan D, Estimation of the effective self-diffusion tensor from the NMR spin echo, Journal of Magnetic Resonance, 103, 247-54, 1994."));
		info.add(new Citation("Jones DK and Basser PJ, Squashing peanuts and smashing pumpkins: How noise distorts diffusion-weighted MR data, Magnetic Resonance in Medicine, 52(5), 979-993, 2004."));
		info.add(new Citation("Alexander DC and Barker GJ, Optimal imaging parameters for fibre-orientation estimation in diffusion MRI, NeuroImage, 27, 357-367, 2005"));
		info.add(new Citation("Chang L-C, Jones DK and Pierpaoli C, RESTORE: Robust estimation of tensors by outlier rejection, Magnetic Resonance in Medicine, 53(5), 1088-1095, 2005."));		
		info.setVersion(revnum);	


		/****************************************************
		 * Step 2. Add input parameters to control system 
		 ****************************************************/
		inputParams.add(DWdata4D=new ParamVolume("DWI and Reference Image(s) Data (4D)",null,-1,-1,-1,-1));
		inputParams.add(SchemeFile=new ParamFile("CAMINO DTI Description (SchemeV1)",new FileExtensionFilter(new String[]{"scheme","schemev1"})));
		//		inputParams.add(gradsTable=new ParamFile("Table of diffusion weighting directions",new FileExtensionFilter(new String[]{"grad","dpf"})));
		//		inputParams.add(bvaluesTable=new ParamFile("Table of b-values",new FileExtensionFilter(new String[]{"b"})));
		inputParams.add(Mask3D=new ParamVolume("Mask Volume to Determine Region of Tensor Estimation (3D)",null,-1,-1,-1,1));
		Mask3D.setMandatory(false); // Not required. A null mask will estimate all voxels.	
		inputParams.add(estOptions=new ParamOption("Select CAMINO Tensor Estimator?",new String[]{"Algebraic","Linear","NonLinear","RESTORE","WeightedLinear"}));
		estOptions.setValue("Linear");
		inputParams.add(noiseLevel=new ParamFloat("Noise Level (RESTORE only)"));
	}

	protected void createOutputParameters(ParamCollection outputParams) {
		/****************************************************
		 * Step 1. Add output parameters to control system 
		 ****************************************************/
		tensorVolume = new ParamVolume("Tensor Estimate",null,-1,-1,-1,6);
		tensorVolume.setName("Tensor (xx,xy,xz,yy,yz,zz)");
		outputParams.add(tensorVolume);
		exitCodeVolume = new ParamVolume("Estimation Exit Code",null,-1,-1,-1,1);
		exitCodeVolume.setName("Exit Code");
		outputParams.add(exitCodeVolume);	
		intensityVolume = new ParamVolume("Intensity Estimate",null,-1,-1,-1,1);
		intensityVolume.setName("Intensity");
		outputParams.add(intensityVolume);

	}
	protected void execute(CalculationMonitor monitor) {
		/****************************************************
		 * Step 1. Indicate that the plugin has started.
		 * 		 	Tip: Use limited System.out.println statements
		 * 			to allow end users to monitor the status of
		 * 			your program and report potential problems/bugs
		 * 			along with information that will allow you to 
		 * 			know when the bug happened.  
		 ****************************************************/
		System.out.println("DWITensorEstLLMSE: Start");

		/****************************************************
		 * Step 2. Parse the input data 
		 ****************************************************/
		System.out.println("Load data.");System.out.flush();
		ImageDataMipav dwd=DWdata4D.getImageData();
		ImageDataFloat DWFloat=new ImageDataFloat(dwd);
		
		ImageDataMipav maskVol=Mask3D.getImageData();
		byte [][][]mask=null;
		if(maskVol!=null) {
			ImageDataUByte maskByte = new ImageDataUByte (maskVol);
			mask = maskByte.toArray3d();
		}
	
		System.out.println("Load scheme.");System.out.flush();
		SchemeV1 DTIscheme = null;
		
		XStream xstream = new XStream();
		xstream.alias("CaminoDWScheme-V1",imaging.SchemeV1.class);
		try {
			ObjectInputStream in = xstream.createObjectInputStream(new FileReader(SchemeFile.getValue()));
			DTIscheme=(SchemeV1)in.readObject();
			in.close();
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
			throw new RuntimeException(e);
		} catch (ClassNotFoundException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
			throw new RuntimeException(e);
		}
		

		/****************************************************
		 * Step 3. Perform limited error checking 
		 ****************************************************/
		System.out.println("Error checking."); System.out.flush();

		DT_Inversion dtiFit=null;
		String code = estOptions.getValue();
		if(estOptions.getValue().compareToIgnoreCase("Algebraic")==0) {
			dtiFit=new AlgebraicDT_Inversion(DTIscheme);			
		}
		if(estOptions.getValue().compareToIgnoreCase("Linear")==0) {
			dtiFit=new LinearDT_Inversion(DTIscheme);			
		}
		if(estOptions.getValue().compareToIgnoreCase("NonLinear")==0) {
			dtiFit=new NonLinearDT_Inversion(DTIscheme);			
		}
		if(estOptions.getValue().compareToIgnoreCase("RESTORE")==0) {
			dtiFit=new RestoreDT_Inversion(DTIscheme,noiseLevel.getValue().floatValue());			
		}
		if(estOptions.getValue().compareToIgnoreCase("WeightedLinear")==0) {
			dtiFit=new WeightedLinearDT_Inversion(DTIscheme);			
		}
		/****************************************************
		 * Step 4. Run the core algorithm. Note that this program 
		 * 		   has NO knowledge of the MIPAV data structure and 
		 * 		   uses NO MIPAV specific components. This dramatic 
		 * 		   separation is a bit inefficient, but it dramatically 
		 * 		   lower the barriers to code re-use in other applications.  		  
		 ****************************************************/
		System.out.println("Allocate memory."); System.out.flush();
		float [][][][]data=DWFloat.toArray4d();
		int rows = data.length;
		int cols= data[0].length;
		int slices= data[0][0].length;
		int components= data[0][0][0].length;
		float [][][][]tensors = new float[rows][cols][slices][6];
		float [][][][]exitCode= new float[rows][cols][slices][1];
		float [][][][]intensity= new float[rows][cols][slices][1];

		
		System.out.println("Run CAMINO estimate."); System.out.flush();
		EstimateTensorLLMSE.estimateCamino(data,mask,dtiFit,tensors,exitCode,intensity);

		/****************************************************
		 * Step 5. Retrieve the image data and put it into a new
		 * 			data structure. Be sure to update the file information
		 * 			so that the resulting image has the correct
		 * 		 	field of view, resolution, etc.  
		 ****************************************************/
		System.out.println("Data export."); System.out.flush();
		int []ext=DWFloat.getModelImage().getExtents();
		ModelImage img=null;
		ImageDataFloat out=new ImageDataFloat(tensors);
		img=(out).getModelImage();
		
		ext[3]=6;
		img.setExtents(ext);
		FileUtil.updateFileInfo(DWdata4D.getModelImage(),img);		
		img.calcMinMax();
		
		out.setName(DWdata4D.getModelImage().getImageName()+"_Tensor"+code);
		tensorVolume.setValue(out);		

				
		
		out=new ImageDataFloat(exitCode);
		img=(out).getModelImage();
		
		ext[3]=1;
		img.setExtents(ext);
		FileUtil.updateFileInfo(DWdata4D.getModelImage(),img);
		img.calcMinMax();		
		out.setName(DWdata4D.getModelImage().getImageName()+"_ExitCode"+code);
		exitCodeVolume.setValue(out);
		
		out=new ImageDataFloat(intensity);
		img=(out).getModelImage();
		ext[3]=1;
		img.setExtents(ext);
		FileUtil.updateFileInfo(DWdata4D.getModelImage(),img);
		img.calcMinMax();
			
		out.setName(DWdata4D.getModelImage().getImageName()+"_Intensity"+code);
		intensityVolume.setValue(out);	
		/****************************************************
		 * Step 6. Let the user know that your code is finished.  
		 ****************************************************/
		System.out.println("DWITensorEstLLMSE: FINISHED");
	}
}
