package edu.jhu.ece.iacl.plugins.dti;

import java.util.ArrayList;

import edu.jhu.ece.iacl.io.FileExtensionFilter;
import edu.jhu.ece.iacl.io.StringArrayXMLReaderWriter;
import edu.jhu.ece.iacl.io.StringReaderWriter;
import edu.jhu.ece.iacl.pipeline.AlgorithmInformation;
import edu.jhu.ece.iacl.pipeline.AlgorithmRuntimeException;
import edu.jhu.ece.iacl.pipeline.CalculationMonitor;
import edu.jhu.ece.iacl.pipeline.ProcessingAlgorithm;
import edu.jhu.ece.iacl.pipeline.AlgorithmInformation.AlgorithmAuthor;
import edu.jhu.ece.iacl.pipeline.parameter.ParamBoolean;
import edu.jhu.ece.iacl.pipeline.parameter.ParamCollection;
import edu.jhu.ece.iacl.pipeline.parameter.ParamInteger;
import edu.jhu.ece.iacl.pipeline.parameter.ParamObject;
import edu.jhu.ece.iacl.pipeline.parameter.ParamString;
import edu.jhu.ece.iacl.pipeline.parameter.ParamVolume;
import edu.jhu.ece.iacl.pipeline.parameter.ParamVolumeCollection;
import edu.jhu.ece.iacl.structures.image.ImageData;
import edu.jhu.ece.iacl.structures.image.ImageDataMipav;
import edu.jhu.ece.iacl.structures.image.VoxelType;
import gov.nih.mipav.model.file.FileInfoBase;

/**
 * This module finds the ith b0 image from a diffusion weighted volume
 * @author John Bogovic
 *
 */
public class MedicAlgorithmExtractB0 extends ProcessingAlgorithm {

	//INPUT PARAMETERS
	private ParamVolume dwi;
	private ParamObject<String> allbvalues;
	private ParamInteger b0index;
	private ParamInteger repetitionindex;
	private ParamBoolean returnothers;
	
	//OUTPUT PARAMETERS
	private ParamInteger firstDWidx, lastDWidx;
	private ParamInteger indexOfb0;
	private ParamString DWrange;
	
	private StringArrayXMLReaderWriter saxml;

	/****************************************************
	 * CVS Version Control
	 ****************************************************/
	private static final String rcsid =
		"$Id: MedicAlgorithmExtractB0.java,v 1.6 2008/12/18 19:09:39 bogovic Exp $";
	private static final String cvsversion =
		"$Revision: 1.6 $";
	private static final String revnum = cvsversion.replace("Revision: ", "").replace("$", "");

	
	@Override
	protected void createInputParameters(ParamCollection inputParams) {
		
		inputParams.add(dwi = new ParamVolume("Diffusion Weighted Volumes",null,-1,-1,-1,-1));
		StringReaderWriter srw = new StringReaderWriter();
		srw.setExtensionFilter(new FileExtensionFilter(new String[]{"b"}));
		inputParams.add(allbvalues = new ParamObject<String>("b-value list",srw));
		allbvalues.setDescription("A list of all bvalues from all DW acquisitions.  (output of Multi Par Info)");
		
		inputParams.add(b0index = new ParamInteger("B0 index"));
		b0index.setValue(0);
		b0index.setDescription("Indicates the index of the b0 volume to extract.");
		
//		inputParams.add(repetitionindex = new ParamInteger("Acquisition index"));
//		repetitionindex.setDescription("Indicates the index of the DW acquisition when there are repeated scans");
//		repetitionindex.setValue(0);
		
//		inputParams.add(returnothers = new ParamBoolean("Return Other Volumes?"));
//		returnothers.setValue(true);
		
		inputParams.setCategory("IACL.DTI");
		inputParams.setName("extractb0");
		inputParams.setLabel("Extract b0 volume"+revnum);
			
		AlgorithmInformation info=getAlgorithmInformation();
		info.add(new AlgorithmAuthor("John Bogovic","bogovic@jhu.edu","http://sites.google.com/site/bennettlandman/"));
		info.setDescription("Finds the indices of the ith b0 volume.  Also returns other info");
		info.setAffiliation("Johns Hopkins University, Departments of Electrical aFnd Biomedical Engineering");	
		info.setVersion(revnum);
	}

	@Override
	protected void createOutputParameters(ParamCollection outputParams) {
		outputParams.add(firstDWidx = new ParamInteger("First DW index"));
		firstDWidx.setDescription("Index of the first DW vol in the original 4D volume");
		outputParams.add(lastDWidx = new ParamInteger("Last DW index"));
		lastDWidx.setDescription("Index of the last DW vol in the original 4D volume");
		outputParams.add(indexOfb0 = new ParamInteger("b0 index"));
		indexOfb0.setDescription("Index of the b0 in the original 4D volume");
	}

	@Override
	protected void execute(CalculationMonitor monitor)
			throws AlgorithmRuntimeException {
		saxml = new StringArrayXMLReaderWriter();
		ArrayList<String> strb0 = saxml.readStrings(allbvalues.getObject());
//		int ithb0index = getithB0index(strb0.get(repetitionindex.getInt()),b0index.getInt());
		int ithb0index = getithB0index(strb0.get(0),b0index.getInt());
		System.out.println("Extract b0");
		
		int first = ithb0index+1;
		int last = dwi.getImageData().getComponents();

		
		indexOfb0.setValue(ithb0index);
		firstDWidx.setValue(first);
		lastDWidx.setValue(last);
		
	}
	

	
	
	private static int getithB0index(String bvals, int idx){
		int ind = -1;
		int j = 0;
		int k = -1;
		String ithb = "";
		ithb = "";
		/*
		 * Treat each list of bvalues seperately 
		 */
		int i=0;
		while(k!=idx && i<bvals.length()){
			if(bvals.charAt(i)=='\n'){
				if(Float.parseFloat(ithb)==0){
					ind = j;
					k++;
					break;
				}
				ithb="";
				j++;
			}else{
				ithb=ithb+bvals.charAt(i);
			}
			i++;
		}
		
		/* We're finished. Print a warning if there was no idx'th bvalue.*/
		if(k!=idx){
			System.err.println("WARNING: There was no " + idx + "th b0! " +
					"Returning the "+k+"th b0 volume");
		}
		return ind;
	}

}
