package edu.jhu.ece.iacl.plugins.dti;

import edu.jhu.ece.iacl.algorithms.dti.DTIGradientTableCreator;
import edu.jhu.ece.iacl.io.StringReaderWriter;
import edu.jhu.ece.iacl.pipeline.CalculationMonitor;
import edu.jhu.ece.iacl.pipeline.ProcessingAlgorithm;
import edu.jhu.ece.iacl.pipeline.parameter.ParamCollection;
import edu.jhu.ece.iacl.pipeline.parameter.ParamObject;
import edu.jhu.ece.iacl.pipeline.parameter.ParamOption;

public class MedicAlgorithmFlipVectorTable extends ProcessingAlgorithm{
	
	private ParamObject<String> tablein;
	private ParamOption flipDim;
	private ParamObject<String> tableout;
	
	/****************************************************
	 * CVS Version Control
	 ****************************************************/
	private static final String rcsid =
		"$Id: MedicAlgorithmFlipVectorTable.java,v 1.4 2008/12/10 16:03:49 bennett Exp $";
	private static final String cvsversion =
		"$Revision: 1.4 $";
	private static final String revnum = cvsversion.replace("Revision: ", "").replace("$", "");

	protected void createInputParameters(ParamCollection inputParams) {
		inputParams.add(tablein = new ParamObject<String>("Input Gradient Table", new StringReaderWriter()));
		String[] flipoptions = {"X","Y","Z"};
		inputParams.add(flipDim = new ParamOption("Gradient to Flip",flipoptions));
		
		inputParams.setName("GradTableFlipper");
		inputParams.setLabel("Flip Gradient Table");
		inputParams.setCategory("IACL.DTI");
		getAlgorithmInformation().setVersion(revnum);
	}
	
	protected void createOutputParameters(ParamCollection outputParams) {		
		outputParams.add(tableout = new ParamObject<String>("Output Gradient Table", new StringReaderWriter()));
	}
	
	protected void execute(CalculationMonitor monitor) {
		
		double[][] table = DTIGradientTableCreator.parseTableFile(tablein.getValue().getAbsolutePath());
		for(int i=0; i<table.length; i++){
			table[i][flipDim.getIndex()]=-table[i][flipDim.getIndex()];
		}
		tableout.setObject(DTIGradientTableCreator.tableToString(table));
		tableout.setFileName(tablein.getValue().getName()+"_Flipped"+flipDim.getValue());
	}
	
}
