package edu.jhu.ece.iacl.plugins.dti;

import java.util.ArrayList;

import edu.jhu.ece.iacl.algorithms.dti.GradientTable;
import edu.jhu.ece.iacl.io.ArrayDoubleListTxtReaderWriter;
import edu.jhu.ece.iacl.io.ArrayDoubleTxtReaderWriter;
import edu.jhu.ece.iacl.io.StringReaderWriter;
import edu.jhu.ece.iacl.pipeline.CalculationMonitor;
import edu.jhu.ece.iacl.pipeline.ProcessingAlgorithm;
import edu.jhu.ece.iacl.pipeline.parameter.ParamCollection;
import edu.jhu.ece.iacl.pipeline.parameter.ParamObject;
import edu.jhu.ece.iacl.pipeline.parameter.ParamOption;
import edu.jhu.ece.iacl.pipeline.parameter.ParamVolume;

public class MedicAlgorithmTableFormat extends ProcessingAlgorithm{

	//input parameters
	private ParamObject<String> tablein;
	private ParamOption tabletype;
	
	//output parameters
	private ParamObject<String> gradOut;

	/****************************************************
	 * CVS Version Control
	 ****************************************************/
	private static final String rcsid =
		"$Id: MedicAlgorithmTableFormat.java,v 1.3 2008/12/10 16:03:49 bennett Exp $";
	private static final String cvsversion =
		"$Revision: 1.3 $";
	private static final String revnum = cvsversion.replace("Revision: ", "").replace("$", "");

	protected void createInputParameters(ParamCollection inputParams) {
		inputParams.add(tablein = new ParamObject<String>("Gradient Table",new StringReaderWriter()));
		String[] tt = {"IACL","DTIS","FSL"};
		inputParams.add(tabletype = new ParamOption("Output Table Type",tt));
		
		inputParams.setName("tableformat");
		inputParams.setLabel("Format Gradient Table");
		inputParams.setCategory("IACL.DTI");
		getAlgorithmInformation().setVersion(revnum);
		
	}
	protected void createOutputParameters(ParamCollection outputParams) {	
		outputParams.add(gradOut = new ParamObject<String>("Gradient Table Out",new StringReaderWriter()));
	}
	
	protected void execute(CalculationMonitor monitor) {
		
		GradientTable gt = new GradientTable();
		gt.readTable(tablein.getValue());
		
		if(tabletype.getIndex()==0){
			gradOut.setObject(gt.toArrayTxt());
		}else if(tabletype.getIndex()==1){
			gradOut.setObject(gt.toDtisTable());
		}else if(tabletype.getIndex()==2){
			gradOut.setObject(gt.toFslTable());
		}else{
			gradOut.setObject("Problem!");
		}
		gradOut.setFileName(tablein.getValue().getName()+tabletype.getValue()+"_format");
		
	}
}
