package edu.jhu.ece.iacl.plugins.hardi;

import edu.jhu.ece.iacl.pipeline.AlgorithmInformation;
import edu.jhu.ece.iacl.pipeline.CalculationMonitor;
import edu.jhu.ece.iacl.pipeline.ProcessingAlgorithm;
import edu.jhu.ece.iacl.pipeline.AlgorithmInformation.AlgorithmAuthor;
import edu.jhu.ece.iacl.pipeline.AlgorithmInformation.Citation;
import edu.jhu.ece.iacl.pipeline.parameter.ParamCollection;
import edu.jhu.ece.iacl.pipeline.parameter.ParamFileCollection;
import edu.jhu.ece.iacl.pipeline.parameter.ParamInteger;
import edu.jhu.ece.iacl.pipeline.parameter.ParamBoolean;
import edu.jhu.ece.iacl.pipeline.parameter.ParamFile;
import edu.jhu.ece.iacl.pipeline.parameter.ParamObject;
import edu.jhu.ece.iacl.pipeline.parameter.ParamOption;
import edu.jhu.ece.iacl.pipeline.parameter.ParamMatrix;
import edu.jhu.ece.iacl.plugins.dti.DWIDefineCaminoScheme;
import edu.jhu.ece.iacl.algorithms.dti.DTIGradientTableCreator;
import edu.jhu.ece.iacl.algorithms.dti.GTCparams;
import edu.jhu.ece.iacl.algorithms.dti.GradientTable;
import edu.jhu.ece.iacl.algorithms.hardi.ExtractPARGradientTable;
import edu.jhu.ece.iacl.io.FileExtensionFilter;
import edu.jhu.ece.iacl.io.StringArrayXMLReaderWriter;
import edu.jhu.ece.iacl.io.StringReaderWriter;


import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.ArrayList;
import java.util.Vector;

import javax.vecmath.Point3f;

import com.thoughtworks.xstream.XStream;

import Jama.Matrix;



public class ExtractBvalGradFromPAR extends ProcessingAlgorithm{

	//output params
	private ParamFile grad;	// gradient directions 
	private ParamFile bout;		// b values

	//input params
	private ParamFileCollection parFiles;

	/****************************************************
	 * CVS Version Control
	 ****************************************************/
	private static final String rcsid =
		"$Id: ExtractBvalGradFromPAR.java,v 1.4 2009/02/10 20:04:34 bennett Exp $";
	private static final String cvsversion =
		"$Revision: 1.4 $";
	private static final String revnum = cvsversion.replace("Revision: ", "").replace("$", "");


	protected void createInputParameters(ParamCollection inputParams) {
		
		/****************************************************
		 * Step 1. Set Plugin Information 
		 ****************************************************/
		inputParams.setName("Extract b and grad from PAR files");
		inputParams.setLabel("Extract b/grad");
		inputParams.setCategory("Modeling.Diffusion");
		inputParams.setPackage("IACL");
		AlgorithmInformation info=getAlgorithmInformation();
		info.setWebsite("http://sites.google.com/site/jhupami/");
		info.add(new AlgorithmAuthor("Bennett Landman","landman@jhu.edu","http://sites.google.com/site/bennettlandman/"));		
		info.setDescription("Extract b/grad tables from new (modern 4.2+ PAR files)");
		
		info.setAffiliation("Johns Hopkins University");		
				
		info.setVersion(revnum);	

		
		inputParams.add(parFiles= new ParamFileCollection("Par files",new FileExtensionFilter(new String[]{"par","PAR","parv2","PARv2"})));				
	}
	protected void createOutputParameters(ParamCollection outputParams) {				
		outputParams.add(bout = new ParamFile("b-Values",new FileExtensionFilter(new String[]{"b"})));
		outputParams.add(grad = new ParamFile("Gradient Tables",new FileExtensionFilter(new String[]{"grad"})));		
	}
	/**
	 * The execute algorithm that implements ProcessingAlgorithms's abstract method definition. 
	 */
	protected void execute(CalculationMonitor monitor) {
		String gradfilename = null;
		String bfilename = null;
		
		for(int ii=0;ii<parFiles.size();ii++) {
			System.out.println("# "+(ii+1)+" of "+parFiles.size());
			File par = parFiles.getValue(ii);
			System.out.println("PAR: "+par.toURI());
			System.out.flush();
			if(gradfilename==null) 
				gradfilename = getOutputDirectory().toString() 
				+ File.separatorChar + DWIDefineCaminoScheme.getFileNameWithoutExtension(par.getName()) + ".grad";
			if(bfilename==null) 
				bfilename = getOutputDirectory().toString() 
				+ File.separatorChar + DWIDefineCaminoScheme.getFileNameWithoutExtension(par.getName()) + ".b";

			Vector<Float>b = new Vector<Float>();
			
			Vector<Point3f>g = new Vector<Point3f>();
			System.out.println("foo");System.out.flush();
			ExtractPARGradientTable.ExtractPARGradientTable(par.getAbsolutePath(),
					b,g);
			
			for(int i=0;i<b.size();i++) {
				if(b.get(i).floatValue()!=0.0f) {
					Point3f pt = g.get(i);
					if(pt.x==0.0f && pt.y==0.0f && pt.z==0.0f) {
						g.set(i, new Point3f(100,100,100));
					}
				}
			}
			
			System.out.println("b-values:");
			for(Float f : b) {
				System.out.println("\t"+f.toString());
			}
			System.out.println("grad-directions:");
			for(Point3f p : g) {
				System.out.println("\t"+p.x+" \t"+p.y+" \t"+p.z);
			}
			System.out.flush();
			File outDir = this.getOutputDirectory();//MipavController.getDefaultWorkingDirectory();

			System.out.println(bfilename); System.out.flush();
			
			File bfile= new File(bfilename);
			FileWriter rw;
			try {
				rw = new FileWriter(bfile,true);

				for(Float f : b) {
					rw.write(f.toString()+"\n");
				}
				rw.close();
				bout.setValue(bfile);	

				
				File gfile= new File(gradfilename);
				rw = new FileWriter(gfile,true);
				for(Point3f p : g) {
					rw.write(p.x+" \t"+p.y+" \t"+p.z+"\n");
				}
				rw.close();

				grad.setValue(gfile);
			} catch (IOException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
				throw new RuntimeException("I/O Error.");
			}
		}
	}

}

