package edu.jhu.ece.iacl.plugins.utilities.file;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.*;

import edu.jhu.ece.iacl.pipeline.AlgorithmInformation;
import edu.jhu.ece.iacl.pipeline.CalculationMonitor;
import edu.jhu.ece.iacl.pipeline.ProcessingAlgorithm;
import edu.jhu.ece.iacl.pipeline.AlgorithmInformation.Citation;
import edu.jhu.ece.iacl.pipeline.parameter.ParamCollection;
import edu.jhu.ece.iacl.pipeline.parameter.ParamFile;
import edu.jhu.ece.iacl.pipeline.parameter.ParamFileCollection;
import edu.jhu.ece.iacl.pipeline.parameter.ParamString;



public class MedicAlgorithmChooseFileRegEx extends ProcessingAlgorithm{
	
	//input Params
	ParamString regEx;
	ParamFileCollection candidateFiles;
//	ParamFile candidateFiles;
	ParamFile targetFile;
	
	ParamFileCollection filesout;
	
	/****************************************************
	 * CVS Version Control
	 ****************************************************/
	private static final String rcsid =
		"$Id: MedicAlgorithmChooseFileRegEx.java,v 1.2 2008/12/10 16:03:49 bennett Exp $";
	private static final String cvsversion =
		"$Revision: 1.2 $";
	private static final String revnum = cvsversion.replace("Revision: ", "").replace("$", "");

	protected void createInputParameters(ParamCollection inputParams) {

		inputParams.add(regEx=new ParamString("Regular Expression"));
		inputParams.setName("chooseFileRegEx");
		inputParams.setLabel("File Chooser (RegEx)");
		
		inputParams.add(candidateFiles=new ParamFileCollection("Candidate Files"));
		inputParams.add(targetFile=new ParamFile("Target File"));
		inputParams.setCategory("IACL.Utilities.File");
		targetFile.setMandatory(false);
		
		AlgorithmInformation info=getAlgorithmInformation();
		info.setWebsite("");
		info.setDescription("Choose candidates from a File Collection using a Regular Expression");
		info.setAffiliation("");
		info.add(new Citation(""));
		info.add(new Citation(""));		
		info.setVersion(revnum);	
		
	}
	protected void createOutputParameters(ParamCollection outputParams) {		
		filesout = new ParamFileCollection("Matching Files");
		outputParams.add(filesout);
		
	}
	protected void execute(CalculationMonitor monitor) {
		
//		System.out.println(targetFile.getValue().getName());
//		System.out.println(candidateFiles.getValue().getName());
		
		System.out.println("Finding matches...");
		if(targetFile.getValue()==null){
			filesout.setValue(matchFile(regEx.getValue(),candidateFiles.getValue()));
		}else{
			filesout.setValue(matchFile(regEx.getValue(),targetFile.getValue(),candidateFiles.getValue()));
		}
		System.out.println(filesout.getValue());
	}

	public ArrayList<File> matchFile(String expression, File target, List<File> toMatch){
		
		Pattern p = Pattern.compile(expression);
		Matcher m = p.matcher(target.getName());
		m.find();
		String tagExp = target.getName().substring(m.start(), m.end());

		Pattern pt = Pattern.compile(tagExp);
		
		ArrayList<File> matches = new ArrayList<File>();
		
		for(File s : toMatch){
			Matcher mat = pt.matcher(s.getName());
			if(mat.find()){
				matches.add(s);
			}
		}

		return matches;

	}

	public ArrayList<File> matchFile(String expression,List<File> toMatch){
		Pattern pt = Pattern.compile(expression);
		ArrayList<File> matches = new ArrayList<File>();
		for(File s : toMatch){
			Matcher mat = pt.matcher(s.getName());
			if(mat.find()){
				matches.add(s);
			}
		}
		return matches;
	}

}
