package edu.jhu.ece.iacl.plugins.utilities.file;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.*;

import edu.jhu.ece.iacl.pipeline.AlgorithmInformation;
import edu.jhu.ece.iacl.pipeline.CalculationMonitor;
import edu.jhu.ece.iacl.pipeline.ProcessingAlgorithm;
import edu.jhu.ece.iacl.pipeline.AlgorithmInformation.Citation;
import edu.jhu.ece.iacl.pipeline.parameter.ParamCollection;
import edu.jhu.ece.iacl.pipeline.parameter.ParamString;
import edu.jhu.ece.iacl.pipeline.parameter.ParamVolume;
import edu.jhu.ece.iacl.pipeline.parameter.ParamVolumeCollection;
import edu.jhu.ece.iacl.structures.image.ImageData;



public class MedicAlgorithmChooseVolumeRegEx extends ProcessingAlgorithm{
	
	//input Params
	ParamString regEx;
	ParamVolumeCollection candidateFiles;
	ParamVolume targetFile;
	
	//output Params
	ParamVolumeCollection filesout;
	
	/****************************************************
	 * CVS Version Control
	 ****************************************************/
	private static final String rcsid =
		"$Id: MedicAlgorithmChooseVolumeRegEx.java,v 1.2 2008/12/10 16:03:49 bennett Exp $";
	private static final String cvsversion =
		"$Revision: 1.2 $";
	private static final String revnum = cvsversion.replace("Revision: ", "").replace("$", "");

	protected void createInputParameters(ParamCollection inputParams) {

		inputParams.add(regEx=new ParamString("Regular Expression"));
		inputParams.setName("chooseVolRegEx");
		inputParams.setLabel("Volume Chooser (RegEx)");
		
		inputParams.add(candidateFiles=new ParamVolumeCollection("Candidate Volumes"));
		inputParams.add(targetFile=new ParamVolume("Target Volumes"));
		inputParams.setCategory("IACL.Utilities.File");
		targetFile.setMandatory(false);
		
		AlgorithmInformation info=getAlgorithmInformation();
		info.setWebsite("");
		info.setDescription("");
		info.setAffiliation("Choose candidates from a Volume Collection using a Regular Expression");
		info.add(new Citation(""));
		info.add(new Citation(""));		
		info.setVersion(revnum);	
		
	}
	protected void createOutputParameters(ParamCollection outputParams) {		
		filesout = new ParamVolumeCollection("Matching Volumes");
		outputParams.add(filesout);
		
	}
	protected void execute(CalculationMonitor monitor) {
		
//		System.out.println(targetFile.getValue().getName());
//		System.out.println(candidateFiles.getValue().getName());
		
		List<String> imagenames = candidateFiles.getImageNames();
		
		System.out.println("Finding matches...");
		if(targetFile.getValue()==null){
			filesout.setValue(matchFile(regEx.getValue(),candidateFiles.getImageDataList()));
		}else{
			filesout.setValue(matchFile(regEx.getValue(),targetFile.getValue(),candidateFiles.getImageDataList()));
		}
		System.out.println(filesout.getValue());
	}

	public ArrayList<ImageData> matchFile(String expression, File target, List<ImageData> toMatch){
		
		Pattern p = Pattern.compile(expression);
		Matcher m = p.matcher(target.getName());
		m.find();
		String tagExp = target.getName().substring(m.start(), m.end());

		Pattern pt = Pattern.compile(tagExp);
		
		ArrayList<ImageData> matches = new ArrayList<ImageData>();
		
		for(ImageData s : toMatch){
			Matcher mat = pt.matcher(s.getName());
			if(mat.find()){
				matches.add(s);
			}
		}

		return matches;

	}

	public ArrayList<ImageData> matchFile(String expression,List<ImageData> toMatch){
		Pattern pt = Pattern.compile(expression);
		ArrayList<ImageData> matches = new ArrayList<ImageData>();
		for(ImageData s : toMatch){
			Matcher mat = pt.matcher(s.getName());
			if(mat.find()){
				matches.add(s);
			}
		}
		return matches;
	}

}

