package edu.jhu.ece.iacl.plugins.utilities.file;

import edu.jhu.ece.iacl.io.CurveVtkReaderWriter;
import edu.jhu.ece.iacl.io.FiberCollectionReaderWriter;
import edu.jhu.ece.iacl.pipeline.AlgorithmInformation;
import edu.jhu.ece.iacl.pipeline.AlgorithmRuntimeException;
import edu.jhu.ece.iacl.pipeline.CalculationMonitor;
import edu.jhu.ece.iacl.pipeline.ProcessingAlgorithm;
import edu.jhu.ece.iacl.pipeline.AlgorithmInformation.AlgorithmAuthor;
import edu.jhu.ece.iacl.pipeline.parameter.ParamCollection;
import edu.jhu.ece.iacl.pipeline.parameter.ParamObject;
import edu.jhu.ece.iacl.structures.fiber.FiberCollection;
import edu.jhu.ece.iacl.structures.geom.CurveCollection;

public class MedicAlgorithmFibersToVtk extends ProcessingAlgorithm {

	//input params
	private ParamObject<FiberCollection> fibers;
	
	//ouputparams
	private ParamObject<CurveCollection> fiberLines;
	
	private static final String rcsid =
		"$Id: MedicAlgorithmFibersToVtk.java,v 1.1 2008/12/10 16:44:19 bogovic Exp $";
	private static final String cvsversion =
		"$Revision: 1.1 $";
	private static final String revnum = cvsversion.replace("Revision: ", "").replace("$", "");

	
	@Override
	protected void createInputParameters(ParamCollection inputParams) {
		
		inputParams.add(fibers=new ParamObject<FiberCollection>("Input Parameters",new FiberCollectionReaderWriter()));
		
		inputParams.setName("fibersToVtk");
		inputParams.setCategory("IACL.DTI");
		inputParams.setLabel("Fibers to VTK");
		
		AlgorithmInformation info=getAlgorithmInformation();
		info.setWebsite("");
		info.add(new AlgorithmAuthor("John Bogovic","bogovic@jhu.edu",""));
		info.setDescription("Converts a FiberCollection to VTK format");
		info.setAffiliation("Johns Hopkins University, Departments of Electrical and Biomedical Engineering");	
		info.setVersion(revnum);	
	}

	@Override
	protected void createOutputParameters(ParamCollection outputParams) {
		outputParams.add(fiberLines=new ParamObject<CurveCollection>("VTK Fibers", new CurveVtkReaderWriter()));
	}

	@Override
	protected void execute(CalculationMonitor monitor)
			throws AlgorithmRuntimeException {
		fiberLines.setObject(fibers.getObject().toCurveCollection());
		fiberLines.setFileName(fibers.getObject().getName()+"_tovtk");
	}

}
