/**
 * 
 */
package edu.jhu.ece.iacl.plugins.utilities.file;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

import edu.jhu.ece.iacl.io.ArrayObjectTxtReaderWriter;
import edu.jhu.ece.iacl.io.StringReaderWriter;
import edu.jhu.ece.iacl.pipeline.AlgorithmRuntimeException;
import edu.jhu.ece.iacl.pipeline.CalculationMonitor;
import edu.jhu.ece.iacl.pipeline.ProcessingAlgorithm;
import edu.jhu.ece.iacl.pipeline.parameter.ParamCollection;
import edu.jhu.ece.iacl.pipeline.parameter.ParamObject;
import edu.jhu.ece.iacl.pipeline.parameter.ParamVolume;
import edu.jhu.ece.iacl.structures.image.ImageDataMipav;


/**
 * @author Blake Lucas (bclucas@jhu.edu)
 *
 */
public class MedicAlgorithmIdentifySubject extends ProcessingAlgorithm{
	ParamObject<String> codeBook;
	ParamVolume vol;
	ParamVolume nvol;
	protected void createInputParameters(ParamCollection inputParams) {
		inputParams.add(vol=new ParamVolume("Volume"));
		inputParams.add(codeBook=new ParamObject<String>("Code Book",new StringReaderWriter()));
		inputParams.setName("id_subject");
		inputParams.setLabel("Identify Subject");
		inputParams.setCategory("IACL.Utilities.File");
	}
	protected void createOutputParameters(ParamCollection outputParams) {
		outputParams.add(nvol=new ParamVolume("Identified Volume"));
	}
	protected void execute(CalculationMonitor monitor) throws AlgorithmRuntimeException {
		ImageDataMipav v=vol.getImageData();
		String name=v.getName();
		String new_name=name;
		String cb=codeBook.getObject();
		Pattern id_pattern=Pattern.compile("cort\\d\\d\\d[a-zA-Z]");
		Matcher m=id_pattern.matcher(name);
		
		if(m.find()){
			String id=name.substring(m.start(),m.end());
			Matcher m2=Pattern.compile(id).matcher(cb);
			if(m2.find()){
				String txt=cb.substring(m2.end(),Math.min(cb.length(),m2.end()+1000));
				Matcher m3=Pattern.compile("\\s+[a-zA-Z][a-zA-Z]\\d\\d_").matcher(txt);
				if(m3.find()){
					txt=txt.substring(m3.start(),m3.end());
					String[] strs=txt.split("\\D+");
					if(strs.length>0){
						new_name=name.substring(m.start(),m.end()-1)+"_"+strs[1]+name.substring(m.end(),name.length());
					} else {
						System.out.println("Colud not find numerical index");
					}
				} else {
					System.out.println("Could not find decoded id in code book");
				}
			} else {
				System.out.println("Could not find id in code book");
			}
		} else {
			System.out.println("Could not find id in volume file name");
		}
		v.setName(new_name);
		nvol.setValue(v);
	}
	
}
