package edu.jhu.ece.iacl.plugins.utilities.file;

import edu.jhu.ece.iacl.io.*;
import edu.jhu.ece.iacl.pipeline.CalculationMonitor;
import edu.jhu.ece.iacl.pipeline.ProcessingAlgorithm;
import edu.jhu.ece.iacl.pipeline.parameter.ParamCollection;
import edu.jhu.ece.iacl.pipeline.parameter.ParamOption;
import edu.jhu.ece.iacl.pipeline.parameter.ParamSurface;
import edu.jhu.ece.iacl.pipeline.parameter.ParamBoolean;
import edu.jhu.ece.iacl.pipeline.parameter.ParamPointInteger;
import edu.jhu.ece.iacl.pipeline.parameter.ParamPointDouble;
import edu.jhu.ece.iacl.structures.geom.EmbeddedSurface;

import javax.vecmath.Point3f;
import javax.vecmath.Matrix3f;

public class MedicAlgorithmSurfaceConverter extends ProcessingAlgorithm{
	private ParamSurface surfParam;
	private ParamSurface newSurf;
	private ParamOption outputType;
	
	private ParamBoolean		useMipavCoordinates;
	private ParamPointInteger 	imageDim;
	private	ParamPointDouble	imageRes;
	
	protected void createInputParameters(ParamCollection inputParams) {
		inputParams.add(surfParam=new ParamSurface("Surface"));
		inputParams.add(outputType=new ParamOption("File Type",new String[]{"VTK","VRML","DX","FreeSurfer","Mipav","BrainSuite"}));
		
		inputParams.add(useMipavCoordinates=new ParamBoolean("map to MIPAV coordinates"));
		inputParams.add(imageDim=new ParamPointInteger("Image Dimensions"));
		inputParams.add(imageRes=new ParamPointDouble("Image Resolutions"));
		
		inputParams.setLabel("Surface Conversion");
		inputParams.setName("surfconvert");
		inputParams.setCategory("IACL.Utilities.File");
	}
	protected void createOutputParameters(ParamCollection outputParams) {
		outputParams.add(newSurf=new ParamSurface("Surface"));
	}
	protected void execute(CalculationMonitor monitor) {
		switch(outputType.getIndex()){
			case 0:newSurf.setReaderWriter(new SurfaceVtkReaderWriter());break;
			case 1:newSurf.setReaderWriter(new SurfaceVrmlReaderWriter());break;
			case 2:newSurf.setReaderWriter(new SurfaceDxReaderWriter());break;
			case 3:newSurf.setReaderWriter(new SurfaceFreeSurferReaderWriter());break;
			case 4:newSurf.setReaderWriter(new SurfaceMipavReaderWriter());break;
			case 5:newSurf.setReaderWriter(new SurfaceBrainSuiteReaderWriter());break;
		}
		EmbeddedSurface surf=surfParam.getSurface();
			
		if (useMipavCoordinates.getValue()) {
			float[] box = new float[3];
			
			box[0] = (float)((0.5f*imageDim.getValue().x-0) * imageRes.getValue().x);
			box[1] = (float)((0.5f*imageDim.getValue().y-0) * imageRes.getValue().y);
			box[2] = (float)((0.5f*imageDim.getValue().z-0) * imageRes.getValue().z);
			
			surf.scaleVertices(new float[]{-(float)imageRes.getValue().x, -(float)imageRes.getValue().y, -(float)imageRes.getValue().z});
			Point3f pt = new Point3f(box[0],box[1],box[2]);
			Matrix3f rt = new Matrix3f(1,0,0,0,0,-1,0,1,0);
			surf.affineTransformVertices(rt,pt);
			surf.computeNormals();
		}
		newSurf.setValue(surf);
	}

}
