package edu.jhu.ece.iacl.plugins.utilities.file;

import java.util.Vector;

import edu.jhu.ece.iacl.io.*;
import edu.jhu.ece.iacl.pipeline.CalculationMonitor;
import edu.jhu.ece.iacl.pipeline.ProcessingAlgorithm;
import edu.jhu.ece.iacl.pipeline.parameter.ParamCollection;
import edu.jhu.ece.iacl.pipeline.parameter.ParamOption;
import edu.jhu.ece.iacl.pipeline.parameter.ParamSurface;
import edu.jhu.ece.iacl.pipeline.parameter.ParamBoolean;
import edu.jhu.ece.iacl.pipeline.parameter.ParamPointInteger;
import edu.jhu.ece.iacl.pipeline.parameter.ParamPointDouble;
import edu.jhu.ece.iacl.pipeline.parameter.ParamVolume;
import edu.jhu.ece.iacl.structures.geom.EmbeddedSurface;

import javax.vecmath.Point3f;
import javax.vecmath.Matrix3f;

public class MedicAlgorithmVolumeConverter extends ProcessingAlgorithm{
	private ParamVolume volParam;
	private ParamVolume newVol;
	private ParamOption outputType;
	
	private CubicVolumeReaderWriter readerWriter;
	protected void createInputParameters(ParamCollection inputParams) {
		inputParams.add(volParam=new ParamVolume("Volume"));
		readerWriter=new CubicVolumeReaderWriter();
		Vector<String> exts=readerWriter.getExtensionFilter().getExtensions();
		inputParams.add(outputType=new ParamOption("File Type",exts));
		outputType.setValue("xml");
		inputParams.setLabel("Volume Conversion");
		inputParams.setName("volconvert");
		inputParams.setCategory("IACL.Utilities.File");
	}
	protected void createOutputParameters(ParamCollection outputParams) {
		outputParams.add(newVol=new ParamVolume("Volume"));
		newVol.setReaderWriter(readerWriter);
	}
	protected void execute(CalculationMonitor monitor) {
		readerWriter.getExtensionFilter().setPreferredExtension(outputType.getValue());
		newVol.setValue(volParam.getImageData());
	}

}
