package edu.jhu.ece.iacl.plugins.utilities.file;

import java.util.Vector;

import edu.jhu.ece.iacl.io.CubicVolumeReaderWriter;
import edu.jhu.ece.iacl.pipeline.CalculationMonitor;
import edu.jhu.ece.iacl.pipeline.ProcessingAlgorithm;
import edu.jhu.ece.iacl.pipeline.parameter.ParamCollection;
import edu.jhu.ece.iacl.pipeline.parameter.ParamOption;
import edu.jhu.ece.iacl.pipeline.parameter.ParamVolume;

public class MedicAlgorithmVolumeConverter4D extends ProcessingAlgorithm{
	private ParamVolume volParam;
	private ParamVolume newVol;
	private ParamOption outputType;

	private CubicVolumeReaderWriter readerWriter;
	protected void createInputParameters(ParamCollection inputParams) {
		inputParams.add(volParam=new ParamVolume("Volume",null,-1,-1,-1,-1));
		readerWriter=new CubicVolumeReaderWriter();
		Vector<String> exts=readerWriter.getExtensionFilter().getExtensions();
		inputParams.add(outputType=new ParamOption("File Type",exts));
		outputType.setValue("xml");
		inputParams.setLabel("Volume Conversion 4D");
		inputParams.setName("volconvert4d");
		inputParams.setCategory("IACL.Utilities.File");
	}
	protected void createOutputParameters(ParamCollection outputParams) {
		outputParams.add(newVol=new ParamVolume("VolumeOut",null,-1,-1,-1,-1));
		newVol.setReaderWriter(readerWriter);
	}
	protected void execute(CalculationMonitor monitor) {
		readerWriter.getExtensionFilter().setPreferredExtension(outputType.getValue());
		newVol.setValue(volParam.getImageData());
	}
}