package edu.jhu.ece.iacl.plugins.utilities.logic;

import edu.jhu.ece.iacl.pipeline.AlgorithmRuntimeException;
import edu.jhu.ece.iacl.pipeline.CalculationMonitor;
import edu.jhu.ece.iacl.pipeline.ProcessingAlgorithm;
import edu.jhu.ece.iacl.pipeline.parameter.*;

public class MedicAlgorithmValueEquals extends ProcessingAlgorithm{
	protected ParamDouble tolerance;
	protected ParamDouble value1;
	protected ParamDouble value2;
	protected ParamBoolean assertTrue;
		protected void createInputParameters(ParamCollection inputParams) {
			setRunningInSeparateProcess(false);
			inputParams.add(value1=new ParamDouble("Value 1"));
			inputParams.add(value2=new ParamDouble("Value 2"));
			inputParams.add(tolerance=new ParamDouble("Tolerance",1E-6));
			inputParams.setName("val_equals");
			inputParams.setLabel("Value Equals");
			inputParams.setCategory("IACL.Utilities.Logic");
		}
		protected void createOutputParameters(ParamCollection outputParams) {
			outputParams.add(assertTrue=new ParamBoolean("Assertion"));
		}
		protected void execute(CalculationMonitor monitor) throws AlgorithmRuntimeException {
			double val1=value1.getDouble();
			double val2=value2.getDouble();
			double tol=tolerance.getDouble();
			assertTrue.setValue(Math.abs(val1-val2)<=tol);
		}
}
