package edu.jhu.ece.iacl.plugins.utilities.logic;

import edu.jhu.ece.iacl.pipeline.AlgorithmInformation;
import edu.jhu.ece.iacl.pipeline.AlgorithmRuntimeException;
import edu.jhu.ece.iacl.pipeline.CalculationMonitor;
import edu.jhu.ece.iacl.pipeline.DevelopmentStatus;
import edu.jhu.ece.iacl.pipeline.ProcessingAlgorithm;
import edu.jhu.ece.iacl.pipeline.AlgorithmInformation.AlgorithmAuthor;
import edu.jhu.ece.iacl.pipeline.parameter.*;

public class MedicAlgorithmValueGreaterThan extends ProcessingAlgorithm{
	/****************************************************
	 * Input Parameters
	 ****************************************************/
	protected ParamDouble lowerBound;
	protected ParamDouble value;
	protected ParamBoolean inclusive;
	/****************************************************
	 * Output Parameters
	 ****************************************************/
	protected ParamBoolean assertTrue;
	
	/****************************************************
	 * CVS
	 ****************************************************/
	private static final String rcsid =
		"$Id: MedicAlgorithmValueGreaterThan.java,v 1.2 2009/03/21 07:23:15 jhuuser Exp $";
	private static final String cvsversion =
		"$Revision: 1.2 $";
	private static final String revnum = cvsversion.replace("Revision: ", "").replace("$", "");
	
	protected void createInputParameters(ParamCollection inputParams) {
		/****************************************************
		 * Plugin Information
		 ****************************************************/
		inputParams.setName("val_greater_than");
		inputParams.setLabel("Value Greater Than");
		inputParams.setCategory("IACL.Utilities.Logic");
		
		AlgorithmInformation info=getAlgorithmInformation();
		info.setWebsite("Unknown website");
		info.add(new AlgorithmAuthor("Unknown Author","Unknown","website unknown"));
		info.setDescription("Determines whether an input ParamDouble value is greater than (or equal to, when the ParamBoolean inclusive is true)" +
				"the ParamDouble value lowerBound.");
		info.setAffiliation("Johns Hopkins University, Department of Biomedical Engineering");
		info.setVersion(revnum);
		info.setStatus(DevelopmentStatus.UNKNOWN);
		
		/****************************************************
		 * Creating inputs
		 ****************************************************/		
		setRunningInSeparateProcess(false);
		inputParams.add(value=new ParamDouble("Value"));
		inputParams.add(lowerBound=new ParamDouble("Lower Bound"));
		inputParams.add(inclusive=new ParamBoolean("Include Bound",true));
		
	}
	protected void createOutputParameters(ParamCollection outputParams) {
		/****************************************************
		 * Creating outputs
		 ****************************************************/
		outputParams.add(assertTrue=new ParamBoolean("Assertion"));
	}
	protected void execute(CalculationMonitor monitor) throws AlgorithmRuntimeException {
		double val=value.getDouble(); //gets the double value of the ParamDouble value
		double lower=lowerBound.getDouble(); //gets the double value of the ParamDouble lowerBound
		if(inclusive.getValue()){ //if the ParamBoolean inclusive is true
			assertTrue.setValue((val>=lower)); //then the ParamBoolean assertTrue is set to true when val is greater than OR equal to lower
		} else { //if the ParamBoolean inclusive is false
			assertTrue.setValue((val>lower)); //then the ParamBoolean assertTrue is set to true when val is greater than lower
		}
	}
}
