package edu.jhu.ece.iacl.plugins.utilities.math;

import edu.jhu.ece.iacl.pipeline.CalculationMonitor;
import edu.jhu.ece.iacl.pipeline.ProcessingAlgorithm;
import edu.jhu.ece.iacl.pipeline.parameter.ParamCollection;
import edu.jhu.ece.iacl.pipeline.parameter.ParamDouble;


public class MedicAlgorithmArithmetic extends ProcessingAlgorithm {

	ParamDouble a, b, sum, difference, product, quotient;

	protected void createInputParameters(ParamCollection inputParams) {
		inputParams.add(a = new ParamDouble("a"));
		inputParams.add(b = new ParamDouble("b"));
		inputParams.setLabel("Arithmetic");
		inputParams.setName("arithmetic");
		inputParams.setCategory("IACL.Utilities.Math");
	}

	@Override
	protected void createOutputParameters(ParamCollection outputParams) {
		outputParams.add(sum = new ParamDouble("a+b"));
		outputParams.add(difference = new ParamDouble("a-b"));
		outputParams.add(product = new ParamDouble("a*b"));
		outputParams.add(quotient = new ParamDouble("a/b"));
	}

	@Override
	protected void execute(CalculationMonitor monitor) {
		sum.setValue(a.getFloat()+b.getFloat());
		difference.setValue(a.getFloat()-b.getFloat());
		product.setValue(a.getFloat()*b.getFloat());
		quotient.setValue(a.getFloat()/b.getFloat());
		
	}

}
