package edu.jhu.ece.iacl.plugins.utilities.surface;

import edu.jhu.ece.iacl.io.ArrayDoubleReaderWriter;
import edu.jhu.ece.iacl.io.ArrayDoubleTxtReaderWriter;
import edu.jhu.ece.iacl.io.FileExtensionFilter;
import edu.jhu.ece.iacl.io.FileReaderWriter;
import edu.jhu.ece.iacl.pipeline.CalculationMonitor;
import edu.jhu.ece.iacl.pipeline.ProcessingAlgorithm;
import edu.jhu.ece.iacl.pipeline.parameter.ParamCollection;
import edu.jhu.ece.iacl.pipeline.parameter.ParamFile;
import edu.jhu.ece.iacl.pipeline.parameter.ParamObject;
import edu.jhu.ece.iacl.pipeline.parameter.ParamOption;
import edu.jhu.ece.iacl.pipeline.parameter.ParamSurface;
import edu.jhu.ece.iacl.structures.geom.EmbeddedSurface;

public class MedicAlgorithmCopyEmbeddedData extends ProcessingAlgorithm{
	ParamSurface srcSurf;
	ParamSurface destSurf;
	ParamSurface outSurf;
	ParamOption replaceorappend;

	protected void createInputParameters(ParamCollection inputParams) {
		inputParams.add(srcSurf=new ParamSurface("Source Surface"));
		inputParams.add(destSurf=new ParamSurface("Destination Surface"));
		inputParams.add(replaceorappend=new ParamOption("Method",new String[]{"Append","Replace"}));
		inputParams.setLabel("Copy Embedded Data");
		inputParams.setName("copydata");
		inputParams.setCategory("IACL.Utilities.Surface");
	}

	@Override
	protected void createOutputParameters(ParamCollection outputParams) {
		outputParams.add(outSurf=new ParamSurface("Embedded Surface"));
	}

	@Override
	protected void execute(CalculationMonitor monitor) {
		
		if(replaceorappend.getIndex()==0){
			EmbeddedSurface surfDup=new EmbeddedSurface(destSurf.getSurface(),srcSurf.getSurface().getVertexData());
			surfDup.setName(destSurf.getSurface().getName()+"_copy");
			outSurf.setValue(surfDup);
		} else {
			EmbeddedSurface surfDup=destSurf.getSurface();
			surfDup.setName(destSurf.getSurface().getName()+"_copy");
			surfDup.setVertexData(srcSurf.getSurface().getVertexData());
			outSurf.setValue(surfDup);
		}
	}

}
