package edu.jhu.ece.iacl.plugins.utilities.volume;

import edu.jhu.ece.iacl.io.CubicVolumeReaderWriter;
import edu.jhu.ece.iacl.io.FileExtensionFilter;
import edu.jhu.ece.iacl.io.ModelImageReaderWriter;
import edu.jhu.ece.iacl.io.StringReaderWriter;
import edu.jhu.ece.iacl.pipeline.CalculationMonitor;
import edu.jhu.ece.iacl.pipeline.ProcessingAlgorithm;
import edu.jhu.ece.iacl.pipeline.parameter.ParamBoolean;
import edu.jhu.ece.iacl.pipeline.parameter.ParamCollection;
import edu.jhu.ece.iacl.pipeline.parameter.ParamFileCollection;
import edu.jhu.ece.iacl.pipeline.parameter.ParamInteger;
import edu.jhu.ece.iacl.pipeline.parameter.ParamObject;
import edu.jhu.ece.iacl.pipeline.parameter.ParamVolume;
import edu.jhu.ece.iacl.pipeline.parameter.ParamVolumeCollection;
import edu.jhu.ece.iacl.structures.image.ImageData;
import edu.jhu.ece.iacl.structures.image.ImageDataMipav;
import edu.jhu.ece.iacl.utility.FileUtil;
import gov.nih.mipav.model.structures.ModelImage;


import java.io.File;
import java.util.List;

public class MedicAlgorithmConcatMultiImages extends ProcessingAlgorithm{

//	private ParamVolume a;
//	private ParamVolume b;
	private ParamFileCollection volsin;
	private ParamVolume volout;
	private ParamBoolean sort;
	
	private CubicVolumeReaderWriter rw = CubicVolumeReaderWriter.getInstance();
	
	protected void createInputParameters(ParamCollection inputParams) {
		
		inputParams.add(volsin=new ParamFileCollection("Volumes In", new FileExtensionFilter(ModelImageReaderWriter.supportedFileExtensions)));
		inputParams.add(sort = new ParamBoolean("Autosort"));
		sort.setValue(false);
//		inputParams.add(vecimg=new ParamVolume("Vector Field",null,3,-1,-1,-1));
//		inputParams.add(target=new ParamInteger("Mask Target Value"));
		inputParams.setName("cat_imgs_multi");
		inputParams.setLabel("ConcatMultiImages");
		inputParams.setCategory("IACL.Utilities.Volume");
		
	}
	protected void createOutputParameters(ParamCollection outputParams) {
		outputParams.add(volout=new ParamVolume("Combined Volume",null,-1,-1,-1,-1));
		
	}
	protected void execute(CalculationMonitor monitor) {
		boolean asort = sort.getValue();
		
		List<File> vollist = volsin.getValue();
		System.out.println("volsin: " + volsin);
		System.out.println("list: " + vollist);
		
		ImageData vol = rw.read(volsin.getValue(0));
		
		
		ImageDataMipav outvol = new ImageDataMipav(volsin.getValue().get(0).getName(),
				vol.getType(),vol.getRows(),vol.getCols(),vol.getSlices(),vollist.size());
		
		int[] ext=vol.getModelImage().getExtents();
		int[] ext4 = new int[4];
		for(int i=0; i<3; i++){
			ext4[i]=ext[i];
		}
		ext4[3]=vollist.size();
		
		if(asort){
			System.out.println("Setting volumes");
			for(int i=0; i<vollist.size(); i++){
				String findme = "Volume"+i;
				System.out.println(findme);
				boolean found = false;
				for(int j=0; j<vollist.size(); j++){
					if(vollist.get(j).getName().contains(findme)){
						setIthVol(outvol,rw.read(vollist.get(j)),i);
						found = true;
						break;
					}
				}
				if(found==false){
					System.out.println("Volume not found!");
				}
			}
		}else{
			System.out.println("Setting volumes");
			for(int i=0; i<vollist.size(); i++){
				setIthVol(outvol,rw.read(vollist.get(i)),i);
			}
		}
		
		ModelImage img=(outvol).getModelImage();
		FileUtil.updateFileInfo(vol.getModelImage(),img);
		img.calcMinMax();
//		float[] res = img.getResolutions(0);
//		for(int j=0; j<res.length; j++){
//			System.out.println("Resolution Dim " + j + ": " + res[j]);
//		}
//		img.setExtents(ext);
		
		volout.setValue(outvol);
		
	}
	
	private void setIthVol(ImageData container, ImageData elem, int index){
		
		if(container.getRows()!=elem.getRows() || container.getCols()!=elem.getCols() ||container.getSlices()!=elem.getSlices()){
			System.err.println("Dimensions of element must match dimensions of container");
		}
		
		for(int i=0; i<elem.getRows(); i++){
			for(int j=0; j<elem.getCols(); j++){
				for(int k=0; k<elem.getSlices(); k++){
					container.set(i, j, k, index, elem.getDouble(i, j, k));
				}
			}
		}
		
	}
	
}

