package edu.jhu.ece.iacl.plugins.utilities.volume;

import java.util.ArrayList;

import edu.jhu.ece.iacl.io.StringReaderWriter;
import edu.jhu.ece.iacl.pipeline.CalculationMonitor;
import edu.jhu.ece.iacl.pipeline.ProcessingAlgorithm;
import edu.jhu.ece.iacl.pipeline.parameter.ParamCollection;
import edu.jhu.ece.iacl.pipeline.parameter.ParamVolumeCollection;
import edu.jhu.ece.iacl.pipeline.parameter.ParamVolume;
import edu.jhu.ece.iacl.pipeline.parameter.ParamObject;
import edu.jhu.ece.iacl.pipeline.parameter.ParamInteger;
import edu.jhu.ece.iacl.structures.image.ImageData;
import edu.jhu.ece.iacl.structures.image.ImageDataMipav;
import edu.jhu.ece.iacl.utility.FileUtil;
import gov.nih.mipav.model.structures.ModelImage;

public class MedicAlgorithmExtractAllComponents extends ProcessingAlgorithm{

	private ParamVolume in;
	private ParamInteger dim;
	private ParamVolumeCollection out;
	private ParamObject<String> filelist;
	
	protected void createInputParameters(ParamCollection inputParams) {
		inputParams.add(in=new ParamVolume("Mult-Component Volume",null,-1,-1,-1,-1));
		inputParams.add(dim=new ParamInteger("Dimension to Extract"));
		dim.setValue(new Integer(3));
		inputParams.setName("extractAllComponents");
		inputParams.setCategory("IACL.Utilities.Volume");
		inputParams.setLabel("Extract All Components");
	}
	protected void createOutputParameters(ParamCollection outputParams) {	
		outputParams.add(out=new ParamVolumeCollection("Volumes Out",null,-1,-1,-1,1));
		outputParams.add(filelist=new ParamObject<String>("File List",new StringReaderWriter()));
	}
	
	protected void execute(CalculationMonitor monitor) {
	
		ArrayList<ImageData> listout = new ArrayList<ImageData>();
        ImageDataMipav vol = in.getImageData();
        
//        for(int k=0; k<vol.getComponents(); k++){
//          //For a 3d volume, make sure the component is set to 1 and not 0
//            listout.add(new CubicVolumeMipav("Volume"+k,vol.getType(),vol.getRows(), vol.getCols(), vol.getSlices(),1));
//        }
       
        if(dim.getValue().intValue()==3){
        	System.out.println(vol.getType());
        	for(int l=0; l<vol.getComponents(); l++){
        		ImageDataMipav nextvol = new ImageDataMipav(vol.getName()+"_Volume"+l,vol.getType(),vol.getRows(), vol.getCols(), vol.getSlices());
        		for(int i=0;i<vol.getRows();i++){
        			for(int j=0;j<vol.getCols();j++){
        				for(int k=0;k<vol.getSlices();k++){

//      					if(vol.get(i, j, k, l).shortValue()!=0){
//      					System.out.println(vol.get(i, j, k, l));
//      					}
        					nextvol.set(i, j, k, vol.getDouble(i, j, k, l));
        				}
        			}
        		}   
        		System.out.println("Completed " +l+"th bolume");
        		
        		/* Update Header information*/
        		ModelImage img=(nextvol).getModelImage();
        		FileUtil.updateFileInfo(vol.getModelImage(),img);
        		img.calcMinMax();
        		
        		listout.add(nextvol);
        	}
        }else if(dim.getValue().intValue()==2){
        	System.out.println(vol.getType());
        	for(int l=0; l<vol.getSlices(); l++){
//        	for(int l=86; l<88; l++){
        		ImageDataMipav nextvol = new ImageDataMipav(vol.getName()+"_Volume"+l,vol.getType(),vol.getRows(), vol.getCols(), vol.getComponents());
        		for(int i=0;i<vol.getRows();i++){
        			for(int j=0;j<vol.getCols();j++){
        				for(int k=0;k<vol.getComponents();k++){

        					nextvol.set(i, j, k, vol.getDouble(i, j, l, k));
        				}
        			}
        		}   
        		System.out.println("Completed " +l+"th bolume");
        		/* Update Header information*/
        		ModelImage img=(nextvol).getModelImage();
        		FileUtil.updateFileInfo(vol.getModelImage(),img);
        		img.calcMinMax();
        		listout.add(nextvol);
        	}
        }else if(dim.getValue().intValue()==1){
        	System.out.println(vol.getType());
        	for(int l=0; l<vol.getCols(); l++){
        		ImageDataMipav nextvol = new ImageDataMipav(vol.getName()+"_Volume"+l,vol.getType(),vol.getRows(), vol.getSlices(), vol.getComponents());
        		for(int i=0;i<vol.getRows();i++){
        			for(int j=0;j<vol.getSlices();j++){
        				for(int k=0;k<vol.getComponents();k++){

//      					if(vol.get(i, j, k, l).shortValue()!=0){
//      					System.out.println(vol.get(i, j, k, l));
//      					}
        					nextvol.set(i, j, k, vol.getDouble(i, l, j, k));
        				}
        			}
        		}   
        		System.out.println("Completed " +l+"th bolume");
        		/* Update Header information*/
        		ModelImage img=(nextvol).getModelImage();
        		FileUtil.updateFileInfo(vol.getModelImage(),img);
        		img.calcMinMax();
        		listout.add(nextvol);
        	}
        }
        else if(dim.getValue().intValue()==0){
        	System.out.println(vol.getType());
        	for(int l=0; l<vol.getRows(); l++){
        		ImageDataMipav nextvol = new ImageDataMipav(vol.getName()+"_Volume"+l,vol.getType(),vol.getCols(), vol.getSlices(), vol.getComponents());
        		for(int i=0;i<vol.getCols();i++){
        			for(int j=0;j<vol.getSlices();j++){
        				for(int k=0;k<vol.getComponents();k++){

//      					if(vol.get(i, j, k, l).shortValue()!=0){
//      					System.out.println(vol.get(i, j, k, l));
//      					}
        					nextvol.set(i, j, k, vol.getDouble(l, i, j, k));
        				}
        			}
        		}   
        		System.out.println("Completed " +l+"th bolume");
        		/* Update Header information*/
        		ModelImage img=(nextvol).getModelImage();
        		FileUtil.updateFileInfo(vol.getModelImage(),img);
        		img.calcMinMax();
        		listout.add(nextvol);
        	}
        }
        listout.trimToSize();
        out.setValue(listout);
        
        
    //Specify the object for the output file
        filelist.setObject("FileLIst");
    //specify the file name for the output file
        filelist.setFileName("filelist.txt");
        
       
		
	}
	

}
