/**
 * 
 */
package edu.jhu.ece.iacl.plugins.utilities.volume;

import java.util.ArrayList;

import edu.jhu.ece.iacl.pipeline.AlgorithmRuntimeException;
import edu.jhu.ece.iacl.pipeline.CalculationMonitor;
import edu.jhu.ece.iacl.pipeline.ProcessingAlgorithm;
import edu.jhu.ece.iacl.pipeline.parameter.ParamBoolean;
import edu.jhu.ece.iacl.pipeline.parameter.ParamCollection;
import edu.jhu.ece.iacl.pipeline.parameter.ParamInteger;
import edu.jhu.ece.iacl.pipeline.parameter.ParamString;
import edu.jhu.ece.iacl.pipeline.parameter.ParamVolume;
import edu.jhu.ece.iacl.pipeline.parameter.ParamVolumeCollection;
import edu.jhu.ece.iacl.structures.image.ImageDataMipav;
import edu.jhu.ece.iacl.structures.image.VoxelType;
import edu.jhu.ece.iacl.utility.FileUtil;
import gov.nih.mipav.model.structures.ModelImage;

/**
 * @author Blake Lucas (bclucas@jhu.edu)
 *
 */
public class MedicAlgorithmExtractVolumeComponent extends ProcessingAlgorithm{
	ParamInteger stIndex;
	ParamInteger endIndex;
	ParamString range;
	ParamBoolean split;
	ParamVolume inVol;
	ParamVolume outVol;
	ParamVolumeCollection splitVols;
	protected void createInputParameters(ParamCollection inputParams) {
		inputParams.add(inVol=new ParamVolume("Mult-Component Volume",null,-1,-1,-1,-1));
		inputParams.add(stIndex=new ParamInteger("Start Index",0,1000000,0));
		inputParams.add(endIndex=new ParamInteger("End Index",0,1000000,0));
		inputParams.add(split = new ParamBoolean("Split output volumes?"));
		split.setValue(false);
		inputParams.setLabel("Extract Volume Component");
		inputParams.setName("extract_vol_comp");
		inputParams.setCategory("IACL.Utilities.Volume");
	}
	protected void createOutputParameters(ParamCollection outputParams) {
		outputParams.add(outVol=new ParamVolume("Extracted Volume",null,-1,-1,-1,-1));
		outVol.setMandatory(false);
		outputParams.add(splitVols=new ParamVolumeCollection("Extracted and Split Volumes",null,-1,-1,-1,-1));
		splitVols.setMandatory(false);
	}

	/* (non-Javadoc)
	 * @see edu.jhu.ece.iacl.pipeline.ProcessingAlgorithm#execute(edu.jhu.ece.iacl.pipeline.CalculationMonitor)
	 */
	protected void execute(CalculationMonitor monitor) throws AlgorithmRuntimeException {
		ImageDataMipav vol=inVol.getImageData();
		ImageDataMipav cvol = null;
//		ImageDataMipav cvol= new ImageDataMipav("nothing",VoxelType.BOOLEAN,1,1,1,1);
		ArrayList<ImageDataMipav> splitlist = new ArrayList<ImageDataMipav>(); 
		if(split.getValue()){
			int st=stIndex.getInt();
			int end=endIndex.getInt();
			splitlist = new ArrayList<ImageDataMipav>(); 
			for(int l=st; l<end; l++){
				ImageDataMipav tvol=new ImageDataMipav(vol.getName()+"_"+l,vol.getType(),vol.getRows(),vol.getCols(),vol.getSlices(),1);
				for(int i=0;i<vol.getRows();i++){
					for(int j=0;j<vol.getCols();j++){
						for(int k=0;k<vol.getSlices();k++){
							tvol.set(i,j,k,0,vol.getDouble(i, j, k, l));

						}
					}
				}	
				
				ModelImage img=(tvol).getModelImage();
				FileUtil.updateFileInfo(vol.getModelImage(),img);
				img.calcMinMax();
				
				splitlist.add(tvol);
			}
		}else{
			int st=stIndex.getInt();
			int end=endIndex.getInt();
			
			int[] ext=vol.getModelImage().getExtents();
			int[] ext4 = new int[4];
			for(int i=0; i<3; i++){
				ext4[i]=ext[i];
			}
			ext4[3]=end-st;
			
			
			cvol=new ImageDataMipav(vol.getName()+"_"+st+"-"+end,vol.getType(),vol.getRows(),vol.getCols(),vol.getSlices(),end-st+1);
			for(int i=0;i<vol.getRows();i++){
				for(int j=0;j<vol.getCols();j++){
					for(int k=0;k<vol.getSlices();k++){
						for(int l=st;l<=end;l++){
							cvol.set(i,j,k,l-st,vol.getDouble(i, j, k, l));
						}
					}
				}
			}	
			
			ModelImage img=(cvol).getModelImage();
			FileUtil.updateFileInfo(vol.getModelImage(),img);
			img.calcMinMax();
			
		}
		splitVols.setValue(splitlist);
		if(cvol!=null){
			outVol.setValue(cvol);
		}
	}
	
}
